/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.lightsail.transform.LoadBalancerTlsCertificateDomainValidationOptionMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about the domain names on an SSL/TLS certificate that you will use to validate domain ownership.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LoadBalancerTlsCertificateDomainValidationOption
        implements
        StructuredPojo,
        ToCopyableBuilder<LoadBalancerTlsCertificateDomainValidationOption.Builder, LoadBalancerTlsCertificateDomainValidationOption> {
    private final String domainName;

    private final String validationStatus;

    private LoadBalancerTlsCertificateDomainValidationOption(BuilderImpl builder) {
        this.domainName = builder.domainName;
        this.validationStatus = builder.validationStatus;
    }

    /**
     * <p>
     * The fully qualified domain name in the certificate request.
     * </p>
     * 
     * @return The fully qualified domain name in the certificate request.
     */
    public String domainName() {
        return domainName;
    }

    /**
     * <p>
     * The status of the domain validation. Valid values are listed below.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #validationStatus}
     * will return {@link LoadBalancerTlsCertificateDomainStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #validationStatusAsString}.
     * </p>
     * 
     * @return The status of the domain validation. Valid values are listed below.
     * @see LoadBalancerTlsCertificateDomainStatus
     */
    public LoadBalancerTlsCertificateDomainStatus validationStatus() {
        return LoadBalancerTlsCertificateDomainStatus.fromValue(validationStatus);
    }

    /**
     * <p>
     * The status of the domain validation. Valid values are listed below.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #validationStatus}
     * will return {@link LoadBalancerTlsCertificateDomainStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #validationStatusAsString}.
     * </p>
     * 
     * @return The status of the domain validation. Valid values are listed below.
     * @see LoadBalancerTlsCertificateDomainStatus
     */
    public String validationStatusAsString() {
        return validationStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(domainName());
        hashCode = 31 * hashCode + Objects.hashCode(validationStatusAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LoadBalancerTlsCertificateDomainValidationOption)) {
            return false;
        }
        LoadBalancerTlsCertificateDomainValidationOption other = (LoadBalancerTlsCertificateDomainValidationOption) obj;
        return Objects.equals(domainName(), other.domainName())
                && Objects.equals(validationStatusAsString(), other.validationStatusAsString());
    }

    @Override
    public String toString() {
        return ToString.builder("LoadBalancerTlsCertificateDomainValidationOption").add("DomainName", domainName())
                .add("ValidationStatus", validationStatusAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "domainName":
            return Optional.ofNullable(clazz.cast(domainName()));
        case "validationStatus":
            return Optional.ofNullable(clazz.cast(validationStatusAsString()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        LoadBalancerTlsCertificateDomainValidationOptionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, LoadBalancerTlsCertificateDomainValidationOption> {
        /**
         * <p>
         * The fully qualified domain name in the certificate request.
         * </p>
         * 
         * @param domainName
         *        The fully qualified domain name in the certificate request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainName(String domainName);

        /**
         * <p>
         * The status of the domain validation. Valid values are listed below.
         * </p>
         * 
         * @param validationStatus
         *        The status of the domain validation. Valid values are listed below.
         * @see LoadBalancerTlsCertificateDomainStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LoadBalancerTlsCertificateDomainStatus
         */
        Builder validationStatus(String validationStatus);

        /**
         * <p>
         * The status of the domain validation. Valid values are listed below.
         * </p>
         * 
         * @param validationStatus
         *        The status of the domain validation. Valid values are listed below.
         * @see LoadBalancerTlsCertificateDomainStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LoadBalancerTlsCertificateDomainStatus
         */
        Builder validationStatus(LoadBalancerTlsCertificateDomainStatus validationStatus);
    }

    static final class BuilderImpl implements Builder {
        private String domainName;

        private String validationStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(LoadBalancerTlsCertificateDomainValidationOption model) {
            domainName(model.domainName);
            validationStatus(model.validationStatus);
        }

        public final String getDomainName() {
            return domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        public final String getValidationStatus() {
            return validationStatus;
        }

        @Override
        public final Builder validationStatus(String validationStatus) {
            this.validationStatus = validationStatus;
            return this;
        }

        @Override
        public final Builder validationStatus(LoadBalancerTlsCertificateDomainStatus validationStatus) {
            this.validationStatus(validationStatus.toString());
            return this;
        }

        public final void setValidationStatus(String validationStatus) {
            this.validationStatus = validationStatus;
        }

        @Override
        public LoadBalancerTlsCertificateDomainValidationOption build() {
            return new LoadBalancerTlsCertificateDomainValidationOption(this);
        }
    }
}
