/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.lightsail.transform.LoadBalancerTlsCertificateRenewalSummaryMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about the status of Lightsail's managed renewal for the certificate.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LoadBalancerTlsCertificateRenewalSummary implements StructuredPojo,
        ToCopyableBuilder<LoadBalancerTlsCertificateRenewalSummary.Builder, LoadBalancerTlsCertificateRenewalSummary> {
    private final String renewalStatus;

    private final List<LoadBalancerTlsCertificateDomainValidationOption> domainValidationOptions;

    private LoadBalancerTlsCertificateRenewalSummary(BuilderImpl builder) {
        this.renewalStatus = builder.renewalStatus;
        this.domainValidationOptions = builder.domainValidationOptions;
    }

    /**
     * <p>
     * The status of Lightsail's managed renewal of the certificate. Valid values are listed below.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #renewalStatus}
     * will return {@link LoadBalancerTlsCertificateRenewalStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #renewalStatusAsString}.
     * </p>
     * 
     * @return The status of Lightsail's managed renewal of the certificate. Valid values are listed below.
     * @see LoadBalancerTlsCertificateRenewalStatus
     */
    public LoadBalancerTlsCertificateRenewalStatus renewalStatus() {
        return LoadBalancerTlsCertificateRenewalStatus.fromValue(renewalStatus);
    }

    /**
     * <p>
     * The status of Lightsail's managed renewal of the certificate. Valid values are listed below.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #renewalStatus}
     * will return {@link LoadBalancerTlsCertificateRenewalStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #renewalStatusAsString}.
     * </p>
     * 
     * @return The status of Lightsail's managed renewal of the certificate. Valid values are listed below.
     * @see LoadBalancerTlsCertificateRenewalStatus
     */
    public String renewalStatusAsString() {
        return renewalStatus;
    }

    /**
     * <p>
     * Contains information about the validation of each domain name in the certificate, as it pertains to Lightsail's
     * managed renewal. This is different from the initial validation that occurs as a result of the RequestCertificate
     * request.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Contains information about the validation of each domain name in the certificate, as it pertains to
     *         Lightsail's managed renewal. This is different from the initial validation that occurs as a result of the
     *         RequestCertificate request.
     */
    public List<LoadBalancerTlsCertificateDomainValidationOption> domainValidationOptions() {
        return domainValidationOptions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(renewalStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(domainValidationOptions());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LoadBalancerTlsCertificateRenewalSummary)) {
            return false;
        }
        LoadBalancerTlsCertificateRenewalSummary other = (LoadBalancerTlsCertificateRenewalSummary) obj;
        return Objects.equals(renewalStatusAsString(), other.renewalStatusAsString())
                && Objects.equals(domainValidationOptions(), other.domainValidationOptions());
    }

    @Override
    public String toString() {
        return ToString.builder("LoadBalancerTlsCertificateRenewalSummary").add("RenewalStatus", renewalStatusAsString())
                .add("DomainValidationOptions", domainValidationOptions()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "renewalStatus":
            return Optional.ofNullable(clazz.cast(renewalStatusAsString()));
        case "domainValidationOptions":
            return Optional.ofNullable(clazz.cast(domainValidationOptions()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        LoadBalancerTlsCertificateRenewalSummaryMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, LoadBalancerTlsCertificateRenewalSummary> {
        /**
         * <p>
         * The status of Lightsail's managed renewal of the certificate. Valid values are listed below.
         * </p>
         * 
         * @param renewalStatus
         *        The status of Lightsail's managed renewal of the certificate. Valid values are listed below.
         * @see LoadBalancerTlsCertificateRenewalStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LoadBalancerTlsCertificateRenewalStatus
         */
        Builder renewalStatus(String renewalStatus);

        /**
         * <p>
         * The status of Lightsail's managed renewal of the certificate. Valid values are listed below.
         * </p>
         * 
         * @param renewalStatus
         *        The status of Lightsail's managed renewal of the certificate. Valid values are listed below.
         * @see LoadBalancerTlsCertificateRenewalStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LoadBalancerTlsCertificateRenewalStatus
         */
        Builder renewalStatus(LoadBalancerTlsCertificateRenewalStatus renewalStatus);

        /**
         * <p>
         * Contains information about the validation of each domain name in the certificate, as it pertains to
         * Lightsail's managed renewal. This is different from the initial validation that occurs as a result of the
         * RequestCertificate request.
         * </p>
         * 
         * @param domainValidationOptions
         *        Contains information about the validation of each domain name in the certificate, as it pertains to
         *        Lightsail's managed renewal. This is different from the initial validation that occurs as a result of
         *        the RequestCertificate request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainValidationOptions(Collection<LoadBalancerTlsCertificateDomainValidationOption> domainValidationOptions);

        /**
         * <p>
         * Contains information about the validation of each domain name in the certificate, as it pertains to
         * Lightsail's managed renewal. This is different from the initial validation that occurs as a result of the
         * RequestCertificate request.
         * </p>
         * 
         * @param domainValidationOptions
         *        Contains information about the validation of each domain name in the certificate, as it pertains to
         *        Lightsail's managed renewal. This is different from the initial validation that occurs as a result of
         *        the RequestCertificate request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainValidationOptions(LoadBalancerTlsCertificateDomainValidationOption... domainValidationOptions);

        /**
         * <p>
         * Contains information about the validation of each domain name in the certificate, as it pertains to
         * Lightsail's managed renewal. This is different from the initial validation that occurs as a result of the
         * RequestCertificate request.
         * </p>
         * This is a convenience that creates an instance of the {@link List
         * <LoadBalancerTlsCertificateDomainValidationOption>.Builder} avoiding the need to create one manually via
         * {@link List<LoadBalancerTlsCertificateDomainValidationOption>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List
         * <LoadBalancerTlsCertificateDomainValidationOption>.Builder#build()} is called immediately and its result is
         * passed to {@link #domainValidationOptions(List<LoadBalancerTlsCertificateDomainValidationOption>)}.
         * 
         * @param domainValidationOptions
         *        a consumer that will call methods on {@link List
         *        <LoadBalancerTlsCertificateDomainValidationOption>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #domainValidationOptions(List<LoadBalancerTlsCertificateDomainValidationOption>)
         */
        Builder domainValidationOptions(
                Consumer<LoadBalancerTlsCertificateDomainValidationOption.Builder>... domainValidationOptions);
    }

    static final class BuilderImpl implements Builder {
        private String renewalStatus;

        private List<LoadBalancerTlsCertificateDomainValidationOption> domainValidationOptions = DefaultSdkAutoConstructList
                .getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(LoadBalancerTlsCertificateRenewalSummary model) {
            renewalStatus(model.renewalStatus);
            domainValidationOptions(model.domainValidationOptions);
        }

        public final String getRenewalStatus() {
            return renewalStatus;
        }

        @Override
        public final Builder renewalStatus(String renewalStatus) {
            this.renewalStatus = renewalStatus;
            return this;
        }

        @Override
        public final Builder renewalStatus(LoadBalancerTlsCertificateRenewalStatus renewalStatus) {
            this.renewalStatus(renewalStatus.toString());
            return this;
        }

        public final void setRenewalStatus(String renewalStatus) {
            this.renewalStatus = renewalStatus;
        }

        public final Collection<LoadBalancerTlsCertificateDomainValidationOption.Builder> getDomainValidationOptions() {
            return domainValidationOptions != null ? domainValidationOptions.stream()
                    .map(LoadBalancerTlsCertificateDomainValidationOption::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder domainValidationOptions(
                Collection<LoadBalancerTlsCertificateDomainValidationOption> domainValidationOptions) {
            this.domainValidationOptions = LoadBalancerTlsCertificateDomainValidationOptionListCopier
                    .copy(domainValidationOptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder domainValidationOptions(LoadBalancerTlsCertificateDomainValidationOption... domainValidationOptions) {
            domainValidationOptions(Arrays.asList(domainValidationOptions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder domainValidationOptions(
                Consumer<LoadBalancerTlsCertificateDomainValidationOption.Builder>... domainValidationOptions) {
            domainValidationOptions(Stream.of(domainValidationOptions)
                    .map(c -> LoadBalancerTlsCertificateDomainValidationOption.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setDomainValidationOptions(
                Collection<LoadBalancerTlsCertificateDomainValidationOption.BuilderImpl> domainValidationOptions) {
            this.domainValidationOptions = LoadBalancerTlsCertificateDomainValidationOptionListCopier
                    .copyFromBuilder(domainValidationOptions);
        }

        @Override
        public LoadBalancerTlsCertificateRenewalSummary build() {
            return new LoadBalancerTlsCertificateRenewalSummary(this);
        }
    }
}
