/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.transform;

import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.lightsail.model.CreateLoadBalancerRequest;
import software.amazon.awssdk.utils.Validate;

/**
 * {@link CreateLoadBalancerRequest} Marshaller
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
public class CreateLoadBalancerRequestModelMarshaller {
    private static final MarshallingInfo<String> LOADBALANCERNAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("loadBalancerName").isBinary(false).build();

    private static final MarshallingInfo<Integer> INSTANCEPORT_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("instancePort").isBinary(false).build();

    private static final MarshallingInfo<String> HEALTHCHECKPATH_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("healthCheckPath").isBinary(false).build();

    private static final MarshallingInfo<String> CERTIFICATENAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("certificateName").isBinary(false).build();

    private static final MarshallingInfo<String> CERTIFICATEDOMAINNAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("certificateDomainName").isBinary(false).build();

    private static final MarshallingInfo<List> CERTIFICATEALTERNATIVENAMES_BINDING = MarshallingInfo
            .builder(MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("certificateAlternativeNames").isBinary(false).build();

    private static final CreateLoadBalancerRequestModelMarshaller INSTANCE = new CreateLoadBalancerRequestModelMarshaller();

    private CreateLoadBalancerRequestModelMarshaller() {
    }

    public static CreateLoadBalancerRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object
     */
    public void marshall(CreateLoadBalancerRequest createLoadBalancerRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull(createLoadBalancerRequest, "createLoadBalancerRequest");
        Validate.paramNotNull(protocolMarshaller, "protocolMarshaller");
        try {
            protocolMarshaller.marshall(createLoadBalancerRequest.loadBalancerName(), LOADBALANCERNAME_BINDING);
            protocolMarshaller.marshall(createLoadBalancerRequest.instancePort(), INSTANCEPORT_BINDING);
            protocolMarshaller.marshall(createLoadBalancerRequest.healthCheckPath(), HEALTHCHECKPATH_BINDING);
            protocolMarshaller.marshall(createLoadBalancerRequest.certificateName(), CERTIFICATENAME_BINDING);
            protocolMarshaller.marshall(createLoadBalancerRequest.certificateDomainName(), CERTIFICATEDOMAINNAME_BINDING);
            protocolMarshaller.marshall(createLoadBalancerRequest.certificateAlternativeNames(),
                    CERTIFICATEALTERNATIVENAMES_BINDING);
        } catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause(e).build();
        }
    }
}
