/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.transform;

import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.lightsail.model.InstancePortInfo;
import software.amazon.awssdk.utils.Validate;

/**
 * {@link InstancePortInfo} Marshaller
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
public class InstancePortInfoMarshaller {
    private static final MarshallingInfo<Integer> FROMPORT_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("fromPort").isBinary(false).build();

    private static final MarshallingInfo<Integer> TOPORT_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("toPort").isBinary(false).build();

    private static final MarshallingInfo<String> PROTOCOL_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("protocol").isBinary(false).build();

    private static final MarshallingInfo<String> ACCESSFROM_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("accessFrom").isBinary(false).build();

    private static final MarshallingInfo<String> ACCESSTYPE_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("accessType").isBinary(false).build();

    private static final MarshallingInfo<String> COMMONNAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("commonName").isBinary(false).build();

    private static final MarshallingInfo<String> ACCESSDIRECTION_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("accessDirection").isBinary(false).build();

    private static final InstancePortInfoMarshaller INSTANCE = new InstancePortInfoMarshaller();

    private InstancePortInfoMarshaller() {
    }

    public static InstancePortInfoMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object
     */
    public void marshall(InstancePortInfo instancePortInfo, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull(instancePortInfo, "instancePortInfo");
        Validate.paramNotNull(protocolMarshaller, "protocolMarshaller");
        try {
            protocolMarshaller.marshall(instancePortInfo.fromPort(), FROMPORT_BINDING);
            protocolMarshaller.marshall(instancePortInfo.toPort(), TOPORT_BINDING);
            protocolMarshaller.marshall(instancePortInfo.protocolAsString(), PROTOCOL_BINDING);
            protocolMarshaller.marshall(instancePortInfo.accessFrom(), ACCESSFROM_BINDING);
            protocolMarshaller.marshall(instancePortInfo.accessTypeAsString(), ACCESSTYPE_BINDING);
            protocolMarshaller.marshall(instancePortInfo.commonName(), COMMONNAME_BINDING);
            protocolMarshaller.marshall(instancePortInfo.accessDirectionAsString(), ACCESSDIRECTION_BINDING);
        } catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause(e).build();
        }
    }
}
