/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.transform;

import java.math.*;

import javax.annotation.Generated;

import software.amazon.awssdk.services.lightsail.model.*;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeJsonUnmarshallers.*;
import software.amazon.awssdk.core.runtime.transform.*;

import com.fasterxml.jackson.core.JsonToken;
import static com.fasterxml.jackson.core.JsonToken.*;

/**
 * InstanceSnapshot JSON Unmarshaller
 */
@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class InstanceSnapshotUnmarshaller implements Unmarshaller<InstanceSnapshot, JsonUnmarshallerContext> {

    public InstanceSnapshot unmarshall(JsonUnmarshallerContext context) throws Exception {
        InstanceSnapshot.Builder instanceSnapshotBuilder = InstanceSnapshot.builder();

        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;

        JsonToken token = context.getCurrentToken();
        if (token == null)
            token = context.nextToken();
        if (token == VALUE_NULL) {
            return null;
        }

        while (true) {
            if (token == null)
                break;

            if (token == FIELD_NAME || token == START_OBJECT) {
                if (context.testExpression("name", targetDepth)) {
                    context.nextToken();
                    instanceSnapshotBuilder.name(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("arn", targetDepth)) {
                    context.nextToken();
                    instanceSnapshotBuilder.arn(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("supportCode", targetDepth)) {
                    context.nextToken();
                    instanceSnapshotBuilder.supportCode(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("createdAt", targetDepth)) {
                    context.nextToken();
                    instanceSnapshotBuilder.createdAt(context.getUnmarshaller(java.time.Instant.class).unmarshall(context));
                }
                if (context.testExpression("location", targetDepth)) {
                    context.nextToken();
                    instanceSnapshotBuilder.location(ResourceLocationUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("resourceType", targetDepth)) {
                    context.nextToken();
                    instanceSnapshotBuilder.resourceType(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("state", targetDepth)) {
                    context.nextToken();
                    instanceSnapshotBuilder.state(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("progress", targetDepth)) {
                    context.nextToken();
                    instanceSnapshotBuilder.progress(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("fromAttachedDisks", targetDepth)) {
                    context.nextToken();
                    instanceSnapshotBuilder.fromAttachedDisks(new ListUnmarshaller<Disk>(DiskUnmarshaller.getInstance())
                            .unmarshall(context));
                }
                if (context.testExpression("fromInstanceName", targetDepth)) {
                    context.nextToken();
                    instanceSnapshotBuilder.fromInstanceName(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("fromInstanceArn", targetDepth)) {
                    context.nextToken();
                    instanceSnapshotBuilder.fromInstanceArn(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("fromBlueprintId", targetDepth)) {
                    context.nextToken();
                    instanceSnapshotBuilder.fromBlueprintId(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("fromBundleId", targetDepth)) {
                    context.nextToken();
                    instanceSnapshotBuilder.fromBundleId(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("sizeInGb", targetDepth)) {
                    context.nextToken();
                    instanceSnapshotBuilder.sizeInGb(context.getUnmarshaller(Integer.class).unmarshall(context));
                }
            } else if (token == END_ARRAY || token == END_OBJECT) {
                if (context.getLastParsedParentElement() == null
                        || context.getLastParsedParentElement().equals(currentParentElement)) {
                    if (context.getCurrentDepth() <= originalDepth)
                        break;
                }
            }
            token = context.nextToken();
        }

        return instanceSnapshotBuilder.build();
    }

    private static final InstanceSnapshotUnmarshaller INSTANCE = new InstanceSnapshotUnmarshaller();

    public static InstanceSnapshotUnmarshaller getInstance() {
        return INSTANCE;
    }
}
