/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.transform;

import java.time.Instant;
import java.util.List;
import java.util.Map;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.lightsail.model.LoadBalancer;
import software.amazon.awssdk.utils.Validate;

/**
 * {@link LoadBalancer} Marshaller
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
public class LoadBalancerMarshaller {
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("name").isBinary(false).build();

    private static final MarshallingInfo<String> ARN_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("arn").isBinary(false).build();

    private static final MarshallingInfo<String> SUPPORTCODE_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("supportCode").isBinary(false).build();

    private static final MarshallingInfo<Instant> CREATEDAT_BINDING = MarshallingInfo.builder(MarshallingType.INSTANT)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("createdAt").isBinary(false).build();

    private static final MarshallingInfo<StructuredPojo> LOCATION_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("location").isBinary(false).build();

    private static final MarshallingInfo<String> RESOURCETYPE_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("resourceType").isBinary(false).build();

    private static final MarshallingInfo<String> DNSNAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("dnsName").isBinary(false).build();

    private static final MarshallingInfo<String> STATE_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("state").isBinary(false).build();

    private static final MarshallingInfo<String> PROTOCOL_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("protocol").isBinary(false).build();

    private static final MarshallingInfo<List> PUBLICPORTS_BINDING = MarshallingInfo.builder(MarshallingType.LIST)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("publicPorts").isBinary(false).build();

    private static final MarshallingInfo<String> HEALTHCHECKPATH_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("healthCheckPath").isBinary(false).build();

    private static final MarshallingInfo<Integer> INSTANCEPORT_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("instancePort").isBinary(false).build();

    private static final MarshallingInfo<List> INSTANCEHEALTHSUMMARY_BINDING = MarshallingInfo.builder(MarshallingType.LIST)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("instanceHealthSummary").isBinary(false).build();

    private static final MarshallingInfo<List> TLSCERTIFICATESUMMARIES_BINDING = MarshallingInfo.builder(MarshallingType.LIST)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("tlsCertificateSummaries").isBinary(false).build();

    private static final MarshallingInfo<Map> CONFIGURATIONOPTIONS_BINDING = MarshallingInfo.builder(MarshallingType.MAP)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("configurationOptions").isBinary(false).build();

    private static final LoadBalancerMarshaller INSTANCE = new LoadBalancerMarshaller();

    private LoadBalancerMarshaller() {
    }

    public static LoadBalancerMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object
     */
    public void marshall(LoadBalancer loadBalancer, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull(loadBalancer, "loadBalancer");
        Validate.paramNotNull(protocolMarshaller, "protocolMarshaller");
        try {
            protocolMarshaller.marshall(loadBalancer.name(), NAME_BINDING);
            protocolMarshaller.marshall(loadBalancer.arn(), ARN_BINDING);
            protocolMarshaller.marshall(loadBalancer.supportCode(), SUPPORTCODE_BINDING);
            protocolMarshaller.marshall(loadBalancer.createdAt(), CREATEDAT_BINDING);
            protocolMarshaller.marshall(loadBalancer.location(), LOCATION_BINDING);
            protocolMarshaller.marshall(loadBalancer.resourceTypeAsString(), RESOURCETYPE_BINDING);
            protocolMarshaller.marshall(loadBalancer.dnsName(), DNSNAME_BINDING);
            protocolMarshaller.marshall(loadBalancer.stateAsString(), STATE_BINDING);
            protocolMarshaller.marshall(loadBalancer.protocolAsString(), PROTOCOL_BINDING);
            protocolMarshaller.marshall(loadBalancer.publicPorts(), PUBLICPORTS_BINDING);
            protocolMarshaller.marshall(loadBalancer.healthCheckPath(), HEALTHCHECKPATH_BINDING);
            protocolMarshaller.marshall(loadBalancer.instancePort(), INSTANCEPORT_BINDING);
            protocolMarshaller.marshall(loadBalancer.instanceHealthSummary(), INSTANCEHEALTHSUMMARY_BINDING);
            protocolMarshaller.marshall(loadBalancer.tlsCertificateSummaries(), TLSCERTIFICATESUMMARIES_BINDING);
            protocolMarshaller.marshall(loadBalancer.configurationOptionsAsStrings(), CONFIGURATIONOPTIONS_BINDING);
        } catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause(e).build();
        }
    }
}
