/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.transform;

import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.lightsail.model.LoadBalancerTlsCertificateDomainValidationRecord;
import software.amazon.awssdk.utils.Validate;

/**
 * {@link LoadBalancerTlsCertificateDomainValidationRecord} Marshaller
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
public class LoadBalancerTlsCertificateDomainValidationRecordMarshaller {
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("name").isBinary(false).build();

    private static final MarshallingInfo<String> TYPE_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("type").isBinary(false).build();

    private static final MarshallingInfo<String> VALUE_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("value").isBinary(false).build();

    private static final MarshallingInfo<String> VALIDATIONSTATUS_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("validationStatus").isBinary(false).build();

    private static final MarshallingInfo<String> DOMAINNAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("domainName").isBinary(false).build();

    private static final LoadBalancerTlsCertificateDomainValidationRecordMarshaller INSTANCE = new LoadBalancerTlsCertificateDomainValidationRecordMarshaller();

    private LoadBalancerTlsCertificateDomainValidationRecordMarshaller() {
    }

    public static LoadBalancerTlsCertificateDomainValidationRecordMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object
     */
    public void marshall(LoadBalancerTlsCertificateDomainValidationRecord loadBalancerTlsCertificateDomainValidationRecord,
            ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull(loadBalancerTlsCertificateDomainValidationRecord,
                "loadBalancerTlsCertificateDomainValidationRecord");
        Validate.paramNotNull(protocolMarshaller, "protocolMarshaller");
        try {
            protocolMarshaller.marshall(loadBalancerTlsCertificateDomainValidationRecord.name(), NAME_BINDING);
            protocolMarshaller.marshall(loadBalancerTlsCertificateDomainValidationRecord.type(), TYPE_BINDING);
            protocolMarshaller.marshall(loadBalancerTlsCertificateDomainValidationRecord.value(), VALUE_BINDING);
            protocolMarshaller.marshall(loadBalancerTlsCertificateDomainValidationRecord.validationStatusAsString(),
                    VALIDATIONSTATUS_BINDING);
            protocolMarshaller.marshall(loadBalancerTlsCertificateDomainValidationRecord.domainName(), DOMAINNAME_BINDING);
        } catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause(e).build();
        }
    }
}
