/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.transform;

import java.time.Instant;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.lightsail.model.LoadBalancerTlsCertificate;
import software.amazon.awssdk.utils.Validate;

/**
 * {@link LoadBalancerTlsCertificate} Marshaller
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
public class LoadBalancerTlsCertificateMarshaller {
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("name").isBinary(false).build();

    private static final MarshallingInfo<String> ARN_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("arn").isBinary(false).build();

    private static final MarshallingInfo<String> SUPPORTCODE_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("supportCode").isBinary(false).build();

    private static final MarshallingInfo<Instant> CREATEDAT_BINDING = MarshallingInfo.builder(MarshallingType.INSTANT)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("createdAt").isBinary(false).build();

    private static final MarshallingInfo<StructuredPojo> LOCATION_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("location").isBinary(false).build();

    private static final MarshallingInfo<String> RESOURCETYPE_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("resourceType").isBinary(false).build();

    private static final MarshallingInfo<String> LOADBALANCERNAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("loadBalancerName").isBinary(false).build();

    private static final MarshallingInfo<Boolean> ISATTACHED_BINDING = MarshallingInfo.builder(MarshallingType.BOOLEAN)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("isAttached").isBinary(false).build();

    private static final MarshallingInfo<String> STATUS_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("status").isBinary(false).build();

    private static final MarshallingInfo<String> DOMAINNAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("domainName").isBinary(false).build();

    private static final MarshallingInfo<List> DOMAINVALIDATIONRECORDS_BINDING = MarshallingInfo.builder(MarshallingType.LIST)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("domainValidationRecords").isBinary(false).build();

    private static final MarshallingInfo<String> FAILUREREASON_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("failureReason").isBinary(false).build();

    private static final MarshallingInfo<Instant> ISSUEDAT_BINDING = MarshallingInfo.builder(MarshallingType.INSTANT)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("issuedAt").isBinary(false).build();

    private static final MarshallingInfo<String> ISSUER_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("issuer").isBinary(false).build();

    private static final MarshallingInfo<String> KEYALGORITHM_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("keyAlgorithm").isBinary(false).build();

    private static final MarshallingInfo<Instant> NOTAFTER_BINDING = MarshallingInfo.builder(MarshallingType.INSTANT)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("notAfter").isBinary(false).build();

    private static final MarshallingInfo<Instant> NOTBEFORE_BINDING = MarshallingInfo.builder(MarshallingType.INSTANT)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("notBefore").isBinary(false).build();

    private static final MarshallingInfo<StructuredPojo> RENEWALSUMMARY_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("renewalSummary").isBinary(false).build();

    private static final MarshallingInfo<String> REVOCATIONREASON_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("revocationReason").isBinary(false).build();

    private static final MarshallingInfo<Instant> REVOKEDAT_BINDING = MarshallingInfo.builder(MarshallingType.INSTANT)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("revokedAt").isBinary(false).build();

    private static final MarshallingInfo<String> SERIAL_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("serial").isBinary(false).build();

    private static final MarshallingInfo<String> SIGNATUREALGORITHM_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("signatureAlgorithm").isBinary(false).build();

    private static final MarshallingInfo<String> SUBJECT_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("subject").isBinary(false).build();

    private static final MarshallingInfo<List> SUBJECTALTERNATIVENAMES_BINDING = MarshallingInfo.builder(MarshallingType.LIST)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("subjectAlternativeNames").isBinary(false).build();

    private static final LoadBalancerTlsCertificateMarshaller INSTANCE = new LoadBalancerTlsCertificateMarshaller();

    private LoadBalancerTlsCertificateMarshaller() {
    }

    public static LoadBalancerTlsCertificateMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object
     */
    public void marshall(LoadBalancerTlsCertificate loadBalancerTlsCertificate, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull(loadBalancerTlsCertificate, "loadBalancerTlsCertificate");
        Validate.paramNotNull(protocolMarshaller, "protocolMarshaller");
        try {
            protocolMarshaller.marshall(loadBalancerTlsCertificate.name(), NAME_BINDING);
            protocolMarshaller.marshall(loadBalancerTlsCertificate.arn(), ARN_BINDING);
            protocolMarshaller.marshall(loadBalancerTlsCertificate.supportCode(), SUPPORTCODE_BINDING);
            protocolMarshaller.marshall(loadBalancerTlsCertificate.createdAt(), CREATEDAT_BINDING);
            protocolMarshaller.marshall(loadBalancerTlsCertificate.location(), LOCATION_BINDING);
            protocolMarshaller.marshall(loadBalancerTlsCertificate.resourceTypeAsString(), RESOURCETYPE_BINDING);
            protocolMarshaller.marshall(loadBalancerTlsCertificate.loadBalancerName(), LOADBALANCERNAME_BINDING);
            protocolMarshaller.marshall(loadBalancerTlsCertificate.isAttached(), ISATTACHED_BINDING);
            protocolMarshaller.marshall(loadBalancerTlsCertificate.statusAsString(), STATUS_BINDING);
            protocolMarshaller.marshall(loadBalancerTlsCertificate.domainName(), DOMAINNAME_BINDING);
            protocolMarshaller.marshall(loadBalancerTlsCertificate.domainValidationRecords(), DOMAINVALIDATIONRECORDS_BINDING);
            protocolMarshaller.marshall(loadBalancerTlsCertificate.failureReasonAsString(), FAILUREREASON_BINDING);
            protocolMarshaller.marshall(loadBalancerTlsCertificate.issuedAt(), ISSUEDAT_BINDING);
            protocolMarshaller.marshall(loadBalancerTlsCertificate.issuer(), ISSUER_BINDING);
            protocolMarshaller.marshall(loadBalancerTlsCertificate.keyAlgorithm(), KEYALGORITHM_BINDING);
            protocolMarshaller.marshall(loadBalancerTlsCertificate.notAfter(), NOTAFTER_BINDING);
            protocolMarshaller.marshall(loadBalancerTlsCertificate.notBefore(), NOTBEFORE_BINDING);
            protocolMarshaller.marshall(loadBalancerTlsCertificate.renewalSummary(), RENEWALSUMMARY_BINDING);
            protocolMarshaller.marshall(loadBalancerTlsCertificate.revocationReasonAsString(), REVOCATIONREASON_BINDING);
            protocolMarshaller.marshall(loadBalancerTlsCertificate.revokedAt(), REVOKEDAT_BINDING);
            protocolMarshaller.marshall(loadBalancerTlsCertificate.serial(), SERIAL_BINDING);
            protocolMarshaller.marshall(loadBalancerTlsCertificate.signatureAlgorithm(), SIGNATUREALGORITHM_BINDING);
            protocolMarshaller.marshall(loadBalancerTlsCertificate.subject(), SUBJECT_BINDING);
            protocolMarshaller.marshall(loadBalancerTlsCertificate.subjectAlternativeNames(), SUBJECTALTERNATIVENAMES_BINDING);
        } catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause(e).build();
        }
    }
}
