/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.transform;

import java.math.*;

import javax.annotation.Generated;

import software.amazon.awssdk.services.lightsail.model.*;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeJsonUnmarshallers.*;
import software.amazon.awssdk.core.runtime.transform.*;

import com.fasterxml.jackson.core.JsonToken;
import static com.fasterxml.jackson.core.JsonToken.*;

/**
 * LoadBalancerTlsCertificate JSON Unmarshaller
 */
@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class LoadBalancerTlsCertificateUnmarshaller implements Unmarshaller<LoadBalancerTlsCertificate, JsonUnmarshallerContext> {

    public LoadBalancerTlsCertificate unmarshall(JsonUnmarshallerContext context) throws Exception {
        LoadBalancerTlsCertificate.Builder loadBalancerTlsCertificateBuilder = LoadBalancerTlsCertificate.builder();

        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;

        JsonToken token = context.getCurrentToken();
        if (token == null)
            token = context.nextToken();
        if (token == VALUE_NULL) {
            return null;
        }

        while (true) {
            if (token == null)
                break;

            if (token == FIELD_NAME || token == START_OBJECT) {
                if (context.testExpression("name", targetDepth)) {
                    context.nextToken();
                    loadBalancerTlsCertificateBuilder.name(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("arn", targetDepth)) {
                    context.nextToken();
                    loadBalancerTlsCertificateBuilder.arn(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("supportCode", targetDepth)) {
                    context.nextToken();
                    loadBalancerTlsCertificateBuilder.supportCode(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("createdAt", targetDepth)) {
                    context.nextToken();
                    loadBalancerTlsCertificateBuilder.createdAt(context.getUnmarshaller(java.time.Instant.class).unmarshall(
                            context));
                }
                if (context.testExpression("location", targetDepth)) {
                    context.nextToken();
                    loadBalancerTlsCertificateBuilder.location(ResourceLocationUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("resourceType", targetDepth)) {
                    context.nextToken();
                    loadBalancerTlsCertificateBuilder.resourceType(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("loadBalancerName", targetDepth)) {
                    context.nextToken();
                    loadBalancerTlsCertificateBuilder.loadBalancerName(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("isAttached", targetDepth)) {
                    context.nextToken();
                    loadBalancerTlsCertificateBuilder.isAttached(context.getUnmarshaller(Boolean.class).unmarshall(context));
                }
                if (context.testExpression("status", targetDepth)) {
                    context.nextToken();
                    loadBalancerTlsCertificateBuilder.status(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("domainName", targetDepth)) {
                    context.nextToken();
                    loadBalancerTlsCertificateBuilder.domainName(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("domainValidationRecords", targetDepth)) {
                    context.nextToken();
                    loadBalancerTlsCertificateBuilder
                            .domainValidationRecords(new ListUnmarshaller<LoadBalancerTlsCertificateDomainValidationRecord>(
                                    LoadBalancerTlsCertificateDomainValidationRecordUnmarshaller.getInstance())
                                    .unmarshall(context));
                }
                if (context.testExpression("failureReason", targetDepth)) {
                    context.nextToken();
                    loadBalancerTlsCertificateBuilder.failureReason(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("issuedAt", targetDepth)) {
                    context.nextToken();
                    loadBalancerTlsCertificateBuilder.issuedAt(context.getUnmarshaller(java.time.Instant.class).unmarshall(
                            context));
                }
                if (context.testExpression("issuer", targetDepth)) {
                    context.nextToken();
                    loadBalancerTlsCertificateBuilder.issuer(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("keyAlgorithm", targetDepth)) {
                    context.nextToken();
                    loadBalancerTlsCertificateBuilder.keyAlgorithm(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("notAfter", targetDepth)) {
                    context.nextToken();
                    loadBalancerTlsCertificateBuilder.notAfter(context.getUnmarshaller(java.time.Instant.class).unmarshall(
                            context));
                }
                if (context.testExpression("notBefore", targetDepth)) {
                    context.nextToken();
                    loadBalancerTlsCertificateBuilder.notBefore(context.getUnmarshaller(java.time.Instant.class).unmarshall(
                            context));
                }
                if (context.testExpression("renewalSummary", targetDepth)) {
                    context.nextToken();
                    loadBalancerTlsCertificateBuilder.renewalSummary(LoadBalancerTlsCertificateRenewalSummaryUnmarshaller
                            .getInstance().unmarshall(context));
                }
                if (context.testExpression("revocationReason", targetDepth)) {
                    context.nextToken();
                    loadBalancerTlsCertificateBuilder.revocationReason(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("revokedAt", targetDepth)) {
                    context.nextToken();
                    loadBalancerTlsCertificateBuilder.revokedAt(context.getUnmarshaller(java.time.Instant.class).unmarshall(
                            context));
                }
                if (context.testExpression("serial", targetDepth)) {
                    context.nextToken();
                    loadBalancerTlsCertificateBuilder.serial(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("signatureAlgorithm", targetDepth)) {
                    context.nextToken();
                    loadBalancerTlsCertificateBuilder.signatureAlgorithm(context.getUnmarshaller(String.class)
                            .unmarshall(context));
                }
                if (context.testExpression("subject", targetDepth)) {
                    context.nextToken();
                    loadBalancerTlsCertificateBuilder.subject(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("subjectAlternativeNames", targetDepth)) {
                    context.nextToken();
                    loadBalancerTlsCertificateBuilder.subjectAlternativeNames(new ListUnmarshaller<String>(context
                            .getUnmarshaller(String.class)).unmarshall(context));
                }
            } else if (token == END_ARRAY || token == END_OBJECT) {
                if (context.getLastParsedParentElement() == null
                        || context.getLastParsedParentElement().equals(currentParentElement)) {
                    if (context.getCurrentDepth() <= originalDepth)
                        break;
                }
            }
            token = context.nextToken();
        }

        return loadBalancerTlsCertificateBuilder.build();
    }

    private static final LoadBalancerTlsCertificateUnmarshaller INSTANCE = new LoadBalancerTlsCertificateUnmarshaller();

    public static LoadBalancerTlsCertificateUnmarshaller getInstance() {
        return INSTANCE;
    }
}
