/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.transform;

import java.math.*;

import javax.annotation.Generated;

import software.amazon.awssdk.services.lightsail.model.*;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeJsonUnmarshallers.*;
import software.amazon.awssdk.core.runtime.transform.*;

import com.fasterxml.jackson.core.JsonToken;
import static com.fasterxml.jackson.core.JsonToken.*;

/**
 * LoadBalancer JSON Unmarshaller
 */
@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class LoadBalancerUnmarshaller implements Unmarshaller<LoadBalancer, JsonUnmarshallerContext> {

    public LoadBalancer unmarshall(JsonUnmarshallerContext context) throws Exception {
        LoadBalancer.Builder loadBalancerBuilder = LoadBalancer.builder();

        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;

        JsonToken token = context.getCurrentToken();
        if (token == null)
            token = context.nextToken();
        if (token == VALUE_NULL) {
            return null;
        }

        while (true) {
            if (token == null)
                break;

            if (token == FIELD_NAME || token == START_OBJECT) {
                if (context.testExpression("name", targetDepth)) {
                    context.nextToken();
                    loadBalancerBuilder.name(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("arn", targetDepth)) {
                    context.nextToken();
                    loadBalancerBuilder.arn(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("supportCode", targetDepth)) {
                    context.nextToken();
                    loadBalancerBuilder.supportCode(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("createdAt", targetDepth)) {
                    context.nextToken();
                    loadBalancerBuilder.createdAt(context.getUnmarshaller(java.time.Instant.class).unmarshall(context));
                }
                if (context.testExpression("location", targetDepth)) {
                    context.nextToken();
                    loadBalancerBuilder.location(ResourceLocationUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("resourceType", targetDepth)) {
                    context.nextToken();
                    loadBalancerBuilder.resourceType(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("dnsName", targetDepth)) {
                    context.nextToken();
                    loadBalancerBuilder.dnsName(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("state", targetDepth)) {
                    context.nextToken();
                    loadBalancerBuilder.state(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("protocol", targetDepth)) {
                    context.nextToken();
                    loadBalancerBuilder.protocol(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("publicPorts", targetDepth)) {
                    context.nextToken();
                    loadBalancerBuilder.publicPorts(new ListUnmarshaller<Integer>(context.getUnmarshaller(Integer.class))
                            .unmarshall(context));
                }
                if (context.testExpression("healthCheckPath", targetDepth)) {
                    context.nextToken();
                    loadBalancerBuilder.healthCheckPath(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("instancePort", targetDepth)) {
                    context.nextToken();
                    loadBalancerBuilder.instancePort(context.getUnmarshaller(Integer.class).unmarshall(context));
                }
                if (context.testExpression("instanceHealthSummary", targetDepth)) {
                    context.nextToken();
                    loadBalancerBuilder.instanceHealthSummary(new ListUnmarshaller<InstanceHealthSummary>(
                            InstanceHealthSummaryUnmarshaller.getInstance()).unmarshall(context));
                }
                if (context.testExpression("tlsCertificateSummaries", targetDepth)) {
                    context.nextToken();
                    loadBalancerBuilder.tlsCertificateSummaries(new ListUnmarshaller<LoadBalancerTlsCertificateSummary>(
                            LoadBalancerTlsCertificateSummaryUnmarshaller.getInstance()).unmarshall(context));
                }
                if (context.testExpression("configurationOptions", targetDepth)) {
                    context.nextToken();
                    loadBalancerBuilder.configurationOptionsWithStrings(new MapUnmarshaller<String, String>(context
                            .getUnmarshaller(String.class), context.getUnmarshaller(String.class)).unmarshall(context));
                }
            } else if (token == END_ARRAY || token == END_OBJECT) {
                if (context.getLastParsedParentElement() == null
                        || context.getLastParsedParentElement().equals(currentParentElement)) {
                    if (context.getCurrentDepth() <= originalDepth)
                        break;
                }
            }
            token = context.nextToken();
        }

        return loadBalancerBuilder.build();
    }

    private static final LoadBalancerUnmarshaller INSTANCE = new LoadBalancerUnmarshaller();

    public static LoadBalancerUnmarshaller getInstance() {
        return INSTANCE;
    }
}
