/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.transform;

import java.time.Instant;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.lightsail.model.MetricDatapoint;
import software.amazon.awssdk.utils.Validate;

/**
 * {@link MetricDatapoint} Marshaller
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
public class MetricDatapointMarshaller {
    private static final MarshallingInfo<Double> AVERAGE_BINDING = MarshallingInfo.builder(MarshallingType.DOUBLE)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("average").isBinary(false).build();

    private static final MarshallingInfo<Double> MAXIMUM_BINDING = MarshallingInfo.builder(MarshallingType.DOUBLE)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("maximum").isBinary(false).build();

    private static final MarshallingInfo<Double> MINIMUM_BINDING = MarshallingInfo.builder(MarshallingType.DOUBLE)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("minimum").isBinary(false).build();

    private static final MarshallingInfo<Double> SAMPLECOUNT_BINDING = MarshallingInfo.builder(MarshallingType.DOUBLE)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("sampleCount").isBinary(false).build();

    private static final MarshallingInfo<Double> SUM_BINDING = MarshallingInfo.builder(MarshallingType.DOUBLE)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("sum").isBinary(false).build();

    private static final MarshallingInfo<Instant> TIMESTAMP_BINDING = MarshallingInfo.builder(MarshallingType.INSTANT)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("timestamp").isBinary(false).build();

    private static final MarshallingInfo<String> UNIT_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("unit").isBinary(false).build();

    private static final MetricDatapointMarshaller INSTANCE = new MetricDatapointMarshaller();

    private MetricDatapointMarshaller() {
    }

    public static MetricDatapointMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object
     */
    public void marshall(MetricDatapoint metricDatapoint, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull(metricDatapoint, "metricDatapoint");
        Validate.paramNotNull(protocolMarshaller, "protocolMarshaller");
        try {
            protocolMarshaller.marshall(metricDatapoint.average(), AVERAGE_BINDING);
            protocolMarshaller.marshall(metricDatapoint.maximum(), MAXIMUM_BINDING);
            protocolMarshaller.marshall(metricDatapoint.minimum(), MINIMUM_BINDING);
            protocolMarshaller.marshall(metricDatapoint.sampleCount(), SAMPLECOUNT_BINDING);
            protocolMarshaller.marshall(metricDatapoint.sum(), SUM_BINDING);
            protocolMarshaller.marshall(metricDatapoint.timestamp(), TIMESTAMP_BINDING);
            protocolMarshaller.marshall(metricDatapoint.unitAsString(), UNIT_BINDING);
        } catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause(e).build();
        }
    }
}
