/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.lightsail.model.DomainNameListCopier;
import software.amazon.awssdk.services.lightsail.model.LightsailRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateLoadBalancerTlsCertificateRequest
extends LightsailRequest
implements ToCopyableBuilder<Builder, CreateLoadBalancerTlsCertificateRequest> {
    private final String loadBalancerName;
    private final String certificateName;
    private final String certificateDomainName;
    private final List<String> certificateAlternativeNames;

    private CreateLoadBalancerTlsCertificateRequest(BuilderImpl builder) {
        super(builder);
        this.loadBalancerName = builder.loadBalancerName;
        this.certificateName = builder.certificateName;
        this.certificateDomainName = builder.certificateDomainName;
        this.certificateAlternativeNames = builder.certificateAlternativeNames;
    }

    public String loadBalancerName() {
        return this.loadBalancerName;
    }

    public String certificateName() {
        return this.certificateName;
    }

    public String certificateDomainName() {
        return this.certificateDomainName;
    }

    public List<String> certificateAlternativeNames() {
        return this.certificateAlternativeNames;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.loadBalancerName());
        hashCode = 31 * hashCode + Objects.hashCode(this.certificateName());
        hashCode = 31 * hashCode + Objects.hashCode(this.certificateDomainName());
        hashCode = 31 * hashCode + Objects.hashCode(this.certificateAlternativeNames());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateLoadBalancerTlsCertificateRequest)) {
            return false;
        }
        CreateLoadBalancerTlsCertificateRequest other = (CreateLoadBalancerTlsCertificateRequest)((Object)obj);
        return Objects.equals(this.loadBalancerName(), other.loadBalancerName()) && Objects.equals(this.certificateName(), other.certificateName()) && Objects.equals(this.certificateDomainName(), other.certificateDomainName()) && Objects.equals(this.certificateAlternativeNames(), other.certificateAlternativeNames());
    }

    public String toString() {
        return ToString.builder((String)"CreateLoadBalancerTlsCertificateRequest").add("LoadBalancerName", (Object)this.loadBalancerName()).add("CertificateName", (Object)this.certificateName()).add("CertificateDomainName", (Object)this.certificateDomainName()).add("CertificateAlternativeNames", this.certificateAlternativeNames()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "loadBalancerName": {
                return Optional.ofNullable(clazz.cast(this.loadBalancerName()));
            }
            case "certificateName": {
                return Optional.ofNullable(clazz.cast(this.certificateName()));
            }
            case "certificateDomainName": {
                return Optional.ofNullable(clazz.cast(this.certificateDomainName()));
            }
            case "certificateAlternativeNames": {
                return Optional.ofNullable(clazz.cast(this.certificateAlternativeNames()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends LightsailRequest.BuilderImpl
    implements Builder {
        private String loadBalancerName;
        private String certificateName;
        private String certificateDomainName;
        private List<String> certificateAlternativeNames = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateLoadBalancerTlsCertificateRequest model) {
            super(model);
            this.loadBalancerName(model.loadBalancerName);
            this.certificateName(model.certificateName);
            this.certificateDomainName(model.certificateDomainName);
            this.certificateAlternativeNames(model.certificateAlternativeNames);
        }

        public final String getLoadBalancerName() {
            return this.loadBalancerName;
        }

        @Override
        public final Builder loadBalancerName(String loadBalancerName) {
            this.loadBalancerName = loadBalancerName;
            return this;
        }

        public final void setLoadBalancerName(String loadBalancerName) {
            this.loadBalancerName = loadBalancerName;
        }

        public final String getCertificateName() {
            return this.certificateName;
        }

        @Override
        public final Builder certificateName(String certificateName) {
            this.certificateName = certificateName;
            return this;
        }

        public final void setCertificateName(String certificateName) {
            this.certificateName = certificateName;
        }

        public final String getCertificateDomainName() {
            return this.certificateDomainName;
        }

        @Override
        public final Builder certificateDomainName(String certificateDomainName) {
            this.certificateDomainName = certificateDomainName;
            return this;
        }

        public final void setCertificateDomainName(String certificateDomainName) {
            this.certificateDomainName = certificateDomainName;
        }

        public final Collection<String> getCertificateAlternativeNames() {
            return this.certificateAlternativeNames;
        }

        @Override
        public final Builder certificateAlternativeNames(Collection<String> certificateAlternativeNames) {
            this.certificateAlternativeNames = DomainNameListCopier.copy(certificateAlternativeNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder certificateAlternativeNames(String ... certificateAlternativeNames) {
            this.certificateAlternativeNames(Arrays.asList(certificateAlternativeNames));
            return this;
        }

        public final void setCertificateAlternativeNames(Collection<String> certificateAlternativeNames) {
            this.certificateAlternativeNames = DomainNameListCopier.copy(certificateAlternativeNames);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateLoadBalancerTlsCertificateRequest build() {
            return new CreateLoadBalancerTlsCertificateRequest(this);
        }
    }

    public static interface Builder
    extends LightsailRequest.Builder,
    CopyableBuilder<Builder, CreateLoadBalancerTlsCertificateRequest> {
        public Builder loadBalancerName(String var1);

        public Builder certificateName(String var1);

        public Builder certificateDomainName(String var1);

        public Builder certificateAlternativeNames(Collection<String> var1);

        public Builder certificateAlternativeNames(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

