/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.lightsail.model.LightsailResponse;
import software.amazon.awssdk.services.lightsail.model.LoadBalancerTlsCertificate;
import software.amazon.awssdk.services.lightsail.model.LoadBalancerTlsCertificateListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetLoadBalancerTlsCertificatesResponse
extends LightsailResponse
implements ToCopyableBuilder<Builder, GetLoadBalancerTlsCertificatesResponse> {
    private final List<LoadBalancerTlsCertificate> tlsCertificates;

    private GetLoadBalancerTlsCertificatesResponse(BuilderImpl builder) {
        super(builder);
        this.tlsCertificates = builder.tlsCertificates;
    }

    public List<LoadBalancerTlsCertificate> tlsCertificates() {
        return this.tlsCertificates;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.tlsCertificates());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetLoadBalancerTlsCertificatesResponse)) {
            return false;
        }
        GetLoadBalancerTlsCertificatesResponse other = (GetLoadBalancerTlsCertificatesResponse)((Object)obj);
        return Objects.equals(this.tlsCertificates(), other.tlsCertificates());
    }

    public String toString() {
        return ToString.builder((String)"GetLoadBalancerTlsCertificatesResponse").add("TlsCertificates", this.tlsCertificates()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "tlsCertificates": {
                return Optional.ofNullable(clazz.cast(this.tlsCertificates()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends LightsailResponse.BuilderImpl
    implements Builder {
        private List<LoadBalancerTlsCertificate> tlsCertificates = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetLoadBalancerTlsCertificatesResponse model) {
            super(model);
            this.tlsCertificates(model.tlsCertificates);
        }

        public final Collection<LoadBalancerTlsCertificate.Builder> getTlsCertificates() {
            return this.tlsCertificates != null ? (Collection)this.tlsCertificates.stream().map(LoadBalancerTlsCertificate::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tlsCertificates(Collection<LoadBalancerTlsCertificate> tlsCertificates) {
            this.tlsCertificates = LoadBalancerTlsCertificateListCopier.copy(tlsCertificates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tlsCertificates(LoadBalancerTlsCertificate ... tlsCertificates) {
            this.tlsCertificates(Arrays.asList(tlsCertificates));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tlsCertificates(Consumer<LoadBalancerTlsCertificate.Builder> ... tlsCertificates) {
            this.tlsCertificates(Stream.of(tlsCertificates).map(c -> (LoadBalancerTlsCertificate)((LoadBalancerTlsCertificate.Builder)LoadBalancerTlsCertificate.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTlsCertificates(Collection<LoadBalancerTlsCertificate.BuilderImpl> tlsCertificates) {
            this.tlsCertificates = LoadBalancerTlsCertificateListCopier.copyFromBuilder(tlsCertificates);
        }

        @Override
        public GetLoadBalancerTlsCertificatesResponse build() {
            return new GetLoadBalancerTlsCertificatesResponse(this);
        }
    }

    public static interface Builder
    extends LightsailResponse.Builder,
    CopyableBuilder<Builder, GetLoadBalancerTlsCertificatesResponse> {
        public Builder tlsCertificates(Collection<LoadBalancerTlsCertificate> var1);

        public Builder tlsCertificates(LoadBalancerTlsCertificate ... var1);

        public Builder tlsCertificates(Consumer<LoadBalancerTlsCertificate.Builder> ... var1);
    }
}

