/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.lightsail.model.LoadBalancerTlsCertificateDomainStatus;
import software.amazon.awssdk.services.lightsail.transform.LoadBalancerTlsCertificateDomainValidationOptionMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LoadBalancerTlsCertificateDomainValidationOption
implements StructuredPojo,
ToCopyableBuilder<Builder, LoadBalancerTlsCertificateDomainValidationOption> {
    private final String domainName;
    private final String validationStatus;

    private LoadBalancerTlsCertificateDomainValidationOption(BuilderImpl builder) {
        this.domainName = builder.domainName;
        this.validationStatus = builder.validationStatus;
    }

    public String domainName() {
        return this.domainName;
    }

    public LoadBalancerTlsCertificateDomainStatus validationStatus() {
        return LoadBalancerTlsCertificateDomainStatus.fromValue(this.validationStatus);
    }

    public String validationStatusAsString() {
        return this.validationStatus;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.domainName());
        hashCode = 31 * hashCode + Objects.hashCode(this.validationStatusAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LoadBalancerTlsCertificateDomainValidationOption)) {
            return false;
        }
        LoadBalancerTlsCertificateDomainValidationOption other = (LoadBalancerTlsCertificateDomainValidationOption)obj;
        return Objects.equals(this.domainName(), other.domainName()) && Objects.equals(this.validationStatusAsString(), other.validationStatusAsString());
    }

    public String toString() {
        return ToString.builder((String)"LoadBalancerTlsCertificateDomainValidationOption").add("DomainName", (Object)this.domainName()).add("ValidationStatus", (Object)this.validationStatusAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "domainName": {
                return Optional.ofNullable(clazz.cast(this.domainName()));
            }
            case "validationStatus": {
                return Optional.ofNullable(clazz.cast(this.validationStatusAsString()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        LoadBalancerTlsCertificateDomainValidationOptionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String domainName;
        private String validationStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(LoadBalancerTlsCertificateDomainValidationOption model) {
            this.domainName(model.domainName);
            this.validationStatus(model.validationStatus);
        }

        public final String getDomainName() {
            return this.domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        public final String getValidationStatus() {
            return this.validationStatus;
        }

        @Override
        public final Builder validationStatus(String validationStatus) {
            this.validationStatus = validationStatus;
            return this;
        }

        @Override
        public final Builder validationStatus(LoadBalancerTlsCertificateDomainStatus validationStatus) {
            this.validationStatus(validationStatus.toString());
            return this;
        }

        public final void setValidationStatus(String validationStatus) {
            this.validationStatus = validationStatus;
        }

        public LoadBalancerTlsCertificateDomainValidationOption build() {
            return new LoadBalancerTlsCertificateDomainValidationOption(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, LoadBalancerTlsCertificateDomainValidationOption> {
        public Builder domainName(String var1);

        public Builder validationStatus(String var1);

        public Builder validationStatus(LoadBalancerTlsCertificateDomainStatus var1);
    }
}

