/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.lightsail.model.LoadBalancerTlsCertificateDomainStatus;
import software.amazon.awssdk.services.lightsail.transform.LoadBalancerTlsCertificateDomainValidationRecordMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LoadBalancerTlsCertificateDomainValidationRecord
implements StructuredPojo,
ToCopyableBuilder<Builder, LoadBalancerTlsCertificateDomainValidationRecord> {
    private final String name;
    private final String type;
    private final String value;
    private final String validationStatus;
    private final String domainName;

    private LoadBalancerTlsCertificateDomainValidationRecord(BuilderImpl builder) {
        this.name = builder.name;
        this.type = builder.type;
        this.value = builder.value;
        this.validationStatus = builder.validationStatus;
        this.domainName = builder.domainName;
    }

    public String name() {
        return this.name;
    }

    public String type() {
        return this.type;
    }

    public String value() {
        return this.value;
    }

    public LoadBalancerTlsCertificateDomainStatus validationStatus() {
        return LoadBalancerTlsCertificateDomainStatus.fromValue(this.validationStatus);
    }

    public String validationStatusAsString() {
        return this.validationStatus;
    }

    public String domainName() {
        return this.domainName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.type());
        hashCode = 31 * hashCode + Objects.hashCode(this.value());
        hashCode = 31 * hashCode + Objects.hashCode(this.validationStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainName());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LoadBalancerTlsCertificateDomainValidationRecord)) {
            return false;
        }
        LoadBalancerTlsCertificateDomainValidationRecord other = (LoadBalancerTlsCertificateDomainValidationRecord)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.type(), other.type()) && Objects.equals(this.value(), other.value()) && Objects.equals(this.validationStatusAsString(), other.validationStatusAsString()) && Objects.equals(this.domainName(), other.domainName());
    }

    public String toString() {
        return ToString.builder((String)"LoadBalancerTlsCertificateDomainValidationRecord").add("Name", (Object)this.name()).add("Type", (Object)this.type()).add("Value", (Object)this.value()).add("ValidationStatus", (Object)this.validationStatusAsString()).add("DomainName", (Object)this.domainName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "type": {
                return Optional.ofNullable(clazz.cast(this.type()));
            }
            case "value": {
                return Optional.ofNullable(clazz.cast(this.value()));
            }
            case "validationStatus": {
                return Optional.ofNullable(clazz.cast(this.validationStatusAsString()));
            }
            case "domainName": {
                return Optional.ofNullable(clazz.cast(this.domainName()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        LoadBalancerTlsCertificateDomainValidationRecordMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String type;
        private String value;
        private String validationStatus;
        private String domainName;

        private BuilderImpl() {
        }

        private BuilderImpl(LoadBalancerTlsCertificateDomainValidationRecord model) {
            this.name(model.name);
            this.type(model.type);
            this.value(model.value);
            this.validationStatus(model.validationStatus);
            this.domainName(model.domainName);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final String getValue() {
            return this.value;
        }

        @Override
        public final Builder value(String value) {
            this.value = value;
            return this;
        }

        public final void setValue(String value) {
            this.value = value;
        }

        public final String getValidationStatus() {
            return this.validationStatus;
        }

        @Override
        public final Builder validationStatus(String validationStatus) {
            this.validationStatus = validationStatus;
            return this;
        }

        @Override
        public final Builder validationStatus(LoadBalancerTlsCertificateDomainStatus validationStatus) {
            this.validationStatus(validationStatus.toString());
            return this;
        }

        public final void setValidationStatus(String validationStatus) {
            this.validationStatus = validationStatus;
        }

        public final String getDomainName() {
            return this.domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        public LoadBalancerTlsCertificateDomainValidationRecord build() {
            return new LoadBalancerTlsCertificateDomainValidationRecord(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, LoadBalancerTlsCertificateDomainValidationRecord> {
        public Builder name(String var1);

        public Builder type(String var1);

        public Builder value(String var1);

        public Builder validationStatus(String var1);

        public Builder validationStatus(LoadBalancerTlsCertificateDomainStatus var1);

        public Builder domainName(String var1);
    }
}

