/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.services.lightsail.model.LightsailRequest;
import software.amazon.awssdk.services.lightsail.model.LoadBalancerAttributeName;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateLoadBalancerAttributeRequest
extends LightsailRequest
implements ToCopyableBuilder<Builder, UpdateLoadBalancerAttributeRequest> {
    private final String loadBalancerName;
    private final String attributeName;
    private final String attributeValue;

    private UpdateLoadBalancerAttributeRequest(BuilderImpl builder) {
        super(builder);
        this.loadBalancerName = builder.loadBalancerName;
        this.attributeName = builder.attributeName;
        this.attributeValue = builder.attributeValue;
    }

    public String loadBalancerName() {
        return this.loadBalancerName;
    }

    public LoadBalancerAttributeName attributeName() {
        return LoadBalancerAttributeName.fromValue(this.attributeName);
    }

    public String attributeNameAsString() {
        return this.attributeName;
    }

    public String attributeValue() {
        return this.attributeValue;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.loadBalancerName());
        hashCode = 31 * hashCode + Objects.hashCode(this.attributeNameAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.attributeValue());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateLoadBalancerAttributeRequest)) {
            return false;
        }
        UpdateLoadBalancerAttributeRequest other = (UpdateLoadBalancerAttributeRequest)((Object)obj);
        return Objects.equals(this.loadBalancerName(), other.loadBalancerName()) && Objects.equals(this.attributeNameAsString(), other.attributeNameAsString()) && Objects.equals(this.attributeValue(), other.attributeValue());
    }

    public String toString() {
        return ToString.builder((String)"UpdateLoadBalancerAttributeRequest").add("LoadBalancerName", (Object)this.loadBalancerName()).add("AttributeName", (Object)this.attributeNameAsString()).add("AttributeValue", (Object)this.attributeValue()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "loadBalancerName": {
                return Optional.ofNullable(clazz.cast(this.loadBalancerName()));
            }
            case "attributeName": {
                return Optional.ofNullable(clazz.cast(this.attributeNameAsString()));
            }
            case "attributeValue": {
                return Optional.ofNullable(clazz.cast(this.attributeValue()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends LightsailRequest.BuilderImpl
    implements Builder {
        private String loadBalancerName;
        private String attributeName;
        private String attributeValue;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateLoadBalancerAttributeRequest model) {
            super(model);
            this.loadBalancerName(model.loadBalancerName);
            this.attributeName(model.attributeName);
            this.attributeValue(model.attributeValue);
        }

        public final String getLoadBalancerName() {
            return this.loadBalancerName;
        }

        @Override
        public final Builder loadBalancerName(String loadBalancerName) {
            this.loadBalancerName = loadBalancerName;
            return this;
        }

        public final void setLoadBalancerName(String loadBalancerName) {
            this.loadBalancerName = loadBalancerName;
        }

        public final String getAttributeName() {
            return this.attributeName;
        }

        @Override
        public final Builder attributeName(String attributeName) {
            this.attributeName = attributeName;
            return this;
        }

        @Override
        public final Builder attributeName(LoadBalancerAttributeName attributeName) {
            this.attributeName(attributeName.toString());
            return this;
        }

        public final void setAttributeName(String attributeName) {
            this.attributeName = attributeName;
        }

        public final String getAttributeValue() {
            return this.attributeValue;
        }

        @Override
        public final Builder attributeValue(String attributeValue) {
            this.attributeValue = attributeValue;
            return this;
        }

        public final void setAttributeValue(String attributeValue) {
            this.attributeValue = attributeValue;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateLoadBalancerAttributeRequest build() {
            return new UpdateLoadBalancerAttributeRequest(this);
        }
    }

    public static interface Builder
    extends LightsailRequest.Builder,
    CopyableBuilder<Builder, UpdateLoadBalancerAttributeRequest> {
        public Builder loadBalancerName(String var1);

        public Builder attributeName(String var1);

        public Builder attributeName(LoadBalancerAttributeName var1);

        public Builder attributeValue(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

