/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.protocol.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.protocol.OperationInfo;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.ProtocolRequestMarshaller;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.services.lightsail.model.CreateLoadBalancerRequest;
import software.amazon.awssdk.services.lightsail.transform.CreateLoadBalancerRequestModelMarshaller;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class CreateLoadBalancerRequestMarshaller
implements Marshaller<Request<CreateLoadBalancerRequest>, CreateLoadBalancerRequest> {
    private static final OperationInfo SDK_OPERATION_BINDING = OperationInfo.builder().requestUri("/").httpMethodName(HttpMethodName.POST).hasExplicitPayloadMember(false).hasPayloadMembers(true).operationIdentifier("Lightsail_20161128.CreateLoadBalancer").serviceName("Amazon Lightsail").build();
    private final AwsJsonProtocolFactory protocolFactory;

    public CreateLoadBalancerRequestMarshaller(AwsJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<CreateLoadBalancerRequest> marshall(CreateLoadBalancerRequest createLoadBalancerRequest) {
        Validate.paramNotNull((Object)((Object)createLoadBalancerRequest), (String)"createLoadBalancerRequest");
        try {
            ProtocolRequestMarshaller protocolMarshaller = this.protocolFactory.createProtocolMarshaller(SDK_OPERATION_BINDING, (SdkRequest)createLoadBalancerRequest);
            protocolMarshaller.startMarshalling();
            CreateLoadBalancerRequestModelMarshaller.getInstance().marshall(createLoadBalancerRequest, (ProtocolMarshaller)protocolMarshaller);
            return protocolMarshaller.finishMarshalling();
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

