/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.lightsail.model.CreateLoadBalancerRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class CreateLoadBalancerRequestModelMarshaller {
    private static final MarshallingInfo<String> LOADBALANCERNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("loadBalancerName").isBinary(false).build();
    private static final MarshallingInfo<Integer> INSTANCEPORT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("instancePort").isBinary(false).build();
    private static final MarshallingInfo<String> HEALTHCHECKPATH_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("healthCheckPath").isBinary(false).build();
    private static final MarshallingInfo<String> CERTIFICATENAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("certificateName").isBinary(false).build();
    private static final MarshallingInfo<String> CERTIFICATEDOMAINNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("certificateDomainName").isBinary(false).build();
    private static final MarshallingInfo<List> CERTIFICATEALTERNATIVENAMES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("certificateAlternativeNames").isBinary(false).build();
    private static final CreateLoadBalancerRequestModelMarshaller INSTANCE = new CreateLoadBalancerRequestModelMarshaller();

    private CreateLoadBalancerRequestModelMarshaller() {
    }

    public static CreateLoadBalancerRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(CreateLoadBalancerRequest createLoadBalancerRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)createLoadBalancerRequest), (String)"createLoadBalancerRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)createLoadBalancerRequest.loadBalancerName(), LOADBALANCERNAME_BINDING);
            protocolMarshaller.marshall((Object)createLoadBalancerRequest.instancePort(), INSTANCEPORT_BINDING);
            protocolMarshaller.marshall((Object)createLoadBalancerRequest.healthCheckPath(), HEALTHCHECKPATH_BINDING);
            protocolMarshaller.marshall((Object)createLoadBalancerRequest.certificateName(), CERTIFICATENAME_BINDING);
            protocolMarshaller.marshall((Object)createLoadBalancerRequest.certificateDomainName(), CERTIFICATEDOMAINNAME_BINDING);
            protocolMarshaller.marshall(createLoadBalancerRequest.certificateAlternativeNames(), CERTIFICATEALTERNATIVENAMES_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

