/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.lightsail.model.CreateLoadBalancerTlsCertificateRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class CreateLoadBalancerTlsCertificateRequestModelMarshaller {
    private static final MarshallingInfo<String> LOADBALANCERNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("loadBalancerName").isBinary(false).build();
    private static final MarshallingInfo<String> CERTIFICATENAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("certificateName").isBinary(false).build();
    private static final MarshallingInfo<String> CERTIFICATEDOMAINNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("certificateDomainName").isBinary(false).build();
    private static final MarshallingInfo<List> CERTIFICATEALTERNATIVENAMES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("certificateAlternativeNames").isBinary(false).build();
    private static final CreateLoadBalancerTlsCertificateRequestModelMarshaller INSTANCE = new CreateLoadBalancerTlsCertificateRequestModelMarshaller();

    private CreateLoadBalancerTlsCertificateRequestModelMarshaller() {
    }

    public static CreateLoadBalancerTlsCertificateRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(CreateLoadBalancerTlsCertificateRequest createLoadBalancerTlsCertificateRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)createLoadBalancerTlsCertificateRequest), (String)"createLoadBalancerTlsCertificateRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)createLoadBalancerTlsCertificateRequest.loadBalancerName(), LOADBALANCERNAME_BINDING);
            protocolMarshaller.marshall((Object)createLoadBalancerTlsCertificateRequest.certificateName(), CERTIFICATENAME_BINDING);
            protocolMarshaller.marshall((Object)createLoadBalancerTlsCertificateRequest.certificateDomainName(), CERTIFICATEDOMAINNAME_BINDING);
            protocolMarshaller.marshall(createLoadBalancerTlsCertificateRequest.certificateAlternativeNames(), CERTIFICATEALTERNATIVENAMES_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

