/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.lightsail.model.InstanceState;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class InstanceStateMarshaller {
    private static final MarshallingInfo<Integer> CODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("code").isBinary(false).build();
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("name").isBinary(false).build();
    private static final InstanceStateMarshaller INSTANCE = new InstanceStateMarshaller();

    private InstanceStateMarshaller() {
    }

    public static InstanceStateMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(InstanceState instanceState, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)instanceState, (String)"instanceState");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)instanceState.code(), CODE_BINDING);
            protocolMarshaller.marshall((Object)instanceState.name(), NAME_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

