/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateLoadBalancerTlsCertificateRequest extends LightsailRequest implements
        ToCopyableBuilder<CreateLoadBalancerTlsCertificateRequest.Builder, CreateLoadBalancerTlsCertificateRequest> {
    private static final SdkField<String> LOAD_BALANCER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateLoadBalancerTlsCertificateRequest::loadBalancerName)).setter(setter(Builder::loadBalancerName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("loadBalancerName").build()).build();

    private static final SdkField<String> CERTIFICATE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateLoadBalancerTlsCertificateRequest::certificateName)).setter(setter(Builder::certificateName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("certificateName").build()).build();

    private static final SdkField<String> CERTIFICATE_DOMAIN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateLoadBalancerTlsCertificateRequest::certificateDomainName))
            .setter(setter(Builder::certificateDomainName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("certificateDomainName").build())
            .build();

    private static final SdkField<List<String>> CERTIFICATE_ALTERNATIVE_NAMES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(CreateLoadBalancerTlsCertificateRequest::certificateAlternativeNames))
            .setter(setter(Builder::certificateAlternativeNames))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("certificateAlternativeNames")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOAD_BALANCER_NAME_FIELD,
            CERTIFICATE_NAME_FIELD, CERTIFICATE_DOMAIN_NAME_FIELD, CERTIFICATE_ALTERNATIVE_NAMES_FIELD));

    private final String loadBalancerName;

    private final String certificateName;

    private final String certificateDomainName;

    private final List<String> certificateAlternativeNames;

    private CreateLoadBalancerTlsCertificateRequest(BuilderImpl builder) {
        super(builder);
        this.loadBalancerName = builder.loadBalancerName;
        this.certificateName = builder.certificateName;
        this.certificateDomainName = builder.certificateDomainName;
        this.certificateAlternativeNames = builder.certificateAlternativeNames;
    }

    /**
     * <p>
     * The load balancer name where you want to create the SSL/TLS certificate.
     * </p>
     * 
     * @return The load balancer name where you want to create the SSL/TLS certificate.
     */
    public String loadBalancerName() {
        return loadBalancerName;
    }

    /**
     * <p>
     * The SSL/TLS certificate name.
     * </p>
     * <p>
     * You can have up to 10 certificates in your account at one time. Each Lightsail load balancer can have up to 2
     * certificates associated with it at one time. There is also an overall limit to the number of certificates that
     * can be issue in a 365-day period. For more information, see <a
     * href="http://docs.aws.amazon.com/acm/latest/userguide/acm-limits.html">Limits</a>.
     * </p>
     * 
     * @return The SSL/TLS certificate name.</p>
     *         <p>
     *         You can have up to 10 certificates in your account at one time. Each Lightsail load balancer can have up
     *         to 2 certificates associated with it at one time. There is also an overall limit to the number of
     *         certificates that can be issue in a 365-day period. For more information, see <a
     *         href="http://docs.aws.amazon.com/acm/latest/userguide/acm-limits.html">Limits</a>.
     */
    public String certificateName() {
        return certificateName;
    }

    /**
     * <p>
     * The domain name (e.g., <code>example.com</code>) for your SSL/TLS certificate.
     * </p>
     * 
     * @return The domain name (e.g., <code>example.com</code>) for your SSL/TLS certificate.
     */
    public String certificateDomainName() {
        return certificateDomainName;
    }

    /**
     * <p>
     * An array of strings listing alternative domains and subdomains for your SSL/TLS certificate. Lightsail will
     * de-dupe the names for you. You can have a maximum of 9 alternative names (in addition to the 1 primary domain).
     * We do not support wildcards (e.g., <code>*.example.com</code>).
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return An array of strings listing alternative domains and subdomains for your SSL/TLS certificate. Lightsail
     *         will de-dupe the names for you. You can have a maximum of 9 alternative names (in addition to the 1
     *         primary domain). We do not support wildcards (e.g., <code>*.example.com</code>).
     */
    public List<String> certificateAlternativeNames() {
        return certificateAlternativeNames;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(loadBalancerName());
        hashCode = 31 * hashCode + Objects.hashCode(certificateName());
        hashCode = 31 * hashCode + Objects.hashCode(certificateDomainName());
        hashCode = 31 * hashCode + Objects.hashCode(certificateAlternativeNames());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateLoadBalancerTlsCertificateRequest)) {
            return false;
        }
        CreateLoadBalancerTlsCertificateRequest other = (CreateLoadBalancerTlsCertificateRequest) obj;
        return Objects.equals(loadBalancerName(), other.loadBalancerName())
                && Objects.equals(certificateName(), other.certificateName())
                && Objects.equals(certificateDomainName(), other.certificateDomainName())
                && Objects.equals(certificateAlternativeNames(), other.certificateAlternativeNames());
    }

    @Override
    public String toString() {
        return ToString.builder("CreateLoadBalancerTlsCertificateRequest").add("LoadBalancerName", loadBalancerName())
                .add("CertificateName", certificateName()).add("CertificateDomainName", certificateDomainName())
                .add("CertificateAlternativeNames", certificateAlternativeNames()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "loadBalancerName":
            return Optional.ofNullable(clazz.cast(loadBalancerName()));
        case "certificateName":
            return Optional.ofNullable(clazz.cast(certificateName()));
        case "certificateDomainName":
            return Optional.ofNullable(clazz.cast(certificateDomainName()));
        case "certificateAlternativeNames":
            return Optional.ofNullable(clazz.cast(certificateAlternativeNames()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateLoadBalancerTlsCertificateRequest, T> g) {
        return obj -> g.apply((CreateLoadBalancerTlsCertificateRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LightsailRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateLoadBalancerTlsCertificateRequest> {
        /**
         * <p>
         * The load balancer name where you want to create the SSL/TLS certificate.
         * </p>
         * 
         * @param loadBalancerName
         *        The load balancer name where you want to create the SSL/TLS certificate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder loadBalancerName(String loadBalancerName);

        /**
         * <p>
         * The SSL/TLS certificate name.
         * </p>
         * <p>
         * You can have up to 10 certificates in your account at one time. Each Lightsail load balancer can have up to 2
         * certificates associated with it at one time. There is also an overall limit to the number of certificates
         * that can be issue in a 365-day period. For more information, see <a
         * href="http://docs.aws.amazon.com/acm/latest/userguide/acm-limits.html">Limits</a>.
         * </p>
         * 
         * @param certificateName
         *        The SSL/TLS certificate name.</p>
         *        <p>
         *        You can have up to 10 certificates in your account at one time. Each Lightsail load balancer can have
         *        up to 2 certificates associated with it at one time. There is also an overall limit to the number of
         *        certificates that can be issue in a 365-day period. For more information, see <a
         *        href="http://docs.aws.amazon.com/acm/latest/userguide/acm-limits.html">Limits</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificateName(String certificateName);

        /**
         * <p>
         * The domain name (e.g., <code>example.com</code>) for your SSL/TLS certificate.
         * </p>
         * 
         * @param certificateDomainName
         *        The domain name (e.g., <code>example.com</code>) for your SSL/TLS certificate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificateDomainName(String certificateDomainName);

        /**
         * <p>
         * An array of strings listing alternative domains and subdomains for your SSL/TLS certificate. Lightsail will
         * de-dupe the names for you. You can have a maximum of 9 alternative names (in addition to the 1 primary
         * domain). We do not support wildcards (e.g., <code>*.example.com</code>).
         * </p>
         * 
         * @param certificateAlternativeNames
         *        An array of strings listing alternative domains and subdomains for your SSL/TLS certificate. Lightsail
         *        will de-dupe the names for you. You can have a maximum of 9 alternative names (in addition to the 1
         *        primary domain). We do not support wildcards (e.g., <code>*.example.com</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificateAlternativeNames(Collection<String> certificateAlternativeNames);

        /**
         * <p>
         * An array of strings listing alternative domains and subdomains for your SSL/TLS certificate. Lightsail will
         * de-dupe the names for you. You can have a maximum of 9 alternative names (in addition to the 1 primary
         * domain). We do not support wildcards (e.g., <code>*.example.com</code>).
         * </p>
         * 
         * @param certificateAlternativeNames
         *        An array of strings listing alternative domains and subdomains for your SSL/TLS certificate. Lightsail
         *        will de-dupe the names for you. You can have a maximum of 9 alternative names (in addition to the 1
         *        primary domain). We do not support wildcards (e.g., <code>*.example.com</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificateAlternativeNames(String... certificateAlternativeNames);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LightsailRequest.BuilderImpl implements Builder {
        private String loadBalancerName;

        private String certificateName;

        private String certificateDomainName;

        private List<String> certificateAlternativeNames = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateLoadBalancerTlsCertificateRequest model) {
            super(model);
            loadBalancerName(model.loadBalancerName);
            certificateName(model.certificateName);
            certificateDomainName(model.certificateDomainName);
            certificateAlternativeNames(model.certificateAlternativeNames);
        }

        public final String getLoadBalancerName() {
            return loadBalancerName;
        }

        @Override
        public final Builder loadBalancerName(String loadBalancerName) {
            this.loadBalancerName = loadBalancerName;
            return this;
        }

        public final void setLoadBalancerName(String loadBalancerName) {
            this.loadBalancerName = loadBalancerName;
        }

        public final String getCertificateName() {
            return certificateName;
        }

        @Override
        public final Builder certificateName(String certificateName) {
            this.certificateName = certificateName;
            return this;
        }

        public final void setCertificateName(String certificateName) {
            this.certificateName = certificateName;
        }

        public final String getCertificateDomainName() {
            return certificateDomainName;
        }

        @Override
        public final Builder certificateDomainName(String certificateDomainName) {
            this.certificateDomainName = certificateDomainName;
            return this;
        }

        public final void setCertificateDomainName(String certificateDomainName) {
            this.certificateDomainName = certificateDomainName;
        }

        public final Collection<String> getCertificateAlternativeNames() {
            return certificateAlternativeNames;
        }

        @Override
        public final Builder certificateAlternativeNames(Collection<String> certificateAlternativeNames) {
            this.certificateAlternativeNames = DomainNameListCopier.copy(certificateAlternativeNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder certificateAlternativeNames(String... certificateAlternativeNames) {
            certificateAlternativeNames(Arrays.asList(certificateAlternativeNames));
            return this;
        }

        public final void setCertificateAlternativeNames(Collection<String> certificateAlternativeNames) {
            this.certificateAlternativeNames = DomainNameListCopier.copy(certificateAlternativeNames);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateLoadBalancerTlsCertificateRequest build() {
            return new CreateLoadBalancerTlsCertificateRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
