/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.lightsail.model.InstanceHardware;
import software.amazon.awssdk.services.lightsail.model.InstanceNetworking;
import software.amazon.awssdk.services.lightsail.model.InstanceState;
import software.amazon.awssdk.services.lightsail.model.ResourceLocation;
import software.amazon.awssdk.services.lightsail.model.ResourceType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Instance
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Instance> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Instance.getter(Instance::name)).setter(Instance.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Instance.getter(Instance::arn)).setter(Instance.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<String> SUPPORT_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Instance.getter(Instance::supportCode)).setter(Instance.setter(Builder::supportCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("supportCode").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(Instance.getter(Instance::createdAt)).setter(Instance.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()}).build();
    private static final SdkField<ResourceLocation> LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(Instance.getter(Instance::location)).setter(Instance.setter(Builder::location)).constructor(ResourceLocation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("location").build()}).build();
    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Instance.getter(Instance::resourceTypeAsString)).setter(Instance.setter(Builder::resourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceType").build()}).build();
    private static final SdkField<String> BLUEPRINT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Instance.getter(Instance::blueprintId)).setter(Instance.setter(Builder::blueprintId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("blueprintId").build()}).build();
    private static final SdkField<String> BLUEPRINT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Instance.getter(Instance::blueprintName)).setter(Instance.setter(Builder::blueprintName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("blueprintName").build()}).build();
    private static final SdkField<String> BUNDLE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Instance.getter(Instance::bundleId)).setter(Instance.setter(Builder::bundleId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bundleId").build()}).build();
    private static final SdkField<Boolean> IS_STATIC_IP_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(Instance.getter(Instance::isStaticIp)).setter(Instance.setter(Builder::isStaticIp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isStaticIp").build()}).build();
    private static final SdkField<String> PRIVATE_IP_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Instance.getter(Instance::privateIpAddress)).setter(Instance.setter(Builder::privateIpAddress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("privateIpAddress").build()}).build();
    private static final SdkField<String> PUBLIC_IP_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Instance.getter(Instance::publicIpAddress)).setter(Instance.setter(Builder::publicIpAddress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("publicIpAddress").build()}).build();
    private static final SdkField<String> IPV6_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Instance.getter(Instance::ipv6Address)).setter(Instance.setter(Builder::ipv6Address)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ipv6Address").build()}).build();
    private static final SdkField<InstanceHardware> HARDWARE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(Instance.getter(Instance::hardware)).setter(Instance.setter(Builder::hardware)).constructor(InstanceHardware::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hardware").build()}).build();
    private static final SdkField<InstanceNetworking> NETWORKING_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(Instance.getter(Instance::networking)).setter(Instance.setter(Builder::networking)).constructor(InstanceNetworking::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("networking").build()}).build();
    private static final SdkField<InstanceState> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(Instance.getter(Instance::state)).setter(Instance.setter(Builder::state)).constructor(InstanceState::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("state").build()}).build();
    private static final SdkField<String> USERNAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Instance.getter(Instance::username)).setter(Instance.setter(Builder::username)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("username").build()}).build();
    private static final SdkField<String> SSH_KEY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Instance.getter(Instance::sshKeyName)).setter(Instance.setter(Builder::sshKeyName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sshKeyName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, ARN_FIELD, SUPPORT_CODE_FIELD, CREATED_AT_FIELD, LOCATION_FIELD, RESOURCE_TYPE_FIELD, BLUEPRINT_ID_FIELD, BLUEPRINT_NAME_FIELD, BUNDLE_ID_FIELD, IS_STATIC_IP_FIELD, PRIVATE_IP_ADDRESS_FIELD, PUBLIC_IP_ADDRESS_FIELD, IPV6_ADDRESS_FIELD, HARDWARE_FIELD, NETWORKING_FIELD, STATE_FIELD, USERNAME_FIELD, SSH_KEY_NAME_FIELD));
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String arn;
    private final String supportCode;
    private final Instant createdAt;
    private final ResourceLocation location;
    private final String resourceType;
    private final String blueprintId;
    private final String blueprintName;
    private final String bundleId;
    private final Boolean isStaticIp;
    private final String privateIpAddress;
    private final String publicIpAddress;
    private final String ipv6Address;
    private final InstanceHardware hardware;
    private final InstanceNetworking networking;
    private final InstanceState state;
    private final String username;
    private final String sshKeyName;

    private Instance(BuilderImpl builder) {
        this.name = builder.name;
        this.arn = builder.arn;
        this.supportCode = builder.supportCode;
        this.createdAt = builder.createdAt;
        this.location = builder.location;
        this.resourceType = builder.resourceType;
        this.blueprintId = builder.blueprintId;
        this.blueprintName = builder.blueprintName;
        this.bundleId = builder.bundleId;
        this.isStaticIp = builder.isStaticIp;
        this.privateIpAddress = builder.privateIpAddress;
        this.publicIpAddress = builder.publicIpAddress;
        this.ipv6Address = builder.ipv6Address;
        this.hardware = builder.hardware;
        this.networking = builder.networking;
        this.state = builder.state;
        this.username = builder.username;
        this.sshKeyName = builder.sshKeyName;
    }

    public String name() {
        return this.name;
    }

    public String arn() {
        return this.arn;
    }

    public String supportCode() {
        return this.supportCode;
    }

    public Instant createdAt() {
        return this.createdAt;
    }

    public ResourceLocation location() {
        return this.location;
    }

    public ResourceType resourceType() {
        return ResourceType.fromValue(this.resourceType);
    }

    public String resourceTypeAsString() {
        return this.resourceType;
    }

    public String blueprintId() {
        return this.blueprintId;
    }

    public String blueprintName() {
        return this.blueprintName;
    }

    public String bundleId() {
        return this.bundleId;
    }

    public Boolean isStaticIp() {
        return this.isStaticIp;
    }

    public String privateIpAddress() {
        return this.privateIpAddress;
    }

    public String publicIpAddress() {
        return this.publicIpAddress;
    }

    public String ipv6Address() {
        return this.ipv6Address;
    }

    public InstanceHardware hardware() {
        return this.hardware;
    }

    public InstanceNetworking networking() {
        return this.networking;
    }

    public InstanceState state() {
        return this.state;
    }

    public String username() {
        return this.username;
    }

    public String sshKeyName() {
        return this.sshKeyName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.supportCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.location());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.blueprintId());
        hashCode = 31 * hashCode + Objects.hashCode(this.blueprintName());
        hashCode = 31 * hashCode + Objects.hashCode(this.bundleId());
        hashCode = 31 * hashCode + Objects.hashCode(this.isStaticIp());
        hashCode = 31 * hashCode + Objects.hashCode(this.privateIpAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.publicIpAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.ipv6Address());
        hashCode = 31 * hashCode + Objects.hashCode(this.hardware());
        hashCode = 31 * hashCode + Objects.hashCode(this.networking());
        hashCode = 31 * hashCode + Objects.hashCode(this.state());
        hashCode = 31 * hashCode + Objects.hashCode(this.username());
        hashCode = 31 * hashCode + Objects.hashCode(this.sshKeyName());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Instance)) {
            return false;
        }
        Instance other = (Instance)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.supportCode(), other.supportCode()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.location(), other.location()) && Objects.equals(this.resourceTypeAsString(), other.resourceTypeAsString()) && Objects.equals(this.blueprintId(), other.blueprintId()) && Objects.equals(this.blueprintName(), other.blueprintName()) && Objects.equals(this.bundleId(), other.bundleId()) && Objects.equals(this.isStaticIp(), other.isStaticIp()) && Objects.equals(this.privateIpAddress(), other.privateIpAddress()) && Objects.equals(this.publicIpAddress(), other.publicIpAddress()) && Objects.equals(this.ipv6Address(), other.ipv6Address()) && Objects.equals(this.hardware(), other.hardware()) && Objects.equals(this.networking(), other.networking()) && Objects.equals(this.state(), other.state()) && Objects.equals(this.username(), other.username()) && Objects.equals(this.sshKeyName(), other.sshKeyName());
    }

    public String toString() {
        return ToString.builder((String)"Instance").add("Name", (Object)this.name()).add("Arn", (Object)this.arn()).add("SupportCode", (Object)this.supportCode()).add("CreatedAt", (Object)this.createdAt()).add("Location", (Object)this.location()).add("ResourceType", (Object)this.resourceTypeAsString()).add("BlueprintId", (Object)this.blueprintId()).add("BlueprintName", (Object)this.blueprintName()).add("BundleId", (Object)this.bundleId()).add("IsStaticIp", (Object)this.isStaticIp()).add("PrivateIpAddress", (Object)this.privateIpAddress()).add("PublicIpAddress", (Object)this.publicIpAddress()).add("Ipv6Address", (Object)this.ipv6Address()).add("Hardware", (Object)this.hardware()).add("Networking", (Object)this.networking()).add("State", (Object)this.state()).add("Username", (Object)this.username()).add("SshKeyName", (Object)this.sshKeyName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "supportCode": {
                return Optional.ofNullable(clazz.cast(this.supportCode()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "location": {
                return Optional.ofNullable(clazz.cast(this.location()));
            }
            case "resourceType": {
                return Optional.ofNullable(clazz.cast(this.resourceTypeAsString()));
            }
            case "blueprintId": {
                return Optional.ofNullable(clazz.cast(this.blueprintId()));
            }
            case "blueprintName": {
                return Optional.ofNullable(clazz.cast(this.blueprintName()));
            }
            case "bundleId": {
                return Optional.ofNullable(clazz.cast(this.bundleId()));
            }
            case "isStaticIp": {
                return Optional.ofNullable(clazz.cast(this.isStaticIp()));
            }
            case "privateIpAddress": {
                return Optional.ofNullable(clazz.cast(this.privateIpAddress()));
            }
            case "publicIpAddress": {
                return Optional.ofNullable(clazz.cast(this.publicIpAddress()));
            }
            case "ipv6Address": {
                return Optional.ofNullable(clazz.cast(this.ipv6Address()));
            }
            case "hardware": {
                return Optional.ofNullable(clazz.cast(this.hardware()));
            }
            case "networking": {
                return Optional.ofNullable(clazz.cast(this.networking()));
            }
            case "state": {
                return Optional.ofNullable(clazz.cast(this.state()));
            }
            case "username": {
                return Optional.ofNullable(clazz.cast(this.username()));
            }
            case "sshKeyName": {
                return Optional.ofNullable(clazz.cast(this.sshKeyName()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Instance, T> g) {
        return obj -> g.apply((Instance)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String arn;
        private String supportCode;
        private Instant createdAt;
        private ResourceLocation location;
        private String resourceType;
        private String blueprintId;
        private String blueprintName;
        private String bundleId;
        private Boolean isStaticIp;
        private String privateIpAddress;
        private String publicIpAddress;
        private String ipv6Address;
        private InstanceHardware hardware;
        private InstanceNetworking networking;
        private InstanceState state;
        private String username;
        private String sshKeyName;

        private BuilderImpl() {
        }

        private BuilderImpl(Instance model) {
            this.name(model.name);
            this.arn(model.arn);
            this.supportCode(model.supportCode);
            this.createdAt(model.createdAt);
            this.location(model.location);
            this.resourceType(model.resourceType);
            this.blueprintId(model.blueprintId);
            this.blueprintName(model.blueprintName);
            this.bundleId(model.bundleId);
            this.isStaticIp(model.isStaticIp);
            this.privateIpAddress(model.privateIpAddress);
            this.publicIpAddress(model.publicIpAddress);
            this.ipv6Address(model.ipv6Address);
            this.hardware(model.hardware);
            this.networking(model.networking);
            this.state(model.state);
            this.username(model.username);
            this.sshKeyName(model.sshKeyName);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getArn() {
            return this.arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getSupportCode() {
            return this.supportCode;
        }

        @Override
        public final Builder supportCode(String supportCode) {
            this.supportCode = supportCode;
            return this;
        }

        public final void setSupportCode(String supportCode) {
            this.supportCode = supportCode;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        public final ResourceLocation.Builder getLocation() {
            return this.location != null ? this.location.toBuilder() : null;
        }

        @Override
        public final Builder location(ResourceLocation location) {
            this.location = location;
            return this;
        }

        public final void setLocation(ResourceLocation.BuilderImpl location) {
            this.location = location != null ? location.build() : null;
        }

        public final String getResourceType() {
            return this.resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public final Builder resourceType(ResourceType resourceType) {
            this.resourceType(resourceType.toString());
            return this;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        public final String getBlueprintId() {
            return this.blueprintId;
        }

        @Override
        public final Builder blueprintId(String blueprintId) {
            this.blueprintId = blueprintId;
            return this;
        }

        public final void setBlueprintId(String blueprintId) {
            this.blueprintId = blueprintId;
        }

        public final String getBlueprintName() {
            return this.blueprintName;
        }

        @Override
        public final Builder blueprintName(String blueprintName) {
            this.blueprintName = blueprintName;
            return this;
        }

        public final void setBlueprintName(String blueprintName) {
            this.blueprintName = blueprintName;
        }

        public final String getBundleId() {
            return this.bundleId;
        }

        @Override
        public final Builder bundleId(String bundleId) {
            this.bundleId = bundleId;
            return this;
        }

        public final void setBundleId(String bundleId) {
            this.bundleId = bundleId;
        }

        public final Boolean getIsStaticIp() {
            return this.isStaticIp;
        }

        @Override
        public final Builder isStaticIp(Boolean isStaticIp) {
            this.isStaticIp = isStaticIp;
            return this;
        }

        public final void setIsStaticIp(Boolean isStaticIp) {
            this.isStaticIp = isStaticIp;
        }

        public final String getPrivateIpAddress() {
            return this.privateIpAddress;
        }

        @Override
        public final Builder privateIpAddress(String privateIpAddress) {
            this.privateIpAddress = privateIpAddress;
            return this;
        }

        public final void setPrivateIpAddress(String privateIpAddress) {
            this.privateIpAddress = privateIpAddress;
        }

        public final String getPublicIpAddress() {
            return this.publicIpAddress;
        }

        @Override
        public final Builder publicIpAddress(String publicIpAddress) {
            this.publicIpAddress = publicIpAddress;
            return this;
        }

        public final void setPublicIpAddress(String publicIpAddress) {
            this.publicIpAddress = publicIpAddress;
        }

        public final String getIpv6Address() {
            return this.ipv6Address;
        }

        @Override
        public final Builder ipv6Address(String ipv6Address) {
            this.ipv6Address = ipv6Address;
            return this;
        }

        public final void setIpv6Address(String ipv6Address) {
            this.ipv6Address = ipv6Address;
        }

        public final InstanceHardware.Builder getHardware() {
            return this.hardware != null ? this.hardware.toBuilder() : null;
        }

        @Override
        public final Builder hardware(InstanceHardware hardware) {
            this.hardware = hardware;
            return this;
        }

        public final void setHardware(InstanceHardware.BuilderImpl hardware) {
            this.hardware = hardware != null ? hardware.build() : null;
        }

        public final InstanceNetworking.Builder getNetworking() {
            return this.networking != null ? this.networking.toBuilder() : null;
        }

        @Override
        public final Builder networking(InstanceNetworking networking) {
            this.networking = networking;
            return this;
        }

        public final void setNetworking(InstanceNetworking.BuilderImpl networking) {
            this.networking = networking != null ? networking.build() : null;
        }

        public final InstanceState.Builder getState() {
            return this.state != null ? this.state.toBuilder() : null;
        }

        @Override
        public final Builder state(InstanceState state) {
            this.state = state;
            return this;
        }

        public final void setState(InstanceState.BuilderImpl state) {
            this.state = state != null ? state.build() : null;
        }

        public final String getUsername() {
            return this.username;
        }

        @Override
        public final Builder username(String username) {
            this.username = username;
            return this;
        }

        public final void setUsername(String username) {
            this.username = username;
        }

        public final String getSshKeyName() {
            return this.sshKeyName;
        }

        @Override
        public final Builder sshKeyName(String sshKeyName) {
            this.sshKeyName = sshKeyName;
            return this;
        }

        public final void setSshKeyName(String sshKeyName) {
            this.sshKeyName = sshKeyName;
        }

        public Instance build() {
            return new Instance(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Instance> {
        public Builder name(String var1);

        public Builder arn(String var1);

        public Builder supportCode(String var1);

        public Builder createdAt(Instant var1);

        public Builder location(ResourceLocation var1);

        default public Builder location(Consumer<ResourceLocation.Builder> location) {
            return this.location((ResourceLocation)((ResourceLocation.Builder)ResourceLocation.builder().applyMutation(location)).build());
        }

        public Builder resourceType(String var1);

        public Builder resourceType(ResourceType var1);

        public Builder blueprintId(String var1);

        public Builder blueprintName(String var1);

        public Builder bundleId(String var1);

        public Builder isStaticIp(Boolean var1);

        public Builder privateIpAddress(String var1);

        public Builder publicIpAddress(String var1);

        public Builder ipv6Address(String var1);

        public Builder hardware(InstanceHardware var1);

        default public Builder hardware(Consumer<InstanceHardware.Builder> hardware) {
            return this.hardware((InstanceHardware)((InstanceHardware.Builder)InstanceHardware.builder().applyMutation(hardware)).build());
        }

        public Builder networking(InstanceNetworking var1);

        default public Builder networking(Consumer<InstanceNetworking.Builder> networking) {
            return this.networking((InstanceNetworking)((InstanceNetworking.Builder)InstanceNetworking.builder().applyMutation(networking)).build());
        }

        public Builder state(InstanceState var1);

        default public Builder state(Consumer<InstanceState.Builder> state) {
            return this.state((InstanceState)((InstanceState.Builder)InstanceState.builder().applyMutation(state)).build());
        }

        public Builder username(String var1);

        public Builder sshKeyName(String var1);
    }
}

