/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum OperationType {
    DELETE_INSTANCE("DeleteInstance"),
    CREATE_INSTANCE("CreateInstance"),
    STOP_INSTANCE("StopInstance"),
    START_INSTANCE("StartInstance"),
    REBOOT_INSTANCE("RebootInstance"),
    OPEN_INSTANCE_PUBLIC_PORTS("OpenInstancePublicPorts"),
    PUT_INSTANCE_PUBLIC_PORTS("PutInstancePublicPorts"),
    CLOSE_INSTANCE_PUBLIC_PORTS("CloseInstancePublicPorts"),
    ALLOCATE_STATIC_IP("AllocateStaticIp"),
    RELEASE_STATIC_IP("ReleaseStaticIp"),
    ATTACH_STATIC_IP("AttachStaticIp"),
    DETACH_STATIC_IP("DetachStaticIp"),
    UPDATE_DOMAIN_ENTRY("UpdateDomainEntry"),
    DELETE_DOMAIN_ENTRY("DeleteDomainEntry"),
    CREATE_DOMAIN("CreateDomain"),
    DELETE_DOMAIN("DeleteDomain"),
    CREATE_INSTANCE_SNAPSHOT("CreateInstanceSnapshot"),
    DELETE_INSTANCE_SNAPSHOT("DeleteInstanceSnapshot"),
    CREATE_INSTANCES_FROM_SNAPSHOT("CreateInstancesFromSnapshot"),
    CREATE_LOAD_BALANCER("CreateLoadBalancer"),
    DELETE_LOAD_BALANCER("DeleteLoadBalancer"),
    ATTACH_INSTANCES_TO_LOAD_BALANCER("AttachInstancesToLoadBalancer"),
    DETACH_INSTANCES_FROM_LOAD_BALANCER("DetachInstancesFromLoadBalancer"),
    UPDATE_LOAD_BALANCER_ATTRIBUTE("UpdateLoadBalancerAttribute"),
    CREATE_LOAD_BALANCER_TLS_CERTIFICATE("CreateLoadBalancerTlsCertificate"),
    DELETE_LOAD_BALANCER_TLS_CERTIFICATE("DeleteLoadBalancerTlsCertificate"),
    ATTACH_LOAD_BALANCER_TLS_CERTIFICATE("AttachLoadBalancerTlsCertificate"),
    CREATE_DISK("CreateDisk"),
    DELETE_DISK("DeleteDisk"),
    ATTACH_DISK("AttachDisk"),
    DETACH_DISK("DetachDisk"),
    CREATE_DISK_SNAPSHOT("CreateDiskSnapshot"),
    DELETE_DISK_SNAPSHOT("DeleteDiskSnapshot"),
    CREATE_DISK_FROM_SNAPSHOT("CreateDiskFromSnapshot"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private OperationType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static OperationType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(OperationType.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<OperationType> knownValues() {
        return Stream.of(OperationType.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

