/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail;

import java.util.concurrent.CompletableFuture;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonServiceException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.client.AsyncClientHandler;
import software.amazon.awssdk.client.AwsAsyncClientParams;
import software.amazon.awssdk.client.ClientExecutionParams;
import software.amazon.awssdk.client.ClientHandlerParams;
import software.amazon.awssdk.client.SdkAsyncClientHandler;
import software.amazon.awssdk.http.HttpResponseHandler;
import software.amazon.awssdk.protocol.json.JsonClientMetadata;
import software.amazon.awssdk.protocol.json.JsonErrorResponseMetadata;
import software.amazon.awssdk.protocol.json.JsonErrorShapeMetadata;
import software.amazon.awssdk.protocol.json.JsonOperationMetadata;
import software.amazon.awssdk.protocol.json.SdkJsonProtocolFactory;
import software.amazon.awssdk.services.lightsail.model.AccessDeniedException;
import software.amazon.awssdk.services.lightsail.model.AccountSetupInProgressException;
import software.amazon.awssdk.services.lightsail.model.AllocateStaticIpRequest;
import software.amazon.awssdk.services.lightsail.model.AllocateStaticIpResponse;
import software.amazon.awssdk.services.lightsail.model.AttachStaticIpRequest;
import software.amazon.awssdk.services.lightsail.model.AttachStaticIpResponse;
import software.amazon.awssdk.services.lightsail.model.CloseInstancePublicPortsRequest;
import software.amazon.awssdk.services.lightsail.model.CloseInstancePublicPortsResponse;
import software.amazon.awssdk.services.lightsail.model.CreateDomainEntryRequest;
import software.amazon.awssdk.services.lightsail.model.CreateDomainEntryResponse;
import software.amazon.awssdk.services.lightsail.model.CreateDomainRequest;
import software.amazon.awssdk.services.lightsail.model.CreateDomainResponse;
import software.amazon.awssdk.services.lightsail.model.CreateInstanceSnapshotRequest;
import software.amazon.awssdk.services.lightsail.model.CreateInstanceSnapshotResponse;
import software.amazon.awssdk.services.lightsail.model.CreateInstancesFromSnapshotRequest;
import software.amazon.awssdk.services.lightsail.model.CreateInstancesFromSnapshotResponse;
import software.amazon.awssdk.services.lightsail.model.CreateInstancesRequest;
import software.amazon.awssdk.services.lightsail.model.CreateInstancesResponse;
import software.amazon.awssdk.services.lightsail.model.CreateKeyPairRequest;
import software.amazon.awssdk.services.lightsail.model.CreateKeyPairResponse;
import software.amazon.awssdk.services.lightsail.model.DeleteDomainEntryRequest;
import software.amazon.awssdk.services.lightsail.model.DeleteDomainEntryResponse;
import software.amazon.awssdk.services.lightsail.model.DeleteDomainRequest;
import software.amazon.awssdk.services.lightsail.model.DeleteDomainResponse;
import software.amazon.awssdk.services.lightsail.model.DeleteInstanceRequest;
import software.amazon.awssdk.services.lightsail.model.DeleteInstanceResponse;
import software.amazon.awssdk.services.lightsail.model.DeleteInstanceSnapshotRequest;
import software.amazon.awssdk.services.lightsail.model.DeleteInstanceSnapshotResponse;
import software.amazon.awssdk.services.lightsail.model.DeleteKeyPairRequest;
import software.amazon.awssdk.services.lightsail.model.DeleteKeyPairResponse;
import software.amazon.awssdk.services.lightsail.model.DetachStaticIpRequest;
import software.amazon.awssdk.services.lightsail.model.DetachStaticIpResponse;
import software.amazon.awssdk.services.lightsail.model.DownloadDefaultKeyPairRequest;
import software.amazon.awssdk.services.lightsail.model.DownloadDefaultKeyPairResponse;
import software.amazon.awssdk.services.lightsail.model.GetActiveNamesRequest;
import software.amazon.awssdk.services.lightsail.model.GetActiveNamesResponse;
import software.amazon.awssdk.services.lightsail.model.GetBlueprintsRequest;
import software.amazon.awssdk.services.lightsail.model.GetBlueprintsResponse;
import software.amazon.awssdk.services.lightsail.model.GetBundlesRequest;
import software.amazon.awssdk.services.lightsail.model.GetBundlesResponse;
import software.amazon.awssdk.services.lightsail.model.GetDomainRequest;
import software.amazon.awssdk.services.lightsail.model.GetDomainResponse;
import software.amazon.awssdk.services.lightsail.model.GetDomainsRequest;
import software.amazon.awssdk.services.lightsail.model.GetDomainsResponse;
import software.amazon.awssdk.services.lightsail.model.GetInstanceAccessDetailsRequest;
import software.amazon.awssdk.services.lightsail.model.GetInstanceAccessDetailsResponse;
import software.amazon.awssdk.services.lightsail.model.GetInstanceMetricDataRequest;
import software.amazon.awssdk.services.lightsail.model.GetInstanceMetricDataResponse;
import software.amazon.awssdk.services.lightsail.model.GetInstancePortStatesRequest;
import software.amazon.awssdk.services.lightsail.model.GetInstancePortStatesResponse;
import software.amazon.awssdk.services.lightsail.model.GetInstanceRequest;
import software.amazon.awssdk.services.lightsail.model.GetInstanceResponse;
import software.amazon.awssdk.services.lightsail.model.GetInstanceSnapshotRequest;
import software.amazon.awssdk.services.lightsail.model.GetInstanceSnapshotResponse;
import software.amazon.awssdk.services.lightsail.model.GetInstanceSnapshotsRequest;
import software.amazon.awssdk.services.lightsail.model.GetInstanceSnapshotsResponse;
import software.amazon.awssdk.services.lightsail.model.GetInstanceStateRequest;
import software.amazon.awssdk.services.lightsail.model.GetInstanceStateResponse;
import software.amazon.awssdk.services.lightsail.model.GetInstancesRequest;
import software.amazon.awssdk.services.lightsail.model.GetInstancesResponse;
import software.amazon.awssdk.services.lightsail.model.GetKeyPairRequest;
import software.amazon.awssdk.services.lightsail.model.GetKeyPairResponse;
import software.amazon.awssdk.services.lightsail.model.GetKeyPairsRequest;
import software.amazon.awssdk.services.lightsail.model.GetKeyPairsResponse;
import software.amazon.awssdk.services.lightsail.model.GetOperationRequest;
import software.amazon.awssdk.services.lightsail.model.GetOperationResponse;
import software.amazon.awssdk.services.lightsail.model.GetOperationsForResourceRequest;
import software.amazon.awssdk.services.lightsail.model.GetOperationsForResourceResponse;
import software.amazon.awssdk.services.lightsail.model.GetOperationsRequest;
import software.amazon.awssdk.services.lightsail.model.GetOperationsResponse;
import software.amazon.awssdk.services.lightsail.model.GetRegionsRequest;
import software.amazon.awssdk.services.lightsail.model.GetRegionsResponse;
import software.amazon.awssdk.services.lightsail.model.GetStaticIpRequest;
import software.amazon.awssdk.services.lightsail.model.GetStaticIpResponse;
import software.amazon.awssdk.services.lightsail.model.GetStaticIpsRequest;
import software.amazon.awssdk.services.lightsail.model.GetStaticIpsResponse;
import software.amazon.awssdk.services.lightsail.model.ImportKeyPairRequest;
import software.amazon.awssdk.services.lightsail.model.ImportKeyPairResponse;
import software.amazon.awssdk.services.lightsail.model.InvalidInputException;
import software.amazon.awssdk.services.lightsail.model.IsVpcPeeredRequest;
import software.amazon.awssdk.services.lightsail.model.IsVpcPeeredResponse;
import software.amazon.awssdk.services.lightsail.model.NotFoundException;
import software.amazon.awssdk.services.lightsail.model.OpenInstancePublicPortsRequest;
import software.amazon.awssdk.services.lightsail.model.OpenInstancePublicPortsResponse;
import software.amazon.awssdk.services.lightsail.model.OperationFailureException;
import software.amazon.awssdk.services.lightsail.model.PeerVpcRequest;
import software.amazon.awssdk.services.lightsail.model.PeerVpcResponse;
import software.amazon.awssdk.services.lightsail.model.PutInstancePublicPortsRequest;
import software.amazon.awssdk.services.lightsail.model.PutInstancePublicPortsResponse;
import software.amazon.awssdk.services.lightsail.model.RebootInstanceRequest;
import software.amazon.awssdk.services.lightsail.model.RebootInstanceResponse;
import software.amazon.awssdk.services.lightsail.model.ReleaseStaticIpRequest;
import software.amazon.awssdk.services.lightsail.model.ReleaseStaticIpResponse;
import software.amazon.awssdk.services.lightsail.model.ServiceException;
import software.amazon.awssdk.services.lightsail.model.StartInstanceRequest;
import software.amazon.awssdk.services.lightsail.model.StartInstanceResponse;
import software.amazon.awssdk.services.lightsail.model.StopInstanceRequest;
import software.amazon.awssdk.services.lightsail.model.StopInstanceResponse;
import software.amazon.awssdk.services.lightsail.model.UnauthenticatedException;
import software.amazon.awssdk.services.lightsail.model.UnpeerVpcRequest;
import software.amazon.awssdk.services.lightsail.model.UnpeerVpcResponse;
import software.amazon.awssdk.services.lightsail.model.UpdateDomainEntryRequest;
import software.amazon.awssdk.services.lightsail.model.UpdateDomainEntryResponse;
import software.amazon.awssdk.services.lightsail.transform.AllocateStaticIpRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.AllocateStaticIpResponseUnmarshaller;
import software.amazon.awssdk.services.lightsail.transform.AttachStaticIpRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.AttachStaticIpResponseUnmarshaller;
import software.amazon.awssdk.services.lightsail.transform.CloseInstancePublicPortsRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.CloseInstancePublicPortsResponseUnmarshaller;
import software.amazon.awssdk.services.lightsail.transform.CreateDomainEntryRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.CreateDomainEntryResponseUnmarshaller;
import software.amazon.awssdk.services.lightsail.transform.CreateDomainRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.CreateDomainResponseUnmarshaller;
import software.amazon.awssdk.services.lightsail.transform.CreateInstanceSnapshotRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.CreateInstanceSnapshotResponseUnmarshaller;
import software.amazon.awssdk.services.lightsail.transform.CreateInstancesFromSnapshotRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.CreateInstancesFromSnapshotResponseUnmarshaller;
import software.amazon.awssdk.services.lightsail.transform.CreateInstancesRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.CreateInstancesResponseUnmarshaller;
import software.amazon.awssdk.services.lightsail.transform.CreateKeyPairRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.CreateKeyPairResponseUnmarshaller;
import software.amazon.awssdk.services.lightsail.transform.DeleteDomainEntryRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.DeleteDomainEntryResponseUnmarshaller;
import software.amazon.awssdk.services.lightsail.transform.DeleteDomainRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.DeleteDomainResponseUnmarshaller;
import software.amazon.awssdk.services.lightsail.transform.DeleteInstanceRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.DeleteInstanceResponseUnmarshaller;
import software.amazon.awssdk.services.lightsail.transform.DeleteInstanceSnapshotRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.DeleteInstanceSnapshotResponseUnmarshaller;
import software.amazon.awssdk.services.lightsail.transform.DeleteKeyPairRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.DeleteKeyPairResponseUnmarshaller;
import software.amazon.awssdk.services.lightsail.transform.DetachStaticIpRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.DetachStaticIpResponseUnmarshaller;
import software.amazon.awssdk.services.lightsail.transform.DownloadDefaultKeyPairRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.DownloadDefaultKeyPairResponseUnmarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetActiveNamesRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetActiveNamesResponseUnmarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetBlueprintsRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetBlueprintsResponseUnmarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetBundlesRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetBundlesResponseUnmarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetDomainRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetDomainResponseUnmarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetDomainsRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetDomainsResponseUnmarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetInstanceAccessDetailsRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetInstanceAccessDetailsResponseUnmarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetInstanceMetricDataRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetInstanceMetricDataResponseUnmarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetInstancePortStatesRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetInstancePortStatesResponseUnmarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetInstanceRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetInstanceResponseUnmarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetInstanceSnapshotRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetInstanceSnapshotResponseUnmarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetInstanceSnapshotsRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetInstanceSnapshotsResponseUnmarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetInstanceStateRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetInstanceStateResponseUnmarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetInstancesRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetInstancesResponseUnmarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetKeyPairRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetKeyPairResponseUnmarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetKeyPairsRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetKeyPairsResponseUnmarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetOperationRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetOperationResponseUnmarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetOperationsForResourceRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetOperationsForResourceResponseUnmarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetOperationsRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetOperationsResponseUnmarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetRegionsRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetRegionsResponseUnmarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetStaticIpRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetStaticIpResponseUnmarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetStaticIpsRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetStaticIpsResponseUnmarshaller;
import software.amazon.awssdk.services.lightsail.transform.ImportKeyPairRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.ImportKeyPairResponseUnmarshaller;
import software.amazon.awssdk.services.lightsail.transform.IsVpcPeeredRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.IsVpcPeeredResponseUnmarshaller;
import software.amazon.awssdk.services.lightsail.transform.OpenInstancePublicPortsRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.OpenInstancePublicPortsResponseUnmarshaller;
import software.amazon.awssdk.services.lightsail.transform.PeerVpcRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.PeerVpcResponseUnmarshaller;
import software.amazon.awssdk.services.lightsail.transform.PutInstancePublicPortsRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.PutInstancePublicPortsResponseUnmarshaller;
import software.amazon.awssdk.services.lightsail.transform.RebootInstanceRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.RebootInstanceResponseUnmarshaller;
import software.amazon.awssdk.services.lightsail.transform.ReleaseStaticIpRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.ReleaseStaticIpResponseUnmarshaller;
import software.amazon.awssdk.services.lightsail.transform.StartInstanceRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.StartInstanceResponseUnmarshaller;
import software.amazon.awssdk.services.lightsail.transform.StopInstanceRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.StopInstanceResponseUnmarshaller;
import software.amazon.awssdk.services.lightsail.transform.UnpeerVpcRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.UnpeerVpcResponseUnmarshaller;
import software.amazon.awssdk.services.lightsail.transform.UpdateDomainEntryRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.UpdateDomainEntryResponseUnmarshaller;

/**
 * Internal implementation of {@link LightsailAsyncClient}.
 *
 * @see LightsailAsyncClient#builder()
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
final class DefaultLightsailAsyncClient implements LightsailAsyncClient {
    private final AsyncClientHandler clientHandler;

    private final SdkJsonProtocolFactory protocolFactory;

    protected DefaultLightsailAsyncClient(AwsAsyncClientParams clientParams) {
        this.clientHandler = new SdkAsyncClientHandler(new ClientHandlerParams().withAsyncClientParams(clientParams)
                .withClientParams(clientParams).withCalculateCrc32FromCompressedDataEnabled(false));
        this.protocolFactory = init();
    }

    /**
     * <p>
     * Allocates a static IP address.
     * </p>
     * 
     * @param allocateStaticIpRequest
     * @return A Java Future containing the result of the AllocateStaticIp operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this</li >
     *         <ul>
     * @sample LightsailAsyncClient.AllocateStaticIp
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/AllocateStaticIp" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<AllocateStaticIpResponse> allocateStaticIp(AllocateStaticIpRequest allocateStaticIpRequest) {

        HttpResponseHandler<AllocateStaticIpResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new AllocateStaticIpResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<AllocateStaticIpRequest, AllocateStaticIpResponse>()
                .withMarshaller(new AllocateStaticIpRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(allocateStaticIpRequest));
    }

    /**
     * <p>
     * Attaches a static IP address to a specific Amazon Lightsail instance.
     * </p>
     * 
     * @param attachStaticIpRequest
     * @return A Java Future containing the result of the AttachStaticIp operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this</li >
     *         <ul>
     * @sample LightsailAsyncClient.AttachStaticIp
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/AttachStaticIp" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<AttachStaticIpResponse> attachStaticIp(AttachStaticIpRequest attachStaticIpRequest) {

        HttpResponseHandler<AttachStaticIpResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new AttachStaticIpResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<AttachStaticIpRequest, AttachStaticIpResponse>()
                .withMarshaller(new AttachStaticIpRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(attachStaticIpRequest));
    }

    /**
     * <p>
     * Closes the public ports on a specific Amazon Lightsail instance.
     * </p>
     * 
     * @param closeInstancePublicPortsRequest
     * @return A Java Future containing the result of the CloseInstancePublicPorts operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this</li >
     *         <ul>
     * @sample LightsailAsyncClient.CloseInstancePublicPorts
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/CloseInstancePublicPorts"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CloseInstancePublicPortsResponse> closeInstancePublicPorts(
            CloseInstancePublicPortsRequest closeInstancePublicPortsRequest) {

        HttpResponseHandler<CloseInstancePublicPortsResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new CloseInstancePublicPortsResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler
                .execute(new ClientExecutionParams<CloseInstancePublicPortsRequest, CloseInstancePublicPortsResponse>()
                        .withMarshaller(new CloseInstancePublicPortsRequestMarshaller(protocolFactory))
                        .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                        .withInput(closeInstancePublicPortsRequest));
    }

    /**
     * <p>
     * Creates a domain resource for the specified domain (e.g., example.com).
     * </p>
     * 
     * @param createDomainRequest
     * @return A Java Future containing the result of the CreateDomain operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this</li >
     *         <ul>
     * @sample LightsailAsyncClient.CreateDomain
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/CreateDomain" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateDomainResponse> createDomain(CreateDomainRequest createDomainRequest) {

        HttpResponseHandler<CreateDomainResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new CreateDomainResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<CreateDomainRequest, CreateDomainResponse>()
                .withMarshaller(new CreateDomainRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(createDomainRequest));
    }

    /**
     * <p>
     * Creates one of the following entry records associated with the domain: A record, CNAME record, TXT record, or MX
     * record.
     * </p>
     * 
     * @param createDomainEntryRequest
     * @return A Java Future containing the result of the CreateDomainEntry operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this</li >
     *         <ul>
     * @sample LightsailAsyncClient.CreateDomainEntry
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/CreateDomainEntry" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateDomainEntryResponse> createDomainEntry(CreateDomainEntryRequest createDomainEntryRequest) {

        HttpResponseHandler<CreateDomainEntryResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new CreateDomainEntryResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<CreateDomainEntryRequest, CreateDomainEntryResponse>()
                .withMarshaller(new CreateDomainEntryRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(createDomainEntryRequest));
    }

    /**
     * <p>
     * Creates a snapshot of a specific virtual private server, or <i>instance</i>. You can use a snapshot to create a
     * new instance that is based on that snapshot.
     * </p>
     * 
     * @param createInstanceSnapshotRequest
     * @return A Java Future containing the result of the CreateInstanceSnapshot operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this</li >
     *         <ul>
     * @sample LightsailAsyncClient.CreateInstanceSnapshot
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/CreateInstanceSnapshot"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateInstanceSnapshotResponse> createInstanceSnapshot(
            CreateInstanceSnapshotRequest createInstanceSnapshotRequest) {

        HttpResponseHandler<CreateInstanceSnapshotResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new CreateInstanceSnapshotResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<CreateInstanceSnapshotRequest, CreateInstanceSnapshotResponse>()
                .withMarshaller(new CreateInstanceSnapshotRequestMarshaller(protocolFactory))
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(createInstanceSnapshotRequest));
    }

    /**
     * <p>
     * Creates one or more Amazon Lightsail virtual private servers, or <i>instances</i>.
     * </p>
     * 
     * @param createInstancesRequest
     * @return A Java Future containing the result of the CreateInstances operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this</li >
     *         <ul>
     * @sample LightsailAsyncClient.CreateInstances
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/CreateInstances" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateInstancesResponse> createInstances(CreateInstancesRequest createInstancesRequest) {

        HttpResponseHandler<CreateInstancesResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new CreateInstancesResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<CreateInstancesRequest, CreateInstancesResponse>()
                .withMarshaller(new CreateInstancesRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(createInstancesRequest));
    }

    /**
     * <p>
     * Uses a specific snapshot as a blueprint for creating one or more new instances that are based on that identical
     * configuration.
     * </p>
     * 
     * @param createInstancesFromSnapshotRequest
     * @return A Java Future containing the result of the CreateInstancesFromSnapshot operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this</li >
     *         <ul>
     * @sample LightsailAsyncClient.CreateInstancesFromSnapshot
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/CreateInstancesFromSnapshot"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateInstancesFromSnapshotResponse> createInstancesFromSnapshot(
            CreateInstancesFromSnapshotRequest createInstancesFromSnapshotRequest) {

        HttpResponseHandler<CreateInstancesFromSnapshotResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new CreateInstancesFromSnapshotResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler
                .execute(new ClientExecutionParams<CreateInstancesFromSnapshotRequest, CreateInstancesFromSnapshotResponse>()
                        .withMarshaller(new CreateInstancesFromSnapshotRequestMarshaller(protocolFactory))
                        .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                        .withInput(createInstancesFromSnapshotRequest));
    }

    /**
     * <p>
     * Creates sn SSH key pair.
     * </p>
     * 
     * @param createKeyPairRequest
     * @return A Java Future containing the result of the CreateKeyPair operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this</li >
     *         <ul>
     * @sample LightsailAsyncClient.CreateKeyPair
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/CreateKeyPair" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateKeyPairResponse> createKeyPair(CreateKeyPairRequest createKeyPairRequest) {

        HttpResponseHandler<CreateKeyPairResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new CreateKeyPairResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<CreateKeyPairRequest, CreateKeyPairResponse>()
                .withMarshaller(new CreateKeyPairRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(createKeyPairRequest));
    }

    /**
     * <p>
     * Deletes the specified domain recordset and all of its domain records.
     * </p>
     * 
     * @param deleteDomainRequest
     * @return A Java Future containing the result of the DeleteDomain operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this</li >
     *         <ul>
     * @sample LightsailAsyncClient.DeleteDomain
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/DeleteDomain" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteDomainResponse> deleteDomain(DeleteDomainRequest deleteDomainRequest) {

        HttpResponseHandler<DeleteDomainResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new DeleteDomainResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<DeleteDomainRequest, DeleteDomainResponse>()
                .withMarshaller(new DeleteDomainRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(deleteDomainRequest));
    }

    /**
     * <p>
     * Deletes a specific domain entry.
     * </p>
     * 
     * @param deleteDomainEntryRequest
     * @return A Java Future containing the result of the DeleteDomainEntry operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this</li >
     *         <ul>
     * @sample LightsailAsyncClient.DeleteDomainEntry
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/DeleteDomainEntry" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteDomainEntryResponse> deleteDomainEntry(DeleteDomainEntryRequest deleteDomainEntryRequest) {

        HttpResponseHandler<DeleteDomainEntryResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new DeleteDomainEntryResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<DeleteDomainEntryRequest, DeleteDomainEntryResponse>()
                .withMarshaller(new DeleteDomainEntryRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(deleteDomainEntryRequest));
    }

    /**
     * <p>
     * Deletes a specific Amazon Lightsail virtual private server, or <i>instance</i>.
     * </p>
     * 
     * @param deleteInstanceRequest
     * @return A Java Future containing the result of the DeleteInstance operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this</li >
     *         <ul>
     * @sample LightsailAsyncClient.DeleteInstance
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/DeleteInstance" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteInstanceResponse> deleteInstance(DeleteInstanceRequest deleteInstanceRequest) {

        HttpResponseHandler<DeleteInstanceResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new DeleteInstanceResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<DeleteInstanceRequest, DeleteInstanceResponse>()
                .withMarshaller(new DeleteInstanceRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(deleteInstanceRequest));
    }

    /**
     * <p>
     * Deletes a specific snapshot of a virtual private server (or <i>instance</i>).
     * </p>
     * 
     * @param deleteInstanceSnapshotRequest
     * @return A Java Future containing the result of the DeleteInstanceSnapshot operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this</li >
     *         <ul>
     * @sample LightsailAsyncClient.DeleteInstanceSnapshot
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/DeleteInstanceSnapshot"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteInstanceSnapshotResponse> deleteInstanceSnapshot(
            DeleteInstanceSnapshotRequest deleteInstanceSnapshotRequest) {

        HttpResponseHandler<DeleteInstanceSnapshotResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new DeleteInstanceSnapshotResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<DeleteInstanceSnapshotRequest, DeleteInstanceSnapshotResponse>()
                .withMarshaller(new DeleteInstanceSnapshotRequestMarshaller(protocolFactory))
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(deleteInstanceSnapshotRequest));
    }

    /**
     * <p>
     * Deletes a specific SSH key pair.
     * </p>
     * 
     * @param deleteKeyPairRequest
     * @return A Java Future containing the result of the DeleteKeyPair operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this</li >
     *         <ul>
     * @sample LightsailAsyncClient.DeleteKeyPair
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/DeleteKeyPair" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteKeyPairResponse> deleteKeyPair(DeleteKeyPairRequest deleteKeyPairRequest) {

        HttpResponseHandler<DeleteKeyPairResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new DeleteKeyPairResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<DeleteKeyPairRequest, DeleteKeyPairResponse>()
                .withMarshaller(new DeleteKeyPairRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(deleteKeyPairRequest));
    }

    /**
     * <p>
     * Detaches a static IP from the Amazon Lightsail instance to which it is attached.
     * </p>
     * 
     * @param detachStaticIpRequest
     * @return A Java Future containing the result of the DetachStaticIp operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this</li >
     *         <ul>
     * @sample LightsailAsyncClient.DetachStaticIp
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/DetachStaticIp" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DetachStaticIpResponse> detachStaticIp(DetachStaticIpRequest detachStaticIpRequest) {

        HttpResponseHandler<DetachStaticIpResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new DetachStaticIpResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<DetachStaticIpRequest, DetachStaticIpResponse>()
                .withMarshaller(new DetachStaticIpRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(detachStaticIpRequest));
    }

    /**
     * <p>
     * Downloads the default SSH key pair from the user's account.
     * </p>
     * 
     * @param downloadDefaultKeyPairRequest
     * @return A Java Future containing the result of the DownloadDefaultKeyPair operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this</li >
     *         <ul>
     * @sample LightsailAsyncClient.DownloadDefaultKeyPair
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/DownloadDefaultKeyPair"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DownloadDefaultKeyPairResponse> downloadDefaultKeyPair() {
        return downloadDefaultKeyPair(DownloadDefaultKeyPairRequest.builder().build());
    }

    /**
     * <p>
     * Downloads the default SSH key pair from the user's account.
     * </p>
     * 
     * @param downloadDefaultKeyPairRequest
     * @return A Java Future containing the result of the DownloadDefaultKeyPair operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this</li >
     *         <ul>
     * @sample LightsailAsyncClient.DownloadDefaultKeyPair
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/DownloadDefaultKeyPair"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DownloadDefaultKeyPairResponse> downloadDefaultKeyPair(
            DownloadDefaultKeyPairRequest downloadDefaultKeyPairRequest) {

        HttpResponseHandler<DownloadDefaultKeyPairResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new DownloadDefaultKeyPairResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<DownloadDefaultKeyPairRequest, DownloadDefaultKeyPairResponse>()
                .withMarshaller(new DownloadDefaultKeyPairRequestMarshaller(protocolFactory))
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(downloadDefaultKeyPairRequest));
    }

    /**
     * <p>
     * Returns the names of all active (not deleted) resources.
     * </p>
     * 
     * @param getActiveNamesRequest
     * @return A Java Future containing the result of the GetActiveNames operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this</li >
     *         <ul>
     * @sample LightsailAsyncClient.GetActiveNames
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetActiveNames" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetActiveNamesResponse> getActiveNames() {
        return getActiveNames(GetActiveNamesRequest.builder().build());
    }

    /**
     * <p>
     * Returns the names of all active (not deleted) resources.
     * </p>
     * 
     * @param getActiveNamesRequest
     * @return A Java Future containing the result of the GetActiveNames operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this</li >
     *         <ul>
     * @sample LightsailAsyncClient.GetActiveNames
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetActiveNames" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetActiveNamesResponse> getActiveNames(GetActiveNamesRequest getActiveNamesRequest) {

        HttpResponseHandler<GetActiveNamesResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new GetActiveNamesResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<GetActiveNamesRequest, GetActiveNamesResponse>()
                .withMarshaller(new GetActiveNamesRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(getActiveNamesRequest));
    }

    /**
     * <p>
     * Returns the list of available instance images, or <i>blueprints</i>. You can use a blueprint to create a new
     * virtual private server already running a specific operating system, as well as a preinstalled app or development
     * stack. The software each instance is running depends on the blueprint image you choose.
     * </p>
     * 
     * @param getBlueprintsRequest
     * @return A Java Future containing the result of the GetBlueprints operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this</li >
     *         <ul>
     * @sample LightsailAsyncClient.GetBlueprints
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetBlueprints" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetBlueprintsResponse> getBlueprints() {
        return getBlueprints(GetBlueprintsRequest.builder().build());
    }

    /**
     * <p>
     * Returns the list of available instance images, or <i>blueprints</i>. You can use a blueprint to create a new
     * virtual private server already running a specific operating system, as well as a preinstalled app or development
     * stack. The software each instance is running depends on the blueprint image you choose.
     * </p>
     * 
     * @param getBlueprintsRequest
     * @return A Java Future containing the result of the GetBlueprints operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this</li >
     *         <ul>
     * @sample LightsailAsyncClient.GetBlueprints
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetBlueprints" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetBlueprintsResponse> getBlueprints(GetBlueprintsRequest getBlueprintsRequest) {

        HttpResponseHandler<GetBlueprintsResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new GetBlueprintsResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<GetBlueprintsRequest, GetBlueprintsResponse>()
                .withMarshaller(new GetBlueprintsRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(getBlueprintsRequest));
    }

    /**
     * <p>
     * Returns the list of bundles that are available for purchase. A bundle describes the specs for your virtual
     * private server (or <i>instance</i>).
     * </p>
     * 
     * @param getBundlesRequest
     * @return A Java Future containing the result of the GetBundles operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this</li >
     *         <ul>
     * @sample LightsailAsyncClient.GetBundles
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetBundles" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetBundlesResponse> getBundles() {
        return getBundles(GetBundlesRequest.builder().build());
    }

    /**
     * <p>
     * Returns the list of bundles that are available for purchase. A bundle describes the specs for your virtual
     * private server (or <i>instance</i>).
     * </p>
     * 
     * @param getBundlesRequest
     * @return A Java Future containing the result of the GetBundles operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this</li >
     *         <ul>
     * @sample LightsailAsyncClient.GetBundles
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetBundles" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetBundlesResponse> getBundles(GetBundlesRequest getBundlesRequest) {

        HttpResponseHandler<GetBundlesResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new GetBundlesResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<GetBundlesRequest, GetBundlesResponse>()
                .withMarshaller(new GetBundlesRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(getBundlesRequest));
    }

    /**
     * <p>
     * Returns information about a specific domain recordset.
     * </p>
     * 
     * @param getDomainRequest
     * @return A Java Future containing the result of the GetDomain operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this</li >
     *         <ul>
     * @sample LightsailAsyncClient.GetDomain
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetDomain" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetDomainResponse> getDomain(GetDomainRequest getDomainRequest) {

        HttpResponseHandler<GetDomainResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new GetDomainResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<GetDomainRequest, GetDomainResponse>()
                .withMarshaller(new GetDomainRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(getDomainRequest));
    }

    /**
     * <p>
     * Returns a list of all domains in the user's account.
     * </p>
     * 
     * @param getDomainsRequest
     * @return A Java Future containing the result of the GetDomains operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this</li >
     *         <ul>
     * @sample LightsailAsyncClient.GetDomains
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetDomains" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetDomainsResponse> getDomains() {
        return getDomains(GetDomainsRequest.builder().build());
    }

    /**
     * <p>
     * Returns a list of all domains in the user's account.
     * </p>
     * 
     * @param getDomainsRequest
     * @return A Java Future containing the result of the GetDomains operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this</li >
     *         <ul>
     * @sample LightsailAsyncClient.GetDomains
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetDomains" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetDomainsResponse> getDomains(GetDomainsRequest getDomainsRequest) {

        HttpResponseHandler<GetDomainsResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new GetDomainsResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<GetDomainsRequest, GetDomainsResponse>()
                .withMarshaller(new GetDomainsRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(getDomainsRequest));
    }

    /**
     * <p>
     * Returns information about a specific Amazon Lightsail instance, which is a virtual private server.
     * </p>
     * 
     * @param getInstanceRequest
     * @return A Java Future containing the result of the GetInstance operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this</li >
     *         <ul>
     * @sample LightsailAsyncClient.GetInstance
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetInstance" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetInstanceResponse> getInstance(GetInstanceRequest getInstanceRequest) {

        HttpResponseHandler<GetInstanceResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new GetInstanceResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<GetInstanceRequest, GetInstanceResponse>()
                .withMarshaller(new GetInstanceRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(getInstanceRequest));
    }

    /**
     * <p>
     * Returns temporary SSH keys you can use to connect to a specific virtual private server, or <i>instance</i>.
     * </p>
     * 
     * @param getInstanceAccessDetailsRequest
     * @return A Java Future containing the result of the GetInstanceAccessDetails operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this</li >
     *         <ul>
     * @sample LightsailAsyncClient.GetInstanceAccessDetails
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetInstanceAccessDetails"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetInstanceAccessDetailsResponse> getInstanceAccessDetails(
            GetInstanceAccessDetailsRequest getInstanceAccessDetailsRequest) {

        HttpResponseHandler<GetInstanceAccessDetailsResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new GetInstanceAccessDetailsResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler
                .execute(new ClientExecutionParams<GetInstanceAccessDetailsRequest, GetInstanceAccessDetailsResponse>()
                        .withMarshaller(new GetInstanceAccessDetailsRequestMarshaller(protocolFactory))
                        .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                        .withInput(getInstanceAccessDetailsRequest));
    }

    /**
     * <p>
     * Returns the data points for the specified Amazon Lightsail instance metric, given an instance name.
     * </p>
     * 
     * @param getInstanceMetricDataRequest
     * @return A Java Future containing the result of the GetInstanceMetricData operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this</li >
     *         <ul>
     * @sample LightsailAsyncClient.GetInstanceMetricData
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetInstanceMetricData"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetInstanceMetricDataResponse> getInstanceMetricData(
            GetInstanceMetricDataRequest getInstanceMetricDataRequest) {

        HttpResponseHandler<GetInstanceMetricDataResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new GetInstanceMetricDataResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<GetInstanceMetricDataRequest, GetInstanceMetricDataResponse>()
                .withMarshaller(new GetInstanceMetricDataRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(getInstanceMetricDataRequest));
    }

    /**
     * <p>
     * Returns the port states for a specific virtual private server, or <i>instance</i>.
     * </p>
     * 
     * @param getInstancePortStatesRequest
     * @return A Java Future containing the result of the GetInstancePortStates operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this</li >
     *         <ul>
     * @sample LightsailAsyncClient.GetInstancePortStates
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetInstancePortStates"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetInstancePortStatesResponse> getInstancePortStates(
            GetInstancePortStatesRequest getInstancePortStatesRequest) {

        HttpResponseHandler<GetInstancePortStatesResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new GetInstancePortStatesResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<GetInstancePortStatesRequest, GetInstancePortStatesResponse>()
                .withMarshaller(new GetInstancePortStatesRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(getInstancePortStatesRequest));
    }

    /**
     * <p>
     * Returns information about a specific instance snapshot.
     * </p>
     * 
     * @param getInstanceSnapshotRequest
     * @return A Java Future containing the result of the GetInstanceSnapshot operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this</li >
     *         <ul>
     * @sample LightsailAsyncClient.GetInstanceSnapshot
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetInstanceSnapshot" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<GetInstanceSnapshotResponse> getInstanceSnapshot(
            GetInstanceSnapshotRequest getInstanceSnapshotRequest) {

        HttpResponseHandler<GetInstanceSnapshotResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new GetInstanceSnapshotResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<GetInstanceSnapshotRequest, GetInstanceSnapshotResponse>()
                .withMarshaller(new GetInstanceSnapshotRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(getInstanceSnapshotRequest));
    }

    /**
     * <p>
     * Returns all instance snapshots for the user's account.
     * </p>
     * 
     * @param getInstanceSnapshotsRequest
     * @return A Java Future containing the result of the GetInstanceSnapshots operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this</li >
     *         <ul>
     * @sample LightsailAsyncClient.GetInstanceSnapshots
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetInstanceSnapshots" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<GetInstanceSnapshotsResponse> getInstanceSnapshots() {
        return getInstanceSnapshots(GetInstanceSnapshotsRequest.builder().build());
    }

    /**
     * <p>
     * Returns all instance snapshots for the user's account.
     * </p>
     * 
     * @param getInstanceSnapshotsRequest
     * @return A Java Future containing the result of the GetInstanceSnapshots operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this</li >
     *         <ul>
     * @sample LightsailAsyncClient.GetInstanceSnapshots
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetInstanceSnapshots" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<GetInstanceSnapshotsResponse> getInstanceSnapshots(
            GetInstanceSnapshotsRequest getInstanceSnapshotsRequest) {

        HttpResponseHandler<GetInstanceSnapshotsResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new GetInstanceSnapshotsResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<GetInstanceSnapshotsRequest, GetInstanceSnapshotsResponse>()
                .withMarshaller(new GetInstanceSnapshotsRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(getInstanceSnapshotsRequest));
    }

    /**
     * <p>
     * Returns the state of a specific instance. Works on one instance at a time.
     * </p>
     * 
     * @param getInstanceStateRequest
     * @return A Java Future containing the result of the GetInstanceState operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this</li >
     *         <ul>
     * @sample LightsailAsyncClient.GetInstanceState
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetInstanceState" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetInstanceStateResponse> getInstanceState(GetInstanceStateRequest getInstanceStateRequest) {

        HttpResponseHandler<GetInstanceStateResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new GetInstanceStateResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<GetInstanceStateRequest, GetInstanceStateResponse>()
                .withMarshaller(new GetInstanceStateRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(getInstanceStateRequest));
    }

    /**
     * <p>
     * Returns information about all Amazon Lightsail virtual private servers, or <i>instances</i>.
     * </p>
     * 
     * @param getInstancesRequest
     * @return A Java Future containing the result of the GetInstances operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this</li >
     *         <ul>
     * @sample LightsailAsyncClient.GetInstances
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetInstances" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetInstancesResponse> getInstances() {
        return getInstances(GetInstancesRequest.builder().build());
    }

    /**
     * <p>
     * Returns information about all Amazon Lightsail virtual private servers, or <i>instances</i>.
     * </p>
     * 
     * @param getInstancesRequest
     * @return A Java Future containing the result of the GetInstances operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this</li >
     *         <ul>
     * @sample LightsailAsyncClient.GetInstances
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetInstances" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetInstancesResponse> getInstances(GetInstancesRequest getInstancesRequest) {

        HttpResponseHandler<GetInstancesResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new GetInstancesResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<GetInstancesRequest, GetInstancesResponse>()
                .withMarshaller(new GetInstancesRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(getInstancesRequest));
    }

    /**
     * <p>
     * Returns information about a specific key pair.
     * </p>
     * 
     * @param getKeyPairRequest
     * @return A Java Future containing the result of the GetKeyPair operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this</li >
     *         <ul>
     * @sample LightsailAsyncClient.GetKeyPair
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetKeyPair" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetKeyPairResponse> getKeyPair(GetKeyPairRequest getKeyPairRequest) {

        HttpResponseHandler<GetKeyPairResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new GetKeyPairResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<GetKeyPairRequest, GetKeyPairResponse>()
                .withMarshaller(new GetKeyPairRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(getKeyPairRequest));
    }

    /**
     * <p>
     * Returns information about all key pairs in the user's account.
     * </p>
     * 
     * @param getKeyPairsRequest
     * @return A Java Future containing the result of the GetKeyPairs operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this</li >
     *         <ul>
     * @sample LightsailAsyncClient.GetKeyPairs
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetKeyPairs" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetKeyPairsResponse> getKeyPairs() {
        return getKeyPairs(GetKeyPairsRequest.builder().build());
    }

    /**
     * <p>
     * Returns information about all key pairs in the user's account.
     * </p>
     * 
     * @param getKeyPairsRequest
     * @return A Java Future containing the result of the GetKeyPairs operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this</li >
     *         <ul>
     * @sample LightsailAsyncClient.GetKeyPairs
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetKeyPairs" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetKeyPairsResponse> getKeyPairs(GetKeyPairsRequest getKeyPairsRequest) {

        HttpResponseHandler<GetKeyPairsResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new GetKeyPairsResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<GetKeyPairsRequest, GetKeyPairsResponse>()
                .withMarshaller(new GetKeyPairsRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(getKeyPairsRequest));
    }

    /**
     * <p>
     * Returns information about a specific operation. Operations include events such as when you create an instance,
     * allocate a static IP, attach a static IP, and so on.
     * </p>
     * 
     * @param getOperationRequest
     * @return A Java Future containing the result of the GetOperation operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this</li >
     *         <ul>
     * @sample LightsailAsyncClient.GetOperation
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetOperation" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetOperationResponse> getOperation(GetOperationRequest getOperationRequest) {

        HttpResponseHandler<GetOperationResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new GetOperationResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<GetOperationRequest, GetOperationResponse>()
                .withMarshaller(new GetOperationRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(getOperationRequest));
    }

    /**
     * <p>
     * Returns information about all operations.
     * </p>
     * <p>
     * Results are returned from oldest to newest, up to a maximum of 200. Results can be paged by making each
     * subsequent call to <code>GetOperations</code> use the maximum (last) <code>statusChangedAt</code> value from the
     * previous request.
     * </p>
     * 
     * @param getOperationsRequest
     * @return A Java Future containing the result of the GetOperations operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this</li >
     *         <ul>
     * @sample LightsailAsyncClient.GetOperations
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetOperations" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetOperationsResponse> getOperations() {
        return getOperations(GetOperationsRequest.builder().build());
    }

    /**
     * <p>
     * Returns information about all operations.
     * </p>
     * <p>
     * Results are returned from oldest to newest, up to a maximum of 200. Results can be paged by making each
     * subsequent call to <code>GetOperations</code> use the maximum (last) <code>statusChangedAt</code> value from the
     * previous request.
     * </p>
     * 
     * @param getOperationsRequest
     * @return A Java Future containing the result of the GetOperations operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this</li >
     *         <ul>
     * @sample LightsailAsyncClient.GetOperations
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetOperations" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetOperationsResponse> getOperations(GetOperationsRequest getOperationsRequest) {

        HttpResponseHandler<GetOperationsResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new GetOperationsResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<GetOperationsRequest, GetOperationsResponse>()
                .withMarshaller(new GetOperationsRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(getOperationsRequest));
    }

    /**
     * <p>
     * Gets operations for a specific resource (e.g., an instance or a static IP).
     * </p>
     * 
     * @param getOperationsForResourceRequest
     * @return A Java Future containing the result of the GetOperationsForResource operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this</li >
     *         <ul>
     * @sample LightsailAsyncClient.GetOperationsForResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetOperationsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetOperationsForResourceResponse> getOperationsForResource(
            GetOperationsForResourceRequest getOperationsForResourceRequest) {

        HttpResponseHandler<GetOperationsForResourceResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new GetOperationsForResourceResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler
                .execute(new ClientExecutionParams<GetOperationsForResourceRequest, GetOperationsForResourceResponse>()
                        .withMarshaller(new GetOperationsForResourceRequestMarshaller(protocolFactory))
                        .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                        .withInput(getOperationsForResourceRequest));
    }

    /**
     * <p>
     * Returns a list of all valid regions for Amazon Lightsail. Use the <code>include availability zones</code>
     * parameter to also return the availability zones in a region.
     * </p>
     * 
     * @param getRegionsRequest
     * @return A Java Future containing the result of the GetRegions operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this</li >
     *         <ul>
     * @sample LightsailAsyncClient.GetRegions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetRegions" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetRegionsResponse> getRegions() {
        return getRegions(GetRegionsRequest.builder().build());
    }

    /**
     * <p>
     * Returns a list of all valid regions for Amazon Lightsail. Use the <code>include availability zones</code>
     * parameter to also return the availability zones in a region.
     * </p>
     * 
     * @param getRegionsRequest
     * @return A Java Future containing the result of the GetRegions operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this</li >
     *         <ul>
     * @sample LightsailAsyncClient.GetRegions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetRegions" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetRegionsResponse> getRegions(GetRegionsRequest getRegionsRequest) {

        HttpResponseHandler<GetRegionsResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new GetRegionsResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<GetRegionsRequest, GetRegionsResponse>()
                .withMarshaller(new GetRegionsRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(getRegionsRequest));
    }

    /**
     * <p>
     * Returns information about a specific static IP.
     * </p>
     * 
     * @param getStaticIpRequest
     * @return A Java Future containing the result of the GetStaticIp operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this</li >
     *         <ul>
     * @sample LightsailAsyncClient.GetStaticIp
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetStaticIp" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetStaticIpResponse> getStaticIp(GetStaticIpRequest getStaticIpRequest) {

        HttpResponseHandler<GetStaticIpResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new GetStaticIpResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<GetStaticIpRequest, GetStaticIpResponse>()
                .withMarshaller(new GetStaticIpRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(getStaticIpRequest));
    }

    /**
     * <p>
     * Returns information about all static IPs in the user's account.
     * </p>
     * 
     * @param getStaticIpsRequest
     * @return A Java Future containing the result of the GetStaticIps operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this</li >
     *         <ul>
     * @sample LightsailAsyncClient.GetStaticIps
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetStaticIps" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetStaticIpsResponse> getStaticIps() {
        return getStaticIps(GetStaticIpsRequest.builder().build());
    }

    /**
     * <p>
     * Returns information about all static IPs in the user's account.
     * </p>
     * 
     * @param getStaticIpsRequest
     * @return A Java Future containing the result of the GetStaticIps operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this</li >
     *         <ul>
     * @sample LightsailAsyncClient.GetStaticIps
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetStaticIps" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetStaticIpsResponse> getStaticIps(GetStaticIpsRequest getStaticIpsRequest) {

        HttpResponseHandler<GetStaticIpsResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new GetStaticIpsResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<GetStaticIpsRequest, GetStaticIpsResponse>()
                .withMarshaller(new GetStaticIpsRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(getStaticIpsRequest));
    }

    /**
     * <p>
     * Imports a public SSH key from a specific key pair.
     * </p>
     * 
     * @param importKeyPairRequest
     * @return A Java Future containing the result of the ImportKeyPair operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this</li >
     *         <ul>
     * @sample LightsailAsyncClient.ImportKeyPair
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/ImportKeyPair" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ImportKeyPairResponse> importKeyPair(ImportKeyPairRequest importKeyPairRequest) {

        HttpResponseHandler<ImportKeyPairResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new ImportKeyPairResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<ImportKeyPairRequest, ImportKeyPairResponse>()
                .withMarshaller(new ImportKeyPairRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(importKeyPairRequest));
    }

    /**
     * <p>
     * Returns a Boolean value indicating whether your Lightsail VPC is peered.
     * </p>
     * 
     * @param isVpcPeeredRequest
     * @return A Java Future containing the result of the IsVpcPeered operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this</li >
     *         <ul>
     * @sample LightsailAsyncClient.IsVpcPeered
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/IsVpcPeered" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<IsVpcPeeredResponse> isVpcPeered() {
        return isVpcPeered(IsVpcPeeredRequest.builder().build());
    }

    /**
     * <p>
     * Returns a Boolean value indicating whether your Lightsail VPC is peered.
     * </p>
     * 
     * @param isVpcPeeredRequest
     * @return A Java Future containing the result of the IsVpcPeered operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this</li >
     *         <ul>
     * @sample LightsailAsyncClient.IsVpcPeered
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/IsVpcPeered" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<IsVpcPeeredResponse> isVpcPeered(IsVpcPeeredRequest isVpcPeeredRequest) {

        HttpResponseHandler<IsVpcPeeredResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new IsVpcPeeredResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<IsVpcPeeredRequest, IsVpcPeeredResponse>()
                .withMarshaller(new IsVpcPeeredRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(isVpcPeeredRequest));
    }

    /**
     * <p>
     * Adds public ports to an Amazon Lightsail instance.
     * </p>
     * 
     * @param openInstancePublicPortsRequest
     * @return A Java Future containing the result of the OpenInstancePublicPorts operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this</li >
     *         <ul>
     * @sample LightsailAsyncClient.OpenInstancePublicPorts
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/OpenInstancePublicPorts"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<OpenInstancePublicPortsResponse> openInstancePublicPorts(
            OpenInstancePublicPortsRequest openInstancePublicPortsRequest) {

        HttpResponseHandler<OpenInstancePublicPortsResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new OpenInstancePublicPortsResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<OpenInstancePublicPortsRequest, OpenInstancePublicPortsResponse>()
                .withMarshaller(new OpenInstancePublicPortsRequestMarshaller(protocolFactory))
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(openInstancePublicPortsRequest));
    }

    /**
     * <p>
     * Tries to peer the Lightsail VPC with the user's default VPC.
     * </p>
     * 
     * @param peerVpcRequest
     * @return A Java Future containing the result of the PeerVpc operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this</li >
     *         <ul>
     * @sample LightsailAsyncClient.PeerVpc
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/PeerVpc" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<PeerVpcResponse> peerVpc() {
        return peerVpc(PeerVpcRequest.builder().build());
    }

    /**
     * <p>
     * Tries to peer the Lightsail VPC with the user's default VPC.
     * </p>
     * 
     * @param peerVpcRequest
     * @return A Java Future containing the result of the PeerVpc operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this</li >
     *         <ul>
     * @sample LightsailAsyncClient.PeerVpc
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/PeerVpc" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<PeerVpcResponse> peerVpc(PeerVpcRequest peerVpcRequest) {

        HttpResponseHandler<PeerVpcResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new PeerVpcResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<PeerVpcRequest, PeerVpcResponse>()
                .withMarshaller(new PeerVpcRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(peerVpcRequest));
    }

    /**
     * <p>
     * Sets the specified open ports for an Amazon Lightsail instance, and closes all ports for every protocol not
     * included in the current request.
     * </p>
     * 
     * @param putInstancePublicPortsRequest
     * @return A Java Future containing the result of the PutInstancePublicPorts operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this</li >
     *         <ul>
     * @sample LightsailAsyncClient.PutInstancePublicPorts
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/PutInstancePublicPorts"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<PutInstancePublicPortsResponse> putInstancePublicPorts(
            PutInstancePublicPortsRequest putInstancePublicPortsRequest) {

        HttpResponseHandler<PutInstancePublicPortsResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new PutInstancePublicPortsResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<PutInstancePublicPortsRequest, PutInstancePublicPortsResponse>()
                .withMarshaller(new PutInstancePublicPortsRequestMarshaller(protocolFactory))
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(putInstancePublicPortsRequest));
    }

    /**
     * <p>
     * Restarts a specific instance. When your Amazon Lightsail instance is finished rebooting, Lightsail assigns a new
     * public IP address. To use the same IP address after restarting, create a static IP address and attach it to the
     * instance.
     * </p>
     * 
     * @param rebootInstanceRequest
     * @return A Java Future containing the result of the RebootInstance operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this</li >
     *         <ul>
     * @sample LightsailAsyncClient.RebootInstance
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/RebootInstance" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<RebootInstanceResponse> rebootInstance(RebootInstanceRequest rebootInstanceRequest) {

        HttpResponseHandler<RebootInstanceResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new RebootInstanceResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<RebootInstanceRequest, RebootInstanceResponse>()
                .withMarshaller(new RebootInstanceRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(rebootInstanceRequest));
    }

    /**
     * <p>
     * Deletes a specific static IP from your account.
     * </p>
     * 
     * @param releaseStaticIpRequest
     * @return A Java Future containing the result of the ReleaseStaticIp operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this</li >
     *         <ul>
     * @sample LightsailAsyncClient.ReleaseStaticIp
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/ReleaseStaticIp" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ReleaseStaticIpResponse> releaseStaticIp(ReleaseStaticIpRequest releaseStaticIpRequest) {

        HttpResponseHandler<ReleaseStaticIpResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new ReleaseStaticIpResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<ReleaseStaticIpRequest, ReleaseStaticIpResponse>()
                .withMarshaller(new ReleaseStaticIpRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(releaseStaticIpRequest));
    }

    /**
     * <p>
     * Starts a specific Amazon Lightsail instance from a stopped state. To restart an instance, use the reboot instance
     * operation.
     * </p>
     * 
     * @param startInstanceRequest
     * @return A Java Future containing the result of the StartInstance operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this</li >
     *         <ul>
     * @sample LightsailAsyncClient.StartInstance
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/StartInstance" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<StartInstanceResponse> startInstance(StartInstanceRequest startInstanceRequest) {

        HttpResponseHandler<StartInstanceResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new StartInstanceResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<StartInstanceRequest, StartInstanceResponse>()
                .withMarshaller(new StartInstanceRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(startInstanceRequest));
    }

    /**
     * <p>
     * Stops a specific Amazon Lightsail instance that is currently running.
     * </p>
     * 
     * @param stopInstanceRequest
     * @return A Java Future containing the result of the StopInstance operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this</li >
     *         <ul>
     * @sample LightsailAsyncClient.StopInstance
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/StopInstance" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<StopInstanceResponse> stopInstance(StopInstanceRequest stopInstanceRequest) {

        HttpResponseHandler<StopInstanceResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new StopInstanceResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<StopInstanceRequest, StopInstanceResponse>()
                .withMarshaller(new StopInstanceRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(stopInstanceRequest));
    }

    /**
     * <p>
     * Attempts to unpeer the Lightsail VPC from the user's default VPC.
     * </p>
     * 
     * @param unpeerVpcRequest
     * @return A Java Future containing the result of the UnpeerVpc operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this</li >
     *         <ul>
     * @sample LightsailAsyncClient.UnpeerVpc
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/UnpeerVpc" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<UnpeerVpcResponse> unpeerVpc() {
        return unpeerVpc(UnpeerVpcRequest.builder().build());
    }

    /**
     * <p>
     * Attempts to unpeer the Lightsail VPC from the user's default VPC.
     * </p>
     * 
     * @param unpeerVpcRequest
     * @return A Java Future containing the result of the UnpeerVpc operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this</li >
     *         <ul>
     * @sample LightsailAsyncClient.UnpeerVpc
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/UnpeerVpc" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<UnpeerVpcResponse> unpeerVpc(UnpeerVpcRequest unpeerVpcRequest) {

        HttpResponseHandler<UnpeerVpcResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new UnpeerVpcResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<UnpeerVpcRequest, UnpeerVpcResponse>()
                .withMarshaller(new UnpeerVpcRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(unpeerVpcRequest));
    }

    /**
     * <p>
     * Updates a domain recordset after it is created.
     * </p>
     * 
     * @param updateDomainEntryRequest
     * @return A Java Future containing the result of the UpdateDomainEntry operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain-related APIs are only available in the N. Virginia (us-east-1) Region. Please set your Region
     *         configuration to us-east-1 to create, view, or edit these resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this</li >
     *         <ul>
     * @sample LightsailAsyncClient.UpdateDomainEntry
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/UpdateDomainEntry" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateDomainEntryResponse> updateDomainEntry(UpdateDomainEntryRequest updateDomainEntryRequest) {

        HttpResponseHandler<UpdateDomainEntryResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new UpdateDomainEntryResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<UpdateDomainEntryRequest, UpdateDomainEntryResponse>()
                .withMarshaller(new UpdateDomainEntryRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(updateDomainEntryRequest));
    }

    @Override
    public void close() throws Exception {
        clientHandler.close();
    }

    private software.amazon.awssdk.protocol.json.SdkJsonProtocolFactory init() {
        return new SdkJsonProtocolFactory(
                new JsonClientMetadata()
                        .withProtocolVersion("1.1")
                        .withSupportsCbor(false)
                        .withSupportsIon(false)
                        .withBaseServiceExceptionClass(software.amazon.awssdk.services.lightsail.model.LightsailException.class)
                        .addErrorMetadata(
                                new JsonErrorShapeMetadata().withErrorCode("ServiceException").withModeledClass(
                                        ServiceException.class))
                        .addErrorMetadata(
                                new JsonErrorShapeMetadata().withErrorCode("NotFoundException").withModeledClass(
                                        NotFoundException.class))
                        .addErrorMetadata(
                                new JsonErrorShapeMetadata().withErrorCode("OperationFailureException").withModeledClass(
                                        OperationFailureException.class))
                        .addErrorMetadata(
                                new JsonErrorShapeMetadata().withErrorCode("AccessDeniedException").withModeledClass(
                                        AccessDeniedException.class))
                        .addErrorMetadata(
                                new JsonErrorShapeMetadata().withErrorCode("InvalidInputException").withModeledClass(
                                        InvalidInputException.class))
                        .addErrorMetadata(
                                new JsonErrorShapeMetadata().withErrorCode("AccountSetupInProgressException").withModeledClass(
                                        AccountSetupInProgressException.class))
                        .addErrorMetadata(
                                new JsonErrorShapeMetadata().withErrorCode("UnauthenticatedException").withModeledClass(
                                        UnauthenticatedException.class)));
    }

    private HttpResponseHandler<AmazonServiceException> createErrorResponseHandler() {
        return protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
    }
}
