/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class AttachStaticIpRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<AttachStaticIpRequest.Builder, AttachStaticIpRequest> {
    private final String staticIpName;

    private final String instanceName;

    private AttachStaticIpRequest(BuilderImpl builder) {
        this.staticIpName = builder.staticIpName;
        this.instanceName = builder.instanceName;
    }

    /**
     * <p>
     * The name of the static IP.
     * </p>
     * 
     * @return The name of the static IP.
     */
    public String staticIpName() {
        return staticIpName;
    }

    /**
     * <p>
     * The instance name to which you want to attach the static IP address.
     * </p>
     * 
     * @return The instance name to which you want to attach the static IP address.
     */
    public String instanceName() {
        return instanceName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((staticIpName() == null) ? 0 : staticIpName().hashCode());
        hashCode = 31 * hashCode + ((instanceName() == null) ? 0 : instanceName().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AttachStaticIpRequest)) {
            return false;
        }
        AttachStaticIpRequest other = (AttachStaticIpRequest) obj;
        if (other.staticIpName() == null ^ this.staticIpName() == null) {
            return false;
        }
        if (other.staticIpName() != null && !other.staticIpName().equals(this.staticIpName())) {
            return false;
        }
        if (other.instanceName() == null ^ this.instanceName() == null) {
            return false;
        }
        if (other.instanceName() != null && !other.instanceName().equals(this.instanceName())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (staticIpName() != null) {
            sb.append("StaticIpName: ").append(staticIpName()).append(",");
        }
        if (instanceName() != null) {
            sb.append("InstanceName: ").append(instanceName()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, AttachStaticIpRequest> {
        /**
         * <p>
         * The name of the static IP.
         * </p>
         * 
         * @param staticIpName
         *        The name of the static IP.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder staticIpName(String staticIpName);

        /**
         * <p>
         * The instance name to which you want to attach the static IP address.
         * </p>
         * 
         * @param instanceName
         *        The instance name to which you want to attach the static IP address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceName(String instanceName);
    }

    private static final class BuilderImpl implements Builder {
        private String staticIpName;

        private String instanceName;

        private BuilderImpl() {
        }

        private BuilderImpl(AttachStaticIpRequest model) {
            setStaticIpName(model.staticIpName);
            setInstanceName(model.instanceName);
        }

        public final String getStaticIpName() {
            return staticIpName;
        }

        @Override
        public final Builder staticIpName(String staticIpName) {
            this.staticIpName = staticIpName;
            return this;
        }

        public final void setStaticIpName(String staticIpName) {
            this.staticIpName = staticIpName;
        }

        public final String getInstanceName() {
            return instanceName;
        }

        @Override
        public final Builder instanceName(String instanceName) {
            this.instanceName = instanceName;
            return this;
        }

        public final void setInstanceName(String instanceName) {
            this.instanceName = instanceName;
        }

        @Override
        public AttachStaticIpRequest build() {
            return new AttachStaticIpRequest(this);
        }
    }
}
