/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.lightsail.transform.AvailabilityZoneMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes an Availability Zone.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class AvailabilityZone implements StructuredPojo, ToCopyableBuilder<AvailabilityZone.Builder, AvailabilityZone> {
    private final String zoneName;

    private final String state;

    private AvailabilityZone(BuilderImpl builder) {
        this.zoneName = builder.zoneName;
        this.state = builder.state;
    }

    /**
     * <p>
     * The name of the Availability Zone. The format is <code>us-east-1a</code> (case-sensitive).
     * </p>
     * 
     * @return The name of the Availability Zone. The format is <code>us-east-1a</code> (case-sensitive).
     */
    public String zoneName() {
        return zoneName;
    }

    /**
     * <p>
     * The state of the Availability Zone.
     * </p>
     * 
     * @return The state of the Availability Zone.
     */
    public String state() {
        return state;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((zoneName() == null) ? 0 : zoneName().hashCode());
        hashCode = 31 * hashCode + ((state() == null) ? 0 : state().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AvailabilityZone)) {
            return false;
        }
        AvailabilityZone other = (AvailabilityZone) obj;
        if (other.zoneName() == null ^ this.zoneName() == null) {
            return false;
        }
        if (other.zoneName() != null && !other.zoneName().equals(this.zoneName())) {
            return false;
        }
        if (other.state() == null ^ this.state() == null) {
            return false;
        }
        if (other.state() != null && !other.state().equals(this.state())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (zoneName() != null) {
            sb.append("ZoneName: ").append(zoneName()).append(",");
        }
        if (state() != null) {
            sb.append("State: ").append(state()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        AvailabilityZoneMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, AvailabilityZone> {
        /**
         * <p>
         * The name of the Availability Zone. The format is <code>us-east-1a</code> (case-sensitive).
         * </p>
         * 
         * @param zoneName
         *        The name of the Availability Zone. The format is <code>us-east-1a</code> (case-sensitive).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder zoneName(String zoneName);

        /**
         * <p>
         * The state of the Availability Zone.
         * </p>
         * 
         * @param state
         *        The state of the Availability Zone.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder state(String state);
    }

    private static final class BuilderImpl implements Builder {
        private String zoneName;

        private String state;

        private BuilderImpl() {
        }

        private BuilderImpl(AvailabilityZone model) {
            setZoneName(model.zoneName);
            setState(model.state);
        }

        public final String getZoneName() {
            return zoneName;
        }

        @Override
        public final Builder zoneName(String zoneName) {
            this.zoneName = zoneName;
            return this;
        }

        public final void setZoneName(String zoneName) {
            this.zoneName = zoneName;
        }

        public final String getState() {
            return state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public AvailabilityZone build() {
            return new AvailabilityZone(this);
        }
    }
}
