/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.lightsail.transform.BlueprintMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a blueprint (a virtual private server image).
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class Blueprint implements StructuredPojo, ToCopyableBuilder<Blueprint.Builder, Blueprint> {
    private final String blueprintId;

    private final String name;

    private final String group;

    private final String type;

    private final String description;

    private final Boolean isActive;

    private final Integer minPower;

    private final String version;

    private final String versionCode;

    private final String productUrl;

    private final String licenseUrl;

    private Blueprint(BuilderImpl builder) {
        this.blueprintId = builder.blueprintId;
        this.name = builder.name;
        this.group = builder.group;
        this.type = builder.type;
        this.description = builder.description;
        this.isActive = builder.isActive;
        this.minPower = builder.minPower;
        this.version = builder.version;
        this.versionCode = builder.versionCode;
        this.productUrl = builder.productUrl;
        this.licenseUrl = builder.licenseUrl;
    }

    /**
     * <p>
     * The ID for the virtual private server image (e.g., <code>app_wordpress_4_4</code> or <code>app_lamp_7_0</code>).
     * </p>
     * 
     * @return The ID for the virtual private server image (e.g., <code>app_wordpress_4_4</code> or
     *         <code>app_lamp_7_0</code>).
     */
    public String blueprintId() {
        return blueprintId;
    }

    /**
     * <p>
     * The friendly name of the blueprint (e.g., <code>Amazon Linux</code>).
     * </p>
     * 
     * @return The friendly name of the blueprint (e.g., <code>Amazon Linux</code>).
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The group name of the blueprint (e.g., <code>amazon-linux</code>).
     * </p>
     * 
     * @return The group name of the blueprint (e.g., <code>amazon-linux</code>).
     */
    public String group() {
        return group;
    }

    /**
     * <p>
     * The type of the blueprint (e.g., <code>os</code> or <code>app</code>).
     * </p>
     * 
     * @return The type of the blueprint (e.g., <code>os</code> or <code>app</code>).
     * @see BlueprintType
     */
    public String type() {
        return type;
    }

    /**
     * <p>
     * The description of the blueprint.
     * </p>
     * 
     * @return The description of the blueprint.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * A Boolean value indicating whether the blueprint is active. When you update your blueprints, you will inactivate
     * old blueprints and keep the most recent versions active.
     * </p>
     * 
     * @return A Boolean value indicating whether the blueprint is active. When you update your blueprints, you will
     *         inactivate old blueprints and keep the most recent versions active.
     */
    public Boolean isActive() {
        return isActive;
    }

    /**
     * <p>
     * The minimum machine size required to run this blueprint. <code>0</code> indicates that the blueprint runs on all
     * instances.
     * </p>
     * 
     * @return The minimum machine size required to run this blueprint. <code>0</code> indicates that the blueprint runs
     *         on all instances.
     */
    public Integer minPower() {
        return minPower;
    }

    /**
     * <p>
     * The version number of the operating system, application, or stack (e.g., <code>2016.03.0</code>).
     * </p>
     * 
     * @return The version number of the operating system, application, or stack (e.g., <code>2016.03.0</code>).
     */
    public String version() {
        return version;
    }

    /**
     * <p>
     * The version code.
     * </p>
     * 
     * @return The version code.
     */
    public String versionCode() {
        return versionCode;
    }

    /**
     * <p>
     * The product URL to learn more about the image or blueprint.
     * </p>
     * 
     * @return The product URL to learn more about the image or blueprint.
     */
    public String productUrl() {
        return productUrl;
    }

    /**
     * <p>
     * The end-user license agreement URL for the image or blueprint.
     * </p>
     * 
     * @return The end-user license agreement URL for the image or blueprint.
     */
    public String licenseUrl() {
        return licenseUrl;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((blueprintId() == null) ? 0 : blueprintId().hashCode());
        hashCode = 31 * hashCode + ((name() == null) ? 0 : name().hashCode());
        hashCode = 31 * hashCode + ((group() == null) ? 0 : group().hashCode());
        hashCode = 31 * hashCode + ((type() == null) ? 0 : type().hashCode());
        hashCode = 31 * hashCode + ((description() == null) ? 0 : description().hashCode());
        hashCode = 31 * hashCode + ((isActive() == null) ? 0 : isActive().hashCode());
        hashCode = 31 * hashCode + ((minPower() == null) ? 0 : minPower().hashCode());
        hashCode = 31 * hashCode + ((version() == null) ? 0 : version().hashCode());
        hashCode = 31 * hashCode + ((versionCode() == null) ? 0 : versionCode().hashCode());
        hashCode = 31 * hashCode + ((productUrl() == null) ? 0 : productUrl().hashCode());
        hashCode = 31 * hashCode + ((licenseUrl() == null) ? 0 : licenseUrl().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Blueprint)) {
            return false;
        }
        Blueprint other = (Blueprint) obj;
        if (other.blueprintId() == null ^ this.blueprintId() == null) {
            return false;
        }
        if (other.blueprintId() != null && !other.blueprintId().equals(this.blueprintId())) {
            return false;
        }
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        if (other.name() != null && !other.name().equals(this.name())) {
            return false;
        }
        if (other.group() == null ^ this.group() == null) {
            return false;
        }
        if (other.group() != null && !other.group().equals(this.group())) {
            return false;
        }
        if (other.type() == null ^ this.type() == null) {
            return false;
        }
        if (other.type() != null && !other.type().equals(this.type())) {
            return false;
        }
        if (other.description() == null ^ this.description() == null) {
            return false;
        }
        if (other.description() != null && !other.description().equals(this.description())) {
            return false;
        }
        if (other.isActive() == null ^ this.isActive() == null) {
            return false;
        }
        if (other.isActive() != null && !other.isActive().equals(this.isActive())) {
            return false;
        }
        if (other.minPower() == null ^ this.minPower() == null) {
            return false;
        }
        if (other.minPower() != null && !other.minPower().equals(this.minPower())) {
            return false;
        }
        if (other.version() == null ^ this.version() == null) {
            return false;
        }
        if (other.version() != null && !other.version().equals(this.version())) {
            return false;
        }
        if (other.versionCode() == null ^ this.versionCode() == null) {
            return false;
        }
        if (other.versionCode() != null && !other.versionCode().equals(this.versionCode())) {
            return false;
        }
        if (other.productUrl() == null ^ this.productUrl() == null) {
            return false;
        }
        if (other.productUrl() != null && !other.productUrl().equals(this.productUrl())) {
            return false;
        }
        if (other.licenseUrl() == null ^ this.licenseUrl() == null) {
            return false;
        }
        if (other.licenseUrl() != null && !other.licenseUrl().equals(this.licenseUrl())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (blueprintId() != null) {
            sb.append("BlueprintId: ").append(blueprintId()).append(",");
        }
        if (name() != null) {
            sb.append("Name: ").append(name()).append(",");
        }
        if (group() != null) {
            sb.append("Group: ").append(group()).append(",");
        }
        if (type() != null) {
            sb.append("Type: ").append(type()).append(",");
        }
        if (description() != null) {
            sb.append("Description: ").append(description()).append(",");
        }
        if (isActive() != null) {
            sb.append("IsActive: ").append(isActive()).append(",");
        }
        if (minPower() != null) {
            sb.append("MinPower: ").append(minPower()).append(",");
        }
        if (version() != null) {
            sb.append("Version: ").append(version()).append(",");
        }
        if (versionCode() != null) {
            sb.append("VersionCode: ").append(versionCode()).append(",");
        }
        if (productUrl() != null) {
            sb.append("ProductUrl: ").append(productUrl()).append(",");
        }
        if (licenseUrl() != null) {
            sb.append("LicenseUrl: ").append(licenseUrl()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        BlueprintMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, Blueprint> {
        /**
         * <p>
         * The ID for the virtual private server image (e.g., <code>app_wordpress_4_4</code> or
         * <code>app_lamp_7_0</code>).
         * </p>
         * 
         * @param blueprintId
         *        The ID for the virtual private server image (e.g., <code>app_wordpress_4_4</code> or
         *        <code>app_lamp_7_0</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blueprintId(String blueprintId);

        /**
         * <p>
         * The friendly name of the blueprint (e.g., <code>Amazon Linux</code>).
         * </p>
         * 
         * @param name
         *        The friendly name of the blueprint (e.g., <code>Amazon Linux</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The group name of the blueprint (e.g., <code>amazon-linux</code>).
         * </p>
         * 
         * @param group
         *        The group name of the blueprint (e.g., <code>amazon-linux</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder group(String group);

        /**
         * <p>
         * The type of the blueprint (e.g., <code>os</code> or <code>app</code>).
         * </p>
         * 
         * @param type
         *        The type of the blueprint (e.g., <code>os</code> or <code>app</code>).
         * @see BlueprintType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BlueprintType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of the blueprint (e.g., <code>os</code> or <code>app</code>).
         * </p>
         * 
         * @param type
         *        The type of the blueprint (e.g., <code>os</code> or <code>app</code>).
         * @see BlueprintType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BlueprintType
         */
        Builder type(BlueprintType type);

        /**
         * <p>
         * The description of the blueprint.
         * </p>
         * 
         * @param description
         *        The description of the blueprint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * A Boolean value indicating whether the blueprint is active. When you update your blueprints, you will
         * inactivate old blueprints and keep the most recent versions active.
         * </p>
         * 
         * @param isActive
         *        A Boolean value indicating whether the blueprint is active. When you update your blueprints, you will
         *        inactivate old blueprints and keep the most recent versions active.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isActive(Boolean isActive);

        /**
         * <p>
         * The minimum machine size required to run this blueprint. <code>0</code> indicates that the blueprint runs on
         * all instances.
         * </p>
         * 
         * @param minPower
         *        The minimum machine size required to run this blueprint. <code>0</code> indicates that the blueprint
         *        runs on all instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minPower(Integer minPower);

        /**
         * <p>
         * The version number of the operating system, application, or stack (e.g., <code>2016.03.0</code>).
         * </p>
         * 
         * @param version
         *        The version number of the operating system, application, or stack (e.g., <code>2016.03.0</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder version(String version);

        /**
         * <p>
         * The version code.
         * </p>
         * 
         * @param versionCode
         *        The version code.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder versionCode(String versionCode);

        /**
         * <p>
         * The product URL to learn more about the image or blueprint.
         * </p>
         * 
         * @param productUrl
         *        The product URL to learn more about the image or blueprint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder productUrl(String productUrl);

        /**
         * <p>
         * The end-user license agreement URL for the image or blueprint.
         * </p>
         * 
         * @param licenseUrl
         *        The end-user license agreement URL for the image or blueprint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder licenseUrl(String licenseUrl);
    }

    private static final class BuilderImpl implements Builder {
        private String blueprintId;

        private String name;

        private String group;

        private String type;

        private String description;

        private Boolean isActive;

        private Integer minPower;

        private String version;

        private String versionCode;

        private String productUrl;

        private String licenseUrl;

        private BuilderImpl() {
        }

        private BuilderImpl(Blueprint model) {
            setBlueprintId(model.blueprintId);
            setName(model.name);
            setGroup(model.group);
            setType(model.type);
            setDescription(model.description);
            setIsActive(model.isActive);
            setMinPower(model.minPower);
            setVersion(model.version);
            setVersionCode(model.versionCode);
            setProductUrl(model.productUrl);
            setLicenseUrl(model.licenseUrl);
        }

        public final String getBlueprintId() {
            return blueprintId;
        }

        @Override
        public final Builder blueprintId(String blueprintId) {
            this.blueprintId = blueprintId;
            return this;
        }

        public final void setBlueprintId(String blueprintId) {
            this.blueprintId = blueprintId;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getGroup() {
            return group;
        }

        @Override
        public final Builder group(String group) {
            this.group = group;
            return this;
        }

        public final void setGroup(String group) {
            this.group = group;
        }

        public final String getType() {
            return type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(BlueprintType type) {
            this.type(type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final void setType(BlueprintType type) {
            this.type(type.toString());
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Boolean getIsActive() {
            return isActive;
        }

        @Override
        public final Builder isActive(Boolean isActive) {
            this.isActive = isActive;
            return this;
        }

        public final void setIsActive(Boolean isActive) {
            this.isActive = isActive;
        }

        public final Integer getMinPower() {
            return minPower;
        }

        @Override
        public final Builder minPower(Integer minPower) {
            this.minPower = minPower;
            return this;
        }

        public final void setMinPower(Integer minPower) {
            this.minPower = minPower;
        }

        public final String getVersion() {
            return version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        public final String getVersionCode() {
            return versionCode;
        }

        @Override
        public final Builder versionCode(String versionCode) {
            this.versionCode = versionCode;
            return this;
        }

        public final void setVersionCode(String versionCode) {
            this.versionCode = versionCode;
        }

        public final String getProductUrl() {
            return productUrl;
        }

        @Override
        public final Builder productUrl(String productUrl) {
            this.productUrl = productUrl;
            return this;
        }

        public final void setProductUrl(String productUrl) {
            this.productUrl = productUrl;
        }

        public final String getLicenseUrl() {
            return licenseUrl;
        }

        @Override
        public final Builder licenseUrl(String licenseUrl) {
            this.licenseUrl = licenseUrl;
            return this;
        }

        public final void setLicenseUrl(String licenseUrl) {
            this.licenseUrl = licenseUrl;
        }

        @Override
        public Blueprint build() {
            return new Blueprint(this);
        }
    }
}
