/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.lightsail.transform.BundleMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a bundle, which is a set of specs describing your virtual private server (or <i>instance</i>).
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class Bundle implements StructuredPojo, ToCopyableBuilder<Bundle.Builder, Bundle> {
    private final Float price;

    private final Integer cpuCount;

    private final Integer diskSizeInGb;

    private final String bundleId;

    private final String instanceType;

    private final Boolean isActive;

    private final String name;

    private final Integer power;

    private final Float ramSizeInGb;

    private final Integer transferPerMonthInGb;

    private Bundle(BuilderImpl builder) {
        this.price = builder.price;
        this.cpuCount = builder.cpuCount;
        this.diskSizeInGb = builder.diskSizeInGb;
        this.bundleId = builder.bundleId;
        this.instanceType = builder.instanceType;
        this.isActive = builder.isActive;
        this.name = builder.name;
        this.power = builder.power;
        this.ramSizeInGb = builder.ramSizeInGb;
        this.transferPerMonthInGb = builder.transferPerMonthInGb;
    }

    /**
     * <p>
     * The price in US dollars (e.g., <code>5.0</code>).
     * </p>
     * 
     * @return The price in US dollars (e.g., <code>5.0</code>).
     */
    public Float price() {
        return price;
    }

    /**
     * <p>
     * The number of vCPUs included in the bundle (e.g., <code>2</code>).
     * </p>
     * 
     * @return The number of vCPUs included in the bundle (e.g., <code>2</code>).
     */
    public Integer cpuCount() {
        return cpuCount;
    }

    /**
     * <p>
     * The size of the SSD (e.g., <code>30</code>).
     * </p>
     * 
     * @return The size of the SSD (e.g., <code>30</code>).
     */
    public Integer diskSizeInGb() {
        return diskSizeInGb;
    }

    /**
     * <p>
     * The bundle ID (e.g., <code>micro_1_0</code>).
     * </p>
     * 
     * @return The bundle ID (e.g., <code>micro_1_0</code>).
     */
    public String bundleId() {
        return bundleId;
    }

    /**
     * <p>
     * The Amazon EC2 instance type (e.g., <code>t2.micro</code>).
     * </p>
     * 
     * @return The Amazon EC2 instance type (e.g., <code>t2.micro</code>).
     */
    public String instanceType() {
        return instanceType;
    }

    /**
     * <p>
     * A Boolean value indicating whether the bundle is active.
     * </p>
     * 
     * @return A Boolean value indicating whether the bundle is active.
     */
    public Boolean isActive() {
        return isActive;
    }

    /**
     * <p>
     * A friendly name for the bundle (e.g., <code>Micro</code>).
     * </p>
     * 
     * @return A friendly name for the bundle (e.g., <code>Micro</code>).
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The power of the bundle (e.g., <code>500</code>).
     * </p>
     * 
     * @return The power of the bundle (e.g., <code>500</code>).
     */
    public Integer power() {
        return power;
    }

    /**
     * <p>
     * The amount of RAM in GB (e.g., <code>2.0</code>).
     * </p>
     * 
     * @return The amount of RAM in GB (e.g., <code>2.0</code>).
     */
    public Float ramSizeInGb() {
        return ramSizeInGb;
    }

    /**
     * <p>
     * The data transfer rate per month in GB (e.g., <code>2000</code>).
     * </p>
     * 
     * @return The data transfer rate per month in GB (e.g., <code>2000</code>).
     */
    public Integer transferPerMonthInGb() {
        return transferPerMonthInGb;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((price() == null) ? 0 : price().hashCode());
        hashCode = 31 * hashCode + ((cpuCount() == null) ? 0 : cpuCount().hashCode());
        hashCode = 31 * hashCode + ((diskSizeInGb() == null) ? 0 : diskSizeInGb().hashCode());
        hashCode = 31 * hashCode + ((bundleId() == null) ? 0 : bundleId().hashCode());
        hashCode = 31 * hashCode + ((instanceType() == null) ? 0 : instanceType().hashCode());
        hashCode = 31 * hashCode + ((isActive() == null) ? 0 : isActive().hashCode());
        hashCode = 31 * hashCode + ((name() == null) ? 0 : name().hashCode());
        hashCode = 31 * hashCode + ((power() == null) ? 0 : power().hashCode());
        hashCode = 31 * hashCode + ((ramSizeInGb() == null) ? 0 : ramSizeInGb().hashCode());
        hashCode = 31 * hashCode + ((transferPerMonthInGb() == null) ? 0 : transferPerMonthInGb().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Bundle)) {
            return false;
        }
        Bundle other = (Bundle) obj;
        if (other.price() == null ^ this.price() == null) {
            return false;
        }
        if (other.price() != null && !other.price().equals(this.price())) {
            return false;
        }
        if (other.cpuCount() == null ^ this.cpuCount() == null) {
            return false;
        }
        if (other.cpuCount() != null && !other.cpuCount().equals(this.cpuCount())) {
            return false;
        }
        if (other.diskSizeInGb() == null ^ this.diskSizeInGb() == null) {
            return false;
        }
        if (other.diskSizeInGb() != null && !other.diskSizeInGb().equals(this.diskSizeInGb())) {
            return false;
        }
        if (other.bundleId() == null ^ this.bundleId() == null) {
            return false;
        }
        if (other.bundleId() != null && !other.bundleId().equals(this.bundleId())) {
            return false;
        }
        if (other.instanceType() == null ^ this.instanceType() == null) {
            return false;
        }
        if (other.instanceType() != null && !other.instanceType().equals(this.instanceType())) {
            return false;
        }
        if (other.isActive() == null ^ this.isActive() == null) {
            return false;
        }
        if (other.isActive() != null && !other.isActive().equals(this.isActive())) {
            return false;
        }
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        if (other.name() != null && !other.name().equals(this.name())) {
            return false;
        }
        if (other.power() == null ^ this.power() == null) {
            return false;
        }
        if (other.power() != null && !other.power().equals(this.power())) {
            return false;
        }
        if (other.ramSizeInGb() == null ^ this.ramSizeInGb() == null) {
            return false;
        }
        if (other.ramSizeInGb() != null && !other.ramSizeInGb().equals(this.ramSizeInGb())) {
            return false;
        }
        if (other.transferPerMonthInGb() == null ^ this.transferPerMonthInGb() == null) {
            return false;
        }
        if (other.transferPerMonthInGb() != null && !other.transferPerMonthInGb().equals(this.transferPerMonthInGb())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (price() != null) {
            sb.append("Price: ").append(price()).append(",");
        }
        if (cpuCount() != null) {
            sb.append("CpuCount: ").append(cpuCount()).append(",");
        }
        if (diskSizeInGb() != null) {
            sb.append("DiskSizeInGb: ").append(diskSizeInGb()).append(",");
        }
        if (bundleId() != null) {
            sb.append("BundleId: ").append(bundleId()).append(",");
        }
        if (instanceType() != null) {
            sb.append("InstanceType: ").append(instanceType()).append(",");
        }
        if (isActive() != null) {
            sb.append("IsActive: ").append(isActive()).append(",");
        }
        if (name() != null) {
            sb.append("Name: ").append(name()).append(",");
        }
        if (power() != null) {
            sb.append("Power: ").append(power()).append(",");
        }
        if (ramSizeInGb() != null) {
            sb.append("RamSizeInGb: ").append(ramSizeInGb()).append(",");
        }
        if (transferPerMonthInGb() != null) {
            sb.append("TransferPerMonthInGb: ").append(transferPerMonthInGb()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        BundleMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, Bundle> {
        /**
         * <p>
         * The price in US dollars (e.g., <code>5.0</code>).
         * </p>
         * 
         * @param price
         *        The price in US dollars (e.g., <code>5.0</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder price(Float price);

        /**
         * <p>
         * The number of vCPUs included in the bundle (e.g., <code>2</code>).
         * </p>
         * 
         * @param cpuCount
         *        The number of vCPUs included in the bundle (e.g., <code>2</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cpuCount(Integer cpuCount);

        /**
         * <p>
         * The size of the SSD (e.g., <code>30</code>).
         * </p>
         * 
         * @param diskSizeInGb
         *        The size of the SSD (e.g., <code>30</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder diskSizeInGb(Integer diskSizeInGb);

        /**
         * <p>
         * The bundle ID (e.g., <code>micro_1_0</code>).
         * </p>
         * 
         * @param bundleId
         *        The bundle ID (e.g., <code>micro_1_0</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bundleId(String bundleId);

        /**
         * <p>
         * The Amazon EC2 instance type (e.g., <code>t2.micro</code>).
         * </p>
         * 
         * @param instanceType
         *        The Amazon EC2 instance type (e.g., <code>t2.micro</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceType(String instanceType);

        /**
         * <p>
         * A Boolean value indicating whether the bundle is active.
         * </p>
         * 
         * @param isActive
         *        A Boolean value indicating whether the bundle is active.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isActive(Boolean isActive);

        /**
         * <p>
         * A friendly name for the bundle (e.g., <code>Micro</code>).
         * </p>
         * 
         * @param name
         *        A friendly name for the bundle (e.g., <code>Micro</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The power of the bundle (e.g., <code>500</code>).
         * </p>
         * 
         * @param power
         *        The power of the bundle (e.g., <code>500</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder power(Integer power);

        /**
         * <p>
         * The amount of RAM in GB (e.g., <code>2.0</code>).
         * </p>
         * 
         * @param ramSizeInGb
         *        The amount of RAM in GB (e.g., <code>2.0</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ramSizeInGb(Float ramSizeInGb);

        /**
         * <p>
         * The data transfer rate per month in GB (e.g., <code>2000</code>).
         * </p>
         * 
         * @param transferPerMonthInGb
         *        The data transfer rate per month in GB (e.g., <code>2000</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transferPerMonthInGb(Integer transferPerMonthInGb);
    }

    private static final class BuilderImpl implements Builder {
        private Float price;

        private Integer cpuCount;

        private Integer diskSizeInGb;

        private String bundleId;

        private String instanceType;

        private Boolean isActive;

        private String name;

        private Integer power;

        private Float ramSizeInGb;

        private Integer transferPerMonthInGb;

        private BuilderImpl() {
        }

        private BuilderImpl(Bundle model) {
            setPrice(model.price);
            setCpuCount(model.cpuCount);
            setDiskSizeInGb(model.diskSizeInGb);
            setBundleId(model.bundleId);
            setInstanceType(model.instanceType);
            setIsActive(model.isActive);
            setName(model.name);
            setPower(model.power);
            setRamSizeInGb(model.ramSizeInGb);
            setTransferPerMonthInGb(model.transferPerMonthInGb);
        }

        public final Float getPrice() {
            return price;
        }

        @Override
        public final Builder price(Float price) {
            this.price = price;
            return this;
        }

        public final void setPrice(Float price) {
            this.price = price;
        }

        public final Integer getCpuCount() {
            return cpuCount;
        }

        @Override
        public final Builder cpuCount(Integer cpuCount) {
            this.cpuCount = cpuCount;
            return this;
        }

        public final void setCpuCount(Integer cpuCount) {
            this.cpuCount = cpuCount;
        }

        public final Integer getDiskSizeInGb() {
            return diskSizeInGb;
        }

        @Override
        public final Builder diskSizeInGb(Integer diskSizeInGb) {
            this.diskSizeInGb = diskSizeInGb;
            return this;
        }

        public final void setDiskSizeInGb(Integer diskSizeInGb) {
            this.diskSizeInGb = diskSizeInGb;
        }

        public final String getBundleId() {
            return bundleId;
        }

        @Override
        public final Builder bundleId(String bundleId) {
            this.bundleId = bundleId;
            return this;
        }

        public final void setBundleId(String bundleId) {
            this.bundleId = bundleId;
        }

        public final String getInstanceType() {
            return instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        public final Boolean getIsActive() {
            return isActive;
        }

        @Override
        public final Builder isActive(Boolean isActive) {
            this.isActive = isActive;
            return this;
        }

        public final void setIsActive(Boolean isActive) {
            this.isActive = isActive;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Integer getPower() {
            return power;
        }

        @Override
        public final Builder power(Integer power) {
            this.power = power;
            return this;
        }

        public final void setPower(Integer power) {
            this.power = power;
        }

        public final Float getRamSizeInGb() {
            return ramSizeInGb;
        }

        @Override
        public final Builder ramSizeInGb(Float ramSizeInGb) {
            this.ramSizeInGb = ramSizeInGb;
            return this;
        }

        public final void setRamSizeInGb(Float ramSizeInGb) {
            this.ramSizeInGb = ramSizeInGb;
        }

        public final Integer getTransferPerMonthInGb() {
            return transferPerMonthInGb;
        }

        @Override
        public final Builder transferPerMonthInGb(Integer transferPerMonthInGb) {
            this.transferPerMonthInGb = transferPerMonthInGb;
            return this;
        }

        public final void setTransferPerMonthInGb(Integer transferPerMonthInGb) {
            this.transferPerMonthInGb = transferPerMonthInGb;
        }

        @Override
        public Bundle build() {
            return new Bundle(this);
        }
    }
}
