/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class CreateInstancesFromSnapshotRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<CreateInstancesFromSnapshotRequest.Builder, CreateInstancesFromSnapshotRequest> {
    private final List<String> instanceNames;

    private final String availabilityZone;

    private final String instanceSnapshotName;

    private final String bundleId;

    private final String userData;

    private final String keyPairName;

    private CreateInstancesFromSnapshotRequest(BuilderImpl builder) {
        this.instanceNames = builder.instanceNames;
        this.availabilityZone = builder.availabilityZone;
        this.instanceSnapshotName = builder.instanceSnapshotName;
        this.bundleId = builder.bundleId;
        this.userData = builder.userData;
        this.keyPairName = builder.keyPairName;
    }

    /**
     * <p>
     * The names for your new instances.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The names for your new instances.
     */
    public List<String> instanceNames() {
        return instanceNames;
    }

    /**
     * <p>
     * The Availability Zone where you want to create your instances. Use the following formatting:
     * <code>us-east-1a</code> (case sensitive). You can get a list of availability zones by using the <a
     * href="http://docs.aws.amazon.com/lightsail/2016-11-28/api-reference/API_GetRegions.html">get regions</a>
     * operation. Be sure to add the <code>include availability zones</code> parameter to your request.
     * </p>
     * 
     * @return The Availability Zone where you want to create your instances. Use the following formatting:
     *         <code>us-east-1a</code> (case sensitive). You can get a list of availability zones by using the <a
     *         href="http://docs.aws.amazon.com/lightsail/2016-11-28/api-reference/API_GetRegions.html">get regions</a>
     *         operation. Be sure to add the <code>include availability zones</code> parameter to your request.
     */
    public String availabilityZone() {
        return availabilityZone;
    }

    /**
     * <p>
     * The name of the instance snapshot on which you are basing your new instances. Use the get instance snapshots
     * operation to return information about your existing snapshots.
     * </p>
     * 
     * @return The name of the instance snapshot on which you are basing your new instances. Use the get instance
     *         snapshots operation to return information about your existing snapshots.
     */
    public String instanceSnapshotName() {
        return instanceSnapshotName;
    }

    /**
     * <p>
     * The bundle of specification information for your virtual private server (or <i>instance</i>), including the
     * pricing plan (e.g., <code>micro_1_0</code>).
     * </p>
     * 
     * @return The bundle of specification information for your virtual private server (or <i>instance</i>), including
     *         the pricing plan (e.g., <code>micro_1_0</code>).
     */
    public String bundleId() {
        return bundleId;
    }

    /**
     * <p>
     * You can create a launch script that configures a server with additional user data. For example,
     * <code>apt-get –y update</code>.
     * </p>
     * <note>
     * <p>
     * Depending on the machine image you choose, the command to get software on your instance varies. Amazon Linux and
     * CentOS use <code>yum</code>, Debian and Ubuntu use <code>apt-get</code>, and FreeBSD uses <code>pkg</code>. For a
     * complete list, see the <a
     * href="http://lightsail.aws.amazon.com/ls/docs/getting-started/articles/pre-installed-apps">Dev Guide</a>.
     * </p>
     * </note>
     * 
     * @return You can create a launch script that configures a server with additional user data. For example,
     *         <code>apt-get –y update</code>.</p> <note>
     *         <p>
     *         Depending on the machine image you choose, the command to get software on your instance varies. Amazon
     *         Linux and CentOS use <code>yum</code>, Debian and Ubuntu use <code>apt-get</code>, and FreeBSD uses
     *         <code>pkg</code>. For a complete list, see the <a
     *         href="http://lightsail.aws.amazon.com/ls/docs/getting-started/articles/pre-installed-apps">Dev Guide</a>.
     *         </p>
     */
    public String userData() {
        return userData;
    }

    /**
     * <p>
     * The name for your key pair.
     * </p>
     * 
     * @return The name for your key pair.
     */
    public String keyPairName() {
        return keyPairName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((instanceNames() == null) ? 0 : instanceNames().hashCode());
        hashCode = 31 * hashCode + ((availabilityZone() == null) ? 0 : availabilityZone().hashCode());
        hashCode = 31 * hashCode + ((instanceSnapshotName() == null) ? 0 : instanceSnapshotName().hashCode());
        hashCode = 31 * hashCode + ((bundleId() == null) ? 0 : bundleId().hashCode());
        hashCode = 31 * hashCode + ((userData() == null) ? 0 : userData().hashCode());
        hashCode = 31 * hashCode + ((keyPairName() == null) ? 0 : keyPairName().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateInstancesFromSnapshotRequest)) {
            return false;
        }
        CreateInstancesFromSnapshotRequest other = (CreateInstancesFromSnapshotRequest) obj;
        if (other.instanceNames() == null ^ this.instanceNames() == null) {
            return false;
        }
        if (other.instanceNames() != null && !other.instanceNames().equals(this.instanceNames())) {
            return false;
        }
        if (other.availabilityZone() == null ^ this.availabilityZone() == null) {
            return false;
        }
        if (other.availabilityZone() != null && !other.availabilityZone().equals(this.availabilityZone())) {
            return false;
        }
        if (other.instanceSnapshotName() == null ^ this.instanceSnapshotName() == null) {
            return false;
        }
        if (other.instanceSnapshotName() != null && !other.instanceSnapshotName().equals(this.instanceSnapshotName())) {
            return false;
        }
        if (other.bundleId() == null ^ this.bundleId() == null) {
            return false;
        }
        if (other.bundleId() != null && !other.bundleId().equals(this.bundleId())) {
            return false;
        }
        if (other.userData() == null ^ this.userData() == null) {
            return false;
        }
        if (other.userData() != null && !other.userData().equals(this.userData())) {
            return false;
        }
        if (other.keyPairName() == null ^ this.keyPairName() == null) {
            return false;
        }
        if (other.keyPairName() != null && !other.keyPairName().equals(this.keyPairName())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (instanceNames() != null) {
            sb.append("InstanceNames: ").append(instanceNames()).append(",");
        }
        if (availabilityZone() != null) {
            sb.append("AvailabilityZone: ").append(availabilityZone()).append(",");
        }
        if (instanceSnapshotName() != null) {
            sb.append("InstanceSnapshotName: ").append(instanceSnapshotName()).append(",");
        }
        if (bundleId() != null) {
            sb.append("BundleId: ").append(bundleId()).append(",");
        }
        if (userData() != null) {
            sb.append("UserData: ").append(userData()).append(",");
        }
        if (keyPairName() != null) {
            sb.append("KeyPairName: ").append(keyPairName()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, CreateInstancesFromSnapshotRequest> {
        /**
         * <p>
         * The names for your new instances.
         * </p>
         * 
         * @param instanceNames
         *        The names for your new instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceNames(Collection<String> instanceNames);

        /**
         * <p>
         * The names for your new instances.
         * </p>
         * 
         * @param instanceNames
         *        The names for your new instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceNames(String... instanceNames);

        /**
         * <p>
         * The Availability Zone where you want to create your instances. Use the following formatting:
         * <code>us-east-1a</code> (case sensitive). You can get a list of availability zones by using the <a
         * href="http://docs.aws.amazon.com/lightsail/2016-11-28/api-reference/API_GetRegions.html">get regions</a>
         * operation. Be sure to add the <code>include availability zones</code> parameter to your request.
         * </p>
         * 
         * @param availabilityZone
         *        The Availability Zone where you want to create your instances. Use the following formatting:
         *        <code>us-east-1a</code> (case sensitive). You can get a list of availability zones by using the <a
         *        href="http://docs.aws.amazon.com/lightsail/2016-11-28/api-reference/API_GetRegions.html">get
         *        regions</a> operation. Be sure to add the <code>include availability zones</code> parameter to your
         *        request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZone(String availabilityZone);

        /**
         * <p>
         * The name of the instance snapshot on which you are basing your new instances. Use the get instance snapshots
         * operation to return information about your existing snapshots.
         * </p>
         * 
         * @param instanceSnapshotName
         *        The name of the instance snapshot on which you are basing your new instances. Use the get instance
         *        snapshots operation to return information about your existing snapshots.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceSnapshotName(String instanceSnapshotName);

        /**
         * <p>
         * The bundle of specification information for your virtual private server (or <i>instance</i>), including the
         * pricing plan (e.g., <code>micro_1_0</code>).
         * </p>
         * 
         * @param bundleId
         *        The bundle of specification information for your virtual private server (or <i>instance</i>),
         *        including the pricing plan (e.g., <code>micro_1_0</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bundleId(String bundleId);

        /**
         * <p>
         * You can create a launch script that configures a server with additional user data. For example,
         * <code>apt-get –y update</code>.
         * </p>
         * <note>
         * <p>
         * Depending on the machine image you choose, the command to get software on your instance varies. Amazon Linux
         * and CentOS use <code>yum</code>, Debian and Ubuntu use <code>apt-get</code>, and FreeBSD uses
         * <code>pkg</code>. For a complete list, see the <a
         * href="http://lightsail.aws.amazon.com/ls/docs/getting-started/articles/pre-installed-apps">Dev Guide</a>.
         * </p>
         * </note>
         * 
         * @param userData
         *        You can create a launch script that configures a server with additional user data. For example,
         *        <code>apt-get –y update</code>.</p> <note>
         *        <p>
         *        Depending on the machine image you choose, the command to get software on your instance varies. Amazon
         *        Linux and CentOS use <code>yum</code>, Debian and Ubuntu use <code>apt-get</code>, and FreeBSD uses
         *        <code>pkg</code>. For a complete list, see the <a
         *        href="http://lightsail.aws.amazon.com/ls/docs/getting-started/articles/pre-installed-apps">Dev
         *        Guide</a>.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userData(String userData);

        /**
         * <p>
         * The name for your key pair.
         * </p>
         * 
         * @param keyPairName
         *        The name for your key pair.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyPairName(String keyPairName);
    }

    private static final class BuilderImpl implements Builder {
        private List<String> instanceNames;

        private String availabilityZone;

        private String instanceSnapshotName;

        private String bundleId;

        private String userData;

        private String keyPairName;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateInstancesFromSnapshotRequest model) {
            setInstanceNames(model.instanceNames);
            setAvailabilityZone(model.availabilityZone);
            setInstanceSnapshotName(model.instanceSnapshotName);
            setBundleId(model.bundleId);
            setUserData(model.userData);
            setKeyPairName(model.keyPairName);
        }

        public final Collection<String> getInstanceNames() {
            return instanceNames;
        }

        @Override
        public final Builder instanceNames(Collection<String> instanceNames) {
            this.instanceNames = StringListCopier.copy(instanceNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceNames(String... instanceNames) {
            instanceNames(Arrays.asList(instanceNames));
            return this;
        }

        public final void setInstanceNames(Collection<String> instanceNames) {
            this.instanceNames = StringListCopier.copy(instanceNames);
        }

        @SafeVarargs
        public final void setInstanceNames(String... instanceNames) {
            instanceNames(Arrays.asList(instanceNames));
        }

        public final String getAvailabilityZone() {
            return availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        public final String getInstanceSnapshotName() {
            return instanceSnapshotName;
        }

        @Override
        public final Builder instanceSnapshotName(String instanceSnapshotName) {
            this.instanceSnapshotName = instanceSnapshotName;
            return this;
        }

        public final void setInstanceSnapshotName(String instanceSnapshotName) {
            this.instanceSnapshotName = instanceSnapshotName;
        }

        public final String getBundleId() {
            return bundleId;
        }

        @Override
        public final Builder bundleId(String bundleId) {
            this.bundleId = bundleId;
            return this;
        }

        public final void setBundleId(String bundleId) {
            this.bundleId = bundleId;
        }

        public final String getUserData() {
            return userData;
        }

        @Override
        public final Builder userData(String userData) {
            this.userData = userData;
            return this;
        }

        public final void setUserData(String userData) {
            this.userData = userData;
        }

        public final String getKeyPairName() {
            return keyPairName;
        }

        @Override
        public final Builder keyPairName(String keyPairName) {
            this.keyPairName = keyPairName;
            return this;
        }

        public final void setKeyPairName(String keyPairName) {
            this.keyPairName = keyPairName;
        }

        @Override
        public CreateInstancesFromSnapshotRequest build() {
            return new CreateInstancesFromSnapshotRequest(this);
        }
    }
}
