/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class GetInstanceAccessDetailsRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<GetInstanceAccessDetailsRequest.Builder, GetInstanceAccessDetailsRequest> {
    private final String instanceName;

    private final String protocol;

    private GetInstanceAccessDetailsRequest(BuilderImpl builder) {
        this.instanceName = builder.instanceName;
        this.protocol = builder.protocol;
    }

    /**
     * <p>
     * The name of the instance to access.
     * </p>
     * 
     * @return The name of the instance to access.
     */
    public String instanceName() {
        return instanceName;
    }

    /**
     * <p>
     * The protocol to use to connect to your instance. Defaults to <code>ssh</code>.
     * </p>
     * 
     * @return The protocol to use to connect to your instance. Defaults to <code>ssh</code>.
     * @see InstanceAccessProtocol
     */
    public String protocol() {
        return protocol;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((instanceName() == null) ? 0 : instanceName().hashCode());
        hashCode = 31 * hashCode + ((protocol() == null) ? 0 : protocol().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetInstanceAccessDetailsRequest)) {
            return false;
        }
        GetInstanceAccessDetailsRequest other = (GetInstanceAccessDetailsRequest) obj;
        if (other.instanceName() == null ^ this.instanceName() == null) {
            return false;
        }
        if (other.instanceName() != null && !other.instanceName().equals(this.instanceName())) {
            return false;
        }
        if (other.protocol() == null ^ this.protocol() == null) {
            return false;
        }
        if (other.protocol() != null && !other.protocol().equals(this.protocol())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (instanceName() != null) {
            sb.append("InstanceName: ").append(instanceName()).append(",");
        }
        if (protocol() != null) {
            sb.append("Protocol: ").append(protocol()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, GetInstanceAccessDetailsRequest> {
        /**
         * <p>
         * The name of the instance to access.
         * </p>
         * 
         * @param instanceName
         *        The name of the instance to access.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceName(String instanceName);

        /**
         * <p>
         * The protocol to use to connect to your instance. Defaults to <code>ssh</code>.
         * </p>
         * 
         * @param protocol
         *        The protocol to use to connect to your instance. Defaults to <code>ssh</code>.
         * @see InstanceAccessProtocol
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InstanceAccessProtocol
         */
        Builder protocol(String protocol);

        /**
         * <p>
         * The protocol to use to connect to your instance. Defaults to <code>ssh</code>.
         * </p>
         * 
         * @param protocol
         *        The protocol to use to connect to your instance. Defaults to <code>ssh</code>.
         * @see InstanceAccessProtocol
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InstanceAccessProtocol
         */
        Builder protocol(InstanceAccessProtocol protocol);
    }

    private static final class BuilderImpl implements Builder {
        private String instanceName;

        private String protocol;

        private BuilderImpl() {
        }

        private BuilderImpl(GetInstanceAccessDetailsRequest model) {
            setInstanceName(model.instanceName);
            setProtocol(model.protocol);
        }

        public final String getInstanceName() {
            return instanceName;
        }

        @Override
        public final Builder instanceName(String instanceName) {
            this.instanceName = instanceName;
            return this;
        }

        public final void setInstanceName(String instanceName) {
            this.instanceName = instanceName;
        }

        public final String getProtocol() {
            return protocol;
        }

        @Override
        public final Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        @Override
        public final Builder protocol(InstanceAccessProtocol protocol) {
            this.protocol(protocol.toString());
            return this;
        }

        public final void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        public final void setProtocol(InstanceAccessProtocol protocol) {
            this.protocol(protocol.toString());
        }

        @Override
        public GetInstanceAccessDetailsRequest build() {
            return new GetInstanceAccessDetailsRequest(this);
        }
    }
}
