/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class GetRegionsRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<GetRegionsRequest.Builder, GetRegionsRequest> {
    private final Boolean includeAvailabilityZones;

    private GetRegionsRequest(BuilderImpl builder) {
        this.includeAvailabilityZones = builder.includeAvailabilityZones;
    }

    /**
     * <p>
     * A Boolean value indicating whether to also include Availability Zones in your get regions request. Availability
     * Zones are indicated with a letter: e.g., <code>us-east-1a</code>.
     * </p>
     * 
     * @return A Boolean value indicating whether to also include Availability Zones in your get regions request.
     *         Availability Zones are indicated with a letter: e.g., <code>us-east-1a</code>.
     */
    public Boolean includeAvailabilityZones() {
        return includeAvailabilityZones;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((includeAvailabilityZones() == null) ? 0 : includeAvailabilityZones().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetRegionsRequest)) {
            return false;
        }
        GetRegionsRequest other = (GetRegionsRequest) obj;
        if (other.includeAvailabilityZones() == null ^ this.includeAvailabilityZones() == null) {
            return false;
        }
        if (other.includeAvailabilityZones() != null && !other.includeAvailabilityZones().equals(this.includeAvailabilityZones())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (includeAvailabilityZones() != null) {
            sb.append("IncludeAvailabilityZones: ").append(includeAvailabilityZones()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, GetRegionsRequest> {
        /**
         * <p>
         * A Boolean value indicating whether to also include Availability Zones in your get regions request.
         * Availability Zones are indicated with a letter: e.g., <code>us-east-1a</code>.
         * </p>
         * 
         * @param includeAvailabilityZones
         *        A Boolean value indicating whether to also include Availability Zones in your get regions request.
         *        Availability Zones are indicated with a letter: e.g., <code>us-east-1a</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includeAvailabilityZones(Boolean includeAvailabilityZones);
    }

    private static final class BuilderImpl implements Builder {
        private Boolean includeAvailabilityZones;

        private BuilderImpl() {
        }

        private BuilderImpl(GetRegionsRequest model) {
            setIncludeAvailabilityZones(model.includeAvailabilityZones);
        }

        public final Boolean getIncludeAvailabilityZones() {
            return includeAvailabilityZones;
        }

        @Override
        public final Builder includeAvailabilityZones(Boolean includeAvailabilityZones) {
            this.includeAvailabilityZones = includeAvailabilityZones;
            return this;
        }

        public final void setIncludeAvailabilityZones(Boolean includeAvailabilityZones) {
            this.includeAvailabilityZones = includeAvailabilityZones;
        }

        @Override
        public GetRegionsRequest build() {
            return new GetRegionsRequest(this);
        }
    }
}
