/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class IsVpcPeeredResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<IsVpcPeeredResponse.Builder, IsVpcPeeredResponse> {
    private final Boolean isPeered;

    private IsVpcPeeredResponse(BuilderImpl builder) {
        this.isPeered = builder.isPeered;
    }

    /**
     * <p>
     * Returns <code>true</code> if the Lightsail VPC is peered; otherwise, <code>false</code>.
     * </p>
     * 
     * @return Returns <code>true</code> if the Lightsail VPC is peered; otherwise, <code>false</code>.
     */
    public Boolean isPeered() {
        return isPeered;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((isPeered() == null) ? 0 : isPeered().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IsVpcPeeredResponse)) {
            return false;
        }
        IsVpcPeeredResponse other = (IsVpcPeeredResponse) obj;
        if (other.isPeered() == null ^ this.isPeered() == null) {
            return false;
        }
        if (other.isPeered() != null && !other.isPeered().equals(this.isPeered())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (isPeered() != null) {
            sb.append("IsPeered: ").append(isPeered()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, IsVpcPeeredResponse> {
        /**
         * <p>
         * Returns <code>true</code> if the Lightsail VPC is peered; otherwise, <code>false</code>.
         * </p>
         * 
         * @param isPeered
         *        Returns <code>true</code> if the Lightsail VPC is peered; otherwise, <code>false</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isPeered(Boolean isPeered);
    }

    private static final class BuilderImpl implements Builder {
        private Boolean isPeered;

        private BuilderImpl() {
        }

        private BuilderImpl(IsVpcPeeredResponse model) {
            setIsPeered(model.isPeered);
        }

        public final Boolean getIsPeered() {
            return isPeered;
        }

        @Override
        public final Builder isPeered(Boolean isPeered) {
            this.isPeered = isPeered;
            return this;
        }

        public final void setIsPeered(Boolean isPeered) {
            this.isPeered = isPeered;
        }

        @Override
        public IsVpcPeeredResponse build() {
            return new IsVpcPeeredResponse(this);
        }
    }
}
