/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.lightsail.transform.ResourceLocationMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the resource location.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ResourceLocation implements StructuredPojo, ToCopyableBuilder<ResourceLocation.Builder, ResourceLocation> {
    private final String availabilityZone;

    private final String regionName;

    private ResourceLocation(BuilderImpl builder) {
        this.availabilityZone = builder.availabilityZone;
        this.regionName = builder.regionName;
    }

    /**
     * <p>
     * The Availability Zone. Follows the format <code>us-east-1a</code> (case-sensitive).
     * </p>
     * 
     * @return The Availability Zone. Follows the format <code>us-east-1a</code> (case-sensitive).
     */
    public String availabilityZone() {
        return availabilityZone;
    }

    /**
     * <p>
     * The AWS Region name.
     * </p>
     * 
     * @return The AWS Region name.
     * @see RegionName
     */
    public String regionName() {
        return regionName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((availabilityZone() == null) ? 0 : availabilityZone().hashCode());
        hashCode = 31 * hashCode + ((regionName() == null) ? 0 : regionName().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceLocation)) {
            return false;
        }
        ResourceLocation other = (ResourceLocation) obj;
        if (other.availabilityZone() == null ^ this.availabilityZone() == null) {
            return false;
        }
        if (other.availabilityZone() != null && !other.availabilityZone().equals(this.availabilityZone())) {
            return false;
        }
        if (other.regionName() == null ^ this.regionName() == null) {
            return false;
        }
        if (other.regionName() != null && !other.regionName().equals(this.regionName())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (availabilityZone() != null) {
            sb.append("AvailabilityZone: ").append(availabilityZone()).append(",");
        }
        if (regionName() != null) {
            sb.append("RegionName: ").append(regionName()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ResourceLocationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, ResourceLocation> {
        /**
         * <p>
         * The Availability Zone. Follows the format <code>us-east-1a</code> (case-sensitive).
         * </p>
         * 
         * @param availabilityZone
         *        The Availability Zone. Follows the format <code>us-east-1a</code> (case-sensitive).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZone(String availabilityZone);

        /**
         * <p>
         * The AWS Region name.
         * </p>
         * 
         * @param regionName
         *        The AWS Region name.
         * @see RegionName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RegionName
         */
        Builder regionName(String regionName);

        /**
         * <p>
         * The AWS Region name.
         * </p>
         * 
         * @param regionName
         *        The AWS Region name.
         * @see RegionName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RegionName
         */
        Builder regionName(RegionName regionName);
    }

    private static final class BuilderImpl implements Builder {
        private String availabilityZone;

        private String regionName;

        private BuilderImpl() {
        }

        private BuilderImpl(ResourceLocation model) {
            setAvailabilityZone(model.availabilityZone);
            setRegionName(model.regionName);
        }

        public final String getAvailabilityZone() {
            return availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        public final String getRegionName() {
            return regionName;
        }

        @Override
        public final Builder regionName(String regionName) {
            this.regionName = regionName;
            return this;
        }

        @Override
        public final Builder regionName(RegionName regionName) {
            this.regionName(regionName.toString());
            return this;
        }

        public final void setRegionName(String regionName) {
            this.regionName = regionName;
        }

        public final void setRegionName(RegionName regionName) {
            this.regionName(regionName.toString());
        }

        @Override
        public ResourceLocation build() {
            return new ResourceLocation(this);
        }
    }
}
