/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import java.time.Instant;
import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.lightsail.transform.StaticIpMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the static IP.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class StaticIp implements StructuredPojo, ToCopyableBuilder<StaticIp.Builder, StaticIp> {
    private final String name;

    private final String arn;

    private final String supportCode;

    private final Instant createdAt;

    private final ResourceLocation location;

    private final String resourceType;

    private final String ipAddress;

    private final String attachedTo;

    private final Boolean isAttached;

    private StaticIp(BuilderImpl builder) {
        this.name = builder.name;
        this.arn = builder.arn;
        this.supportCode = builder.supportCode;
        this.createdAt = builder.createdAt;
        this.location = builder.location;
        this.resourceType = builder.resourceType;
        this.ipAddress = builder.ipAddress;
        this.attachedTo = builder.attachedTo;
        this.isAttached = builder.isAttached;
    }

    /**
     * <p>
     * The name of the static IP (e.g., <code>StaticIP-Virginia-EXAMPLE</code>).
     * </p>
     * 
     * @return The name of the static IP (e.g., <code>StaticIP-Virginia-EXAMPLE</code>).
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the static IP (e.g.,
     * <code>arn:aws:lightsail:us-east-1:123456789101:StaticIp/9cbb4a9e-f8e3-4dfe-b57e-12345EXAMPLE</code>).
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the static IP (e.g.,
     *         <code>arn:aws:lightsail:us-east-1:123456789101:StaticIp/9cbb4a9e-f8e3-4dfe-b57e-12345EXAMPLE</code>).
     */
    public String arn() {
        return arn;
    }

    /**
     * <p>
     * The support code. Include this code in your email to support when you have questions about an instance or another
     * resource in Lightsail. This code enables our support team to look up your Lightsail information more easily.
     * </p>
     * 
     * @return The support code. Include this code in your email to support when you have questions about an instance or
     *         another resource in Lightsail. This code enables our support team to look up your Lightsail information
     *         more easily.
     */
    public String supportCode() {
        return supportCode;
    }

    /**
     * <p>
     * The timestamp when the static IP was created (e.g., <code>1479735304.222</code>).
     * </p>
     * 
     * @return The timestamp when the static IP was created (e.g., <code>1479735304.222</code>).
     */
    public Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The region and Availability Zone where the static IP was created.
     * </p>
     * 
     * @return The region and Availability Zone where the static IP was created.
     */
    public ResourceLocation location() {
        return location;
    }

    /**
     * <p>
     * The resource type (usually <code>StaticIp</code>).
     * </p>
     * 
     * @return The resource type (usually <code>StaticIp</code>).
     * @see ResourceType
     */
    public String resourceType() {
        return resourceType;
    }

    /**
     * <p>
     * The static IP address.
     * </p>
     * 
     * @return The static IP address.
     */
    public String ipAddress() {
        return ipAddress;
    }

    /**
     * <p>
     * The instance where the static IP is attached (e.g., <code>Amazon_Linux-1GB-Virginia-1</code>).
     * </p>
     * 
     * @return The instance where the static IP is attached (e.g., <code>Amazon_Linux-1GB-Virginia-1</code>).
     */
    public String attachedTo() {
        return attachedTo;
    }

    /**
     * <p>
     * A Boolean value indicating whether the static IP is attached.
     * </p>
     * 
     * @return A Boolean value indicating whether the static IP is attached.
     */
    public Boolean isAttached() {
        return isAttached;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((name() == null) ? 0 : name().hashCode());
        hashCode = 31 * hashCode + ((arn() == null) ? 0 : arn().hashCode());
        hashCode = 31 * hashCode + ((supportCode() == null) ? 0 : supportCode().hashCode());
        hashCode = 31 * hashCode + ((createdAt() == null) ? 0 : createdAt().hashCode());
        hashCode = 31 * hashCode + ((location() == null) ? 0 : location().hashCode());
        hashCode = 31 * hashCode + ((resourceType() == null) ? 0 : resourceType().hashCode());
        hashCode = 31 * hashCode + ((ipAddress() == null) ? 0 : ipAddress().hashCode());
        hashCode = 31 * hashCode + ((attachedTo() == null) ? 0 : attachedTo().hashCode());
        hashCode = 31 * hashCode + ((isAttached() == null) ? 0 : isAttached().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StaticIp)) {
            return false;
        }
        StaticIp other = (StaticIp) obj;
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        if (other.name() != null && !other.name().equals(this.name())) {
            return false;
        }
        if (other.arn() == null ^ this.arn() == null) {
            return false;
        }
        if (other.arn() != null && !other.arn().equals(this.arn())) {
            return false;
        }
        if (other.supportCode() == null ^ this.supportCode() == null) {
            return false;
        }
        if (other.supportCode() != null && !other.supportCode().equals(this.supportCode())) {
            return false;
        }
        if (other.createdAt() == null ^ this.createdAt() == null) {
            return false;
        }
        if (other.createdAt() != null && !other.createdAt().equals(this.createdAt())) {
            return false;
        }
        if (other.location() == null ^ this.location() == null) {
            return false;
        }
        if (other.location() != null && !other.location().equals(this.location())) {
            return false;
        }
        if (other.resourceType() == null ^ this.resourceType() == null) {
            return false;
        }
        if (other.resourceType() != null && !other.resourceType().equals(this.resourceType())) {
            return false;
        }
        if (other.ipAddress() == null ^ this.ipAddress() == null) {
            return false;
        }
        if (other.ipAddress() != null && !other.ipAddress().equals(this.ipAddress())) {
            return false;
        }
        if (other.attachedTo() == null ^ this.attachedTo() == null) {
            return false;
        }
        if (other.attachedTo() != null && !other.attachedTo().equals(this.attachedTo())) {
            return false;
        }
        if (other.isAttached() == null ^ this.isAttached() == null) {
            return false;
        }
        if (other.isAttached() != null && !other.isAttached().equals(this.isAttached())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (name() != null) {
            sb.append("Name: ").append(name()).append(",");
        }
        if (arn() != null) {
            sb.append("Arn: ").append(arn()).append(",");
        }
        if (supportCode() != null) {
            sb.append("SupportCode: ").append(supportCode()).append(",");
        }
        if (createdAt() != null) {
            sb.append("CreatedAt: ").append(createdAt()).append(",");
        }
        if (location() != null) {
            sb.append("Location: ").append(location()).append(",");
        }
        if (resourceType() != null) {
            sb.append("ResourceType: ").append(resourceType()).append(",");
        }
        if (ipAddress() != null) {
            sb.append("IpAddress: ").append(ipAddress()).append(",");
        }
        if (attachedTo() != null) {
            sb.append("AttachedTo: ").append(attachedTo()).append(",");
        }
        if (isAttached() != null) {
            sb.append("IsAttached: ").append(isAttached()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        StaticIpMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, StaticIp> {
        /**
         * <p>
         * The name of the static IP (e.g., <code>StaticIP-Virginia-EXAMPLE</code>).
         * </p>
         * 
         * @param name
         *        The name of the static IP (e.g., <code>StaticIP-Virginia-EXAMPLE</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the static IP (e.g.,
         * <code>arn:aws:lightsail:us-east-1:123456789101:StaticIp/9cbb4a9e-f8e3-4dfe-b57e-12345EXAMPLE</code>).
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the static IP (e.g.,
         *        <code>arn:aws:lightsail:us-east-1:123456789101:StaticIp/9cbb4a9e-f8e3-4dfe-b57e-12345EXAMPLE</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The support code. Include this code in your email to support when you have questions about an instance or
         * another resource in Lightsail. This code enables our support team to look up your Lightsail information more
         * easily.
         * </p>
         * 
         * @param supportCode
         *        The support code. Include this code in your email to support when you have questions about an instance
         *        or another resource in Lightsail. This code enables our support team to look up your Lightsail
         *        information more easily.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportCode(String supportCode);

        /**
         * <p>
         * The timestamp when the static IP was created (e.g., <code>1479735304.222</code>).
         * </p>
         * 
         * @param createdAt
         *        The timestamp when the static IP was created (e.g., <code>1479735304.222</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The region and Availability Zone where the static IP was created.
         * </p>
         * 
         * @param location
         *        The region and Availability Zone where the static IP was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder location(ResourceLocation location);

        /**
         * <p>
         * The resource type (usually <code>StaticIp</code>).
         * </p>
         * 
         * @param resourceType
         *        The resource type (usually <code>StaticIp</code>).
         * @see ResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceType
         */
        Builder resourceType(String resourceType);

        /**
         * <p>
         * The resource type (usually <code>StaticIp</code>).
         * </p>
         * 
         * @param resourceType
         *        The resource type (usually <code>StaticIp</code>).
         * @see ResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceType
         */
        Builder resourceType(ResourceType resourceType);

        /**
         * <p>
         * The static IP address.
         * </p>
         * 
         * @param ipAddress
         *        The static IP address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipAddress(String ipAddress);

        /**
         * <p>
         * The instance where the static IP is attached (e.g., <code>Amazon_Linux-1GB-Virginia-1</code>).
         * </p>
         * 
         * @param attachedTo
         *        The instance where the static IP is attached (e.g., <code>Amazon_Linux-1GB-Virginia-1</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attachedTo(String attachedTo);

        /**
         * <p>
         * A Boolean value indicating whether the static IP is attached.
         * </p>
         * 
         * @param isAttached
         *        A Boolean value indicating whether the static IP is attached.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isAttached(Boolean isAttached);
    }

    private static final class BuilderImpl implements Builder {
        private String name;

        private String arn;

        private String supportCode;

        private Instant createdAt;

        private ResourceLocation location;

        private String resourceType;

        private String ipAddress;

        private String attachedTo;

        private Boolean isAttached;

        private BuilderImpl() {
        }

        private BuilderImpl(StaticIp model) {
            setName(model.name);
            setArn(model.arn);
            setSupportCode(model.supportCode);
            setCreatedAt(model.createdAt);
            setLocation(model.location);
            setResourceType(model.resourceType);
            setIpAddress(model.ipAddress);
            setAttachedTo(model.attachedTo);
            setIsAttached(model.isAttached);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getArn() {
            return arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getSupportCode() {
            return supportCode;
        }

        @Override
        public final Builder supportCode(String supportCode) {
            this.supportCode = supportCode;
            return this;
        }

        public final void setSupportCode(String supportCode) {
            this.supportCode = supportCode;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        public final ResourceLocation getLocation() {
            return location;
        }

        @Override
        public final Builder location(ResourceLocation location) {
            this.location = location;
            return this;
        }

        public final void setLocation(ResourceLocation location) {
            this.location = location;
        }

        public final String getResourceType() {
            return resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public final Builder resourceType(ResourceType resourceType) {
            this.resourceType(resourceType.toString());
            return this;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        public final void setResourceType(ResourceType resourceType) {
            this.resourceType(resourceType.toString());
        }

        public final String getIpAddress() {
            return ipAddress;
        }

        @Override
        public final Builder ipAddress(String ipAddress) {
            this.ipAddress = ipAddress;
            return this;
        }

        public final void setIpAddress(String ipAddress) {
            this.ipAddress = ipAddress;
        }

        public final String getAttachedTo() {
            return attachedTo;
        }

        @Override
        public final Builder attachedTo(String attachedTo) {
            this.attachedTo = attachedTo;
            return this;
        }

        public final void setAttachedTo(String attachedTo) {
            this.attachedTo = attachedTo;
        }

        public final Boolean getIsAttached() {
            return isAttached;
        }

        @Override
        public final Builder isAttached(Boolean isAttached) {
            this.isAttached = isAttached;
            return this;
        }

        public final void setIsAttached(Boolean isAttached) {
            this.isAttached = isAttached;
        }

        @Override
        public StaticIp build() {
            return new StaticIp(this);
        }
    }
}
