/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.time.Instant;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.lightsail.model.ResourceLocation;
import software.amazon.awssdk.services.lightsail.model.ResourceType;
import software.amazon.awssdk.services.lightsail.transform.DiskMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Disk
implements StructuredPojo,
ToCopyableBuilder<Builder, Disk> {
    private final String name;
    private final String arn;
    private final String supportCode;
    private final Instant createdAt;
    private final ResourceLocation location;
    private final String resourceType;
    private final Integer sizeInGb;
    private final Integer gbInUse;
    private final Boolean isSystemDisk;
    private final Integer iops;
    private final String path;
    private final String attachedTo;
    private final Boolean isAttached;
    private final String attachmentState;

    private Disk(BuilderImpl builder) {
        this.name = builder.name;
        this.arn = builder.arn;
        this.supportCode = builder.supportCode;
        this.createdAt = builder.createdAt;
        this.location = builder.location;
        this.resourceType = builder.resourceType;
        this.sizeInGb = builder.sizeInGb;
        this.gbInUse = builder.gbInUse;
        this.isSystemDisk = builder.isSystemDisk;
        this.iops = builder.iops;
        this.path = builder.path;
        this.attachedTo = builder.attachedTo;
        this.isAttached = builder.isAttached;
        this.attachmentState = builder.attachmentState;
    }

    public String name() {
        return this.name;
    }

    public String arn() {
        return this.arn;
    }

    public String supportCode() {
        return this.supportCode;
    }

    public Instant createdAt() {
        return this.createdAt;
    }

    public ResourceLocation location() {
        return this.location;
    }

    public String resourceType() {
        return this.resourceType;
    }

    public Integer sizeInGb() {
        return this.sizeInGb;
    }

    public Integer gbInUse() {
        return this.gbInUse;
    }

    public Boolean isSystemDisk() {
        return this.isSystemDisk;
    }

    public Integer iops() {
        return this.iops;
    }

    public String path() {
        return this.path;
    }

    public String attachedTo() {
        return this.attachedTo;
    }

    public Boolean isAttached() {
        return this.isAttached;
    }

    public String attachmentState() {
        return this.attachmentState;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.name() == null ? 0 : this.name().hashCode());
        hashCode = 31 * hashCode + (this.arn() == null ? 0 : this.arn().hashCode());
        hashCode = 31 * hashCode + (this.supportCode() == null ? 0 : this.supportCode().hashCode());
        hashCode = 31 * hashCode + (this.createdAt() == null ? 0 : this.createdAt().hashCode());
        hashCode = 31 * hashCode + (this.location() == null ? 0 : this.location().hashCode());
        hashCode = 31 * hashCode + (this.resourceType() == null ? 0 : this.resourceType().hashCode());
        hashCode = 31 * hashCode + (this.sizeInGb() == null ? 0 : this.sizeInGb().hashCode());
        hashCode = 31 * hashCode + (this.gbInUse() == null ? 0 : this.gbInUse().hashCode());
        hashCode = 31 * hashCode + (this.isSystemDisk() == null ? 0 : this.isSystemDisk().hashCode());
        hashCode = 31 * hashCode + (this.iops() == null ? 0 : this.iops().hashCode());
        hashCode = 31 * hashCode + (this.path() == null ? 0 : this.path().hashCode());
        hashCode = 31 * hashCode + (this.attachedTo() == null ? 0 : this.attachedTo().hashCode());
        hashCode = 31 * hashCode + (this.isAttached() == null ? 0 : this.isAttached().hashCode());
        hashCode = 31 * hashCode + (this.attachmentState() == null ? 0 : this.attachmentState().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Disk)) {
            return false;
        }
        Disk other = (Disk)obj;
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        if (other.name() != null && !other.name().equals(this.name())) {
            return false;
        }
        if (other.arn() == null ^ this.arn() == null) {
            return false;
        }
        if (other.arn() != null && !other.arn().equals(this.arn())) {
            return false;
        }
        if (other.supportCode() == null ^ this.supportCode() == null) {
            return false;
        }
        if (other.supportCode() != null && !other.supportCode().equals(this.supportCode())) {
            return false;
        }
        if (other.createdAt() == null ^ this.createdAt() == null) {
            return false;
        }
        if (other.createdAt() != null && !other.createdAt().equals(this.createdAt())) {
            return false;
        }
        if (other.location() == null ^ this.location() == null) {
            return false;
        }
        if (other.location() != null && !other.location().equals(this.location())) {
            return false;
        }
        if (other.resourceType() == null ^ this.resourceType() == null) {
            return false;
        }
        if (other.resourceType() != null && !other.resourceType().equals(this.resourceType())) {
            return false;
        }
        if (other.sizeInGb() == null ^ this.sizeInGb() == null) {
            return false;
        }
        if (other.sizeInGb() != null && !other.sizeInGb().equals(this.sizeInGb())) {
            return false;
        }
        if (other.gbInUse() == null ^ this.gbInUse() == null) {
            return false;
        }
        if (other.gbInUse() != null && !other.gbInUse().equals(this.gbInUse())) {
            return false;
        }
        if (other.isSystemDisk() == null ^ this.isSystemDisk() == null) {
            return false;
        }
        if (other.isSystemDisk() != null && !other.isSystemDisk().equals(this.isSystemDisk())) {
            return false;
        }
        if (other.iops() == null ^ this.iops() == null) {
            return false;
        }
        if (other.iops() != null && !other.iops().equals(this.iops())) {
            return false;
        }
        if (other.path() == null ^ this.path() == null) {
            return false;
        }
        if (other.path() != null && !other.path().equals(this.path())) {
            return false;
        }
        if (other.attachedTo() == null ^ this.attachedTo() == null) {
            return false;
        }
        if (other.attachedTo() != null && !other.attachedTo().equals(this.attachedTo())) {
            return false;
        }
        if (other.isAttached() == null ^ this.isAttached() == null) {
            return false;
        }
        if (other.isAttached() != null && !other.isAttached().equals(this.isAttached())) {
            return false;
        }
        if (other.attachmentState() == null ^ this.attachmentState() == null) {
            return false;
        }
        return other.attachmentState() == null || other.attachmentState().equals(this.attachmentState());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.name() != null) {
            sb.append("Name: ").append(this.name()).append(",");
        }
        if (this.arn() != null) {
            sb.append("Arn: ").append(this.arn()).append(",");
        }
        if (this.supportCode() != null) {
            sb.append("SupportCode: ").append(this.supportCode()).append(",");
        }
        if (this.createdAt() != null) {
            sb.append("CreatedAt: ").append(this.createdAt()).append(",");
        }
        if (this.location() != null) {
            sb.append("Location: ").append(this.location()).append(",");
        }
        if (this.resourceType() != null) {
            sb.append("ResourceType: ").append(this.resourceType()).append(",");
        }
        if (this.sizeInGb() != null) {
            sb.append("SizeInGb: ").append(this.sizeInGb()).append(",");
        }
        if (this.gbInUse() != null) {
            sb.append("GbInUse: ").append(this.gbInUse()).append(",");
        }
        if (this.isSystemDisk() != null) {
            sb.append("IsSystemDisk: ").append(this.isSystemDisk()).append(",");
        }
        if (this.iops() != null) {
            sb.append("Iops: ").append(this.iops()).append(",");
        }
        if (this.path() != null) {
            sb.append("Path: ").append(this.path()).append(",");
        }
        if (this.attachedTo() != null) {
            sb.append("AttachedTo: ").append(this.attachedTo()).append(",");
        }
        if (this.isAttached() != null) {
            sb.append("IsAttached: ").append(this.isAttached()).append(",");
        }
        if (this.attachmentState() != null) {
            sb.append("AttachmentState: ").append(this.attachmentState()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DiskMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String name;
        private String arn;
        private String supportCode;
        private Instant createdAt;
        private ResourceLocation location;
        private String resourceType;
        private Integer sizeInGb;
        private Integer gbInUse;
        private Boolean isSystemDisk;
        private Integer iops;
        private String path;
        private String attachedTo;
        private Boolean isAttached;
        private String attachmentState;

        private BuilderImpl() {
        }

        private BuilderImpl(Disk model) {
            this.setName(model.name);
            this.setArn(model.arn);
            this.setSupportCode(model.supportCode);
            this.setCreatedAt(model.createdAt);
            this.setLocation(model.location);
            this.setResourceType(model.resourceType);
            this.setSizeInGb(model.sizeInGb);
            this.setGbInUse(model.gbInUse);
            this.setIsSystemDisk(model.isSystemDisk);
            this.setIops(model.iops);
            this.setPath(model.path);
            this.setAttachedTo(model.attachedTo);
            this.setIsAttached(model.isAttached);
            this.setAttachmentState(model.attachmentState);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getArn() {
            return this.arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getSupportCode() {
            return this.supportCode;
        }

        @Override
        public final Builder supportCode(String supportCode) {
            this.supportCode = supportCode;
            return this;
        }

        public final void setSupportCode(String supportCode) {
            this.supportCode = supportCode;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        public final ResourceLocation getLocation() {
            return this.location;
        }

        @Override
        public final Builder location(ResourceLocation location) {
            this.location = location;
            return this;
        }

        public final void setLocation(ResourceLocation location) {
            this.location = location;
        }

        public final String getResourceType() {
            return this.resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public final Builder resourceType(ResourceType resourceType) {
            this.resourceType(resourceType.toString());
            return this;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        public final void setResourceType(ResourceType resourceType) {
            this.resourceType(resourceType.toString());
        }

        public final Integer getSizeInGb() {
            return this.sizeInGb;
        }

        @Override
        public final Builder sizeInGb(Integer sizeInGb) {
            this.sizeInGb = sizeInGb;
            return this;
        }

        public final void setSizeInGb(Integer sizeInGb) {
            this.sizeInGb = sizeInGb;
        }

        public final Integer getGbInUse() {
            return this.gbInUse;
        }

        @Override
        public final Builder gbInUse(Integer gbInUse) {
            this.gbInUse = gbInUse;
            return this;
        }

        public final void setGbInUse(Integer gbInUse) {
            this.gbInUse = gbInUse;
        }

        public final Boolean getIsSystemDisk() {
            return this.isSystemDisk;
        }

        @Override
        public final Builder isSystemDisk(Boolean isSystemDisk) {
            this.isSystemDisk = isSystemDisk;
            return this;
        }

        public final void setIsSystemDisk(Boolean isSystemDisk) {
            this.isSystemDisk = isSystemDisk;
        }

        public final Integer getIops() {
            return this.iops;
        }

        @Override
        public final Builder iops(Integer iops) {
            this.iops = iops;
            return this;
        }

        public final void setIops(Integer iops) {
            this.iops = iops;
        }

        public final String getPath() {
            return this.path;
        }

        @Override
        public final Builder path(String path) {
            this.path = path;
            return this;
        }

        public final void setPath(String path) {
            this.path = path;
        }

        public final String getAttachedTo() {
            return this.attachedTo;
        }

        @Override
        public final Builder attachedTo(String attachedTo) {
            this.attachedTo = attachedTo;
            return this;
        }

        public final void setAttachedTo(String attachedTo) {
            this.attachedTo = attachedTo;
        }

        public final Boolean getIsAttached() {
            return this.isAttached;
        }

        @Override
        public final Builder isAttached(Boolean isAttached) {
            this.isAttached = isAttached;
            return this;
        }

        public final void setIsAttached(Boolean isAttached) {
            this.isAttached = isAttached;
        }

        public final String getAttachmentState() {
            return this.attachmentState;
        }

        @Override
        public final Builder attachmentState(String attachmentState) {
            this.attachmentState = attachmentState;
            return this;
        }

        public final void setAttachmentState(String attachmentState) {
            this.attachmentState = attachmentState;
        }

        public Disk build() {
            return new Disk(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Disk> {
        public Builder name(String var1);

        public Builder arn(String var1);

        public Builder supportCode(String var1);

        public Builder createdAt(Instant var1);

        public Builder location(ResourceLocation var1);

        public Builder resourceType(String var1);

        public Builder resourceType(ResourceType var1);

        public Builder sizeInGb(Integer var1);

        public Builder gbInUse(Integer var1);

        public Builder isSystemDisk(Boolean var1);

        public Builder iops(Integer var1);

        public Builder path(String var1);

        public Builder attachedTo(String var1);

        public Builder isAttached(Boolean var1);

        public Builder attachmentState(String var1);
    }
}

