/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.lightsail.model.InstancePortState;
import software.amazon.awssdk.services.lightsail.model.InstancePortStateListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetInstancePortStatesResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, GetInstancePortStatesResponse> {
    private final List<InstancePortState> portStates;

    private GetInstancePortStatesResponse(BuilderImpl builder) {
        this.portStates = builder.portStates;
    }

    public List<InstancePortState> portStates() {
        return this.portStates;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.portStates() == null ? 0 : this.portStates().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetInstancePortStatesResponse)) {
            return false;
        }
        GetInstancePortStatesResponse other = (GetInstancePortStatesResponse)((Object)obj);
        if (other.portStates() == null ^ this.portStates() == null) {
            return false;
        }
        return other.portStates() == null || other.portStates().equals(this.portStates());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.portStates() != null) {
            sb.append("PortStates: ").append(this.portStates()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<InstancePortState> portStates;

        private BuilderImpl() {
        }

        private BuilderImpl(GetInstancePortStatesResponse model) {
            this.setPortStates(model.portStates);
        }

        public final Collection<InstancePortState> getPortStates() {
            return this.portStates;
        }

        @Override
        public final Builder portStates(Collection<InstancePortState> portStates) {
            this.portStates = InstancePortStateListCopier.copy(portStates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder portStates(InstancePortState ... portStates) {
            this.portStates(Arrays.asList(portStates));
            return this;
        }

        public final void setPortStates(Collection<InstancePortState> portStates) {
            this.portStates = InstancePortStateListCopier.copy(portStates);
        }

        @SafeVarargs
        public final void setPortStates(InstancePortState ... portStates) {
            this.portStates(Arrays.asList(portStates));
        }

        public GetInstancePortStatesResponse build() {
            return new GetInstancePortStatesResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, GetInstancePortStatesResponse> {
        public Builder portStates(Collection<InstancePortState> var1);

        public Builder portStates(InstancePortState ... var1);
    }
}

