/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.lightsail.model.AccessDirection;
import software.amazon.awssdk.services.lightsail.model.NetworkProtocol;
import software.amazon.awssdk.services.lightsail.model.PortAccessType;
import software.amazon.awssdk.services.lightsail.transform.InstancePortInfoMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class InstancePortInfo
implements StructuredPojo,
ToCopyableBuilder<Builder, InstancePortInfo> {
    private final Integer fromPort;
    private final Integer toPort;
    private final String protocol;
    private final String accessFrom;
    private final String accessType;
    private final String commonName;
    private final String accessDirection;

    private InstancePortInfo(BuilderImpl builder) {
        this.fromPort = builder.fromPort;
        this.toPort = builder.toPort;
        this.protocol = builder.protocol;
        this.accessFrom = builder.accessFrom;
        this.accessType = builder.accessType;
        this.commonName = builder.commonName;
        this.accessDirection = builder.accessDirection;
    }

    public Integer fromPort() {
        return this.fromPort;
    }

    public Integer toPort() {
        return this.toPort;
    }

    public String protocol() {
        return this.protocol;
    }

    public String accessFrom() {
        return this.accessFrom;
    }

    public String accessType() {
        return this.accessType;
    }

    public String commonName() {
        return this.commonName;
    }

    public String accessDirection() {
        return this.accessDirection;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.fromPort() == null ? 0 : this.fromPort().hashCode());
        hashCode = 31 * hashCode + (this.toPort() == null ? 0 : this.toPort().hashCode());
        hashCode = 31 * hashCode + (this.protocol() == null ? 0 : this.protocol().hashCode());
        hashCode = 31 * hashCode + (this.accessFrom() == null ? 0 : this.accessFrom().hashCode());
        hashCode = 31 * hashCode + (this.accessType() == null ? 0 : this.accessType().hashCode());
        hashCode = 31 * hashCode + (this.commonName() == null ? 0 : this.commonName().hashCode());
        hashCode = 31 * hashCode + (this.accessDirection() == null ? 0 : this.accessDirection().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstancePortInfo)) {
            return false;
        }
        InstancePortInfo other = (InstancePortInfo)obj;
        if (other.fromPort() == null ^ this.fromPort() == null) {
            return false;
        }
        if (other.fromPort() != null && !other.fromPort().equals(this.fromPort())) {
            return false;
        }
        if (other.toPort() == null ^ this.toPort() == null) {
            return false;
        }
        if (other.toPort() != null && !other.toPort().equals(this.toPort())) {
            return false;
        }
        if (other.protocol() == null ^ this.protocol() == null) {
            return false;
        }
        if (other.protocol() != null && !other.protocol().equals(this.protocol())) {
            return false;
        }
        if (other.accessFrom() == null ^ this.accessFrom() == null) {
            return false;
        }
        if (other.accessFrom() != null && !other.accessFrom().equals(this.accessFrom())) {
            return false;
        }
        if (other.accessType() == null ^ this.accessType() == null) {
            return false;
        }
        if (other.accessType() != null && !other.accessType().equals(this.accessType())) {
            return false;
        }
        if (other.commonName() == null ^ this.commonName() == null) {
            return false;
        }
        if (other.commonName() != null && !other.commonName().equals(this.commonName())) {
            return false;
        }
        if (other.accessDirection() == null ^ this.accessDirection() == null) {
            return false;
        }
        return other.accessDirection() == null || other.accessDirection().equals(this.accessDirection());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.fromPort() != null) {
            sb.append("FromPort: ").append(this.fromPort()).append(",");
        }
        if (this.toPort() != null) {
            sb.append("ToPort: ").append(this.toPort()).append(",");
        }
        if (this.protocol() != null) {
            sb.append("Protocol: ").append(this.protocol()).append(",");
        }
        if (this.accessFrom() != null) {
            sb.append("AccessFrom: ").append(this.accessFrom()).append(",");
        }
        if (this.accessType() != null) {
            sb.append("AccessType: ").append(this.accessType()).append(",");
        }
        if (this.commonName() != null) {
            sb.append("CommonName: ").append(this.commonName()).append(",");
        }
        if (this.accessDirection() != null) {
            sb.append("AccessDirection: ").append(this.accessDirection()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        InstancePortInfoMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private Integer fromPort;
        private Integer toPort;
        private String protocol;
        private String accessFrom;
        private String accessType;
        private String commonName;
        private String accessDirection;

        private BuilderImpl() {
        }

        private BuilderImpl(InstancePortInfo model) {
            this.setFromPort(model.fromPort);
            this.setToPort(model.toPort);
            this.setProtocol(model.protocol);
            this.setAccessFrom(model.accessFrom);
            this.setAccessType(model.accessType);
            this.setCommonName(model.commonName);
            this.setAccessDirection(model.accessDirection);
        }

        public final Integer getFromPort() {
            return this.fromPort;
        }

        @Override
        public final Builder fromPort(Integer fromPort) {
            this.fromPort = fromPort;
            return this;
        }

        public final void setFromPort(Integer fromPort) {
            this.fromPort = fromPort;
        }

        public final Integer getToPort() {
            return this.toPort;
        }

        @Override
        public final Builder toPort(Integer toPort) {
            this.toPort = toPort;
            return this;
        }

        public final void setToPort(Integer toPort) {
            this.toPort = toPort;
        }

        public final String getProtocol() {
            return this.protocol;
        }

        @Override
        public final Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        @Override
        public final Builder protocol(NetworkProtocol protocol) {
            this.protocol(protocol.toString());
            return this;
        }

        public final void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        public final void setProtocol(NetworkProtocol protocol) {
            this.protocol(protocol.toString());
        }

        public final String getAccessFrom() {
            return this.accessFrom;
        }

        @Override
        public final Builder accessFrom(String accessFrom) {
            this.accessFrom = accessFrom;
            return this;
        }

        public final void setAccessFrom(String accessFrom) {
            this.accessFrom = accessFrom;
        }

        public final String getAccessType() {
            return this.accessType;
        }

        @Override
        public final Builder accessType(String accessType) {
            this.accessType = accessType;
            return this;
        }

        @Override
        public final Builder accessType(PortAccessType accessType) {
            this.accessType(accessType.toString());
            return this;
        }

        public final void setAccessType(String accessType) {
            this.accessType = accessType;
        }

        public final void setAccessType(PortAccessType accessType) {
            this.accessType(accessType.toString());
        }

        public final String getCommonName() {
            return this.commonName;
        }

        @Override
        public final Builder commonName(String commonName) {
            this.commonName = commonName;
            return this;
        }

        public final void setCommonName(String commonName) {
            this.commonName = commonName;
        }

        public final String getAccessDirection() {
            return this.accessDirection;
        }

        @Override
        public final Builder accessDirection(String accessDirection) {
            this.accessDirection = accessDirection;
            return this;
        }

        @Override
        public final Builder accessDirection(AccessDirection accessDirection) {
            this.accessDirection(accessDirection.toString());
            return this;
        }

        public final void setAccessDirection(String accessDirection) {
            this.accessDirection = accessDirection;
        }

        public final void setAccessDirection(AccessDirection accessDirection) {
            this.accessDirection(accessDirection.toString());
        }

        public InstancePortInfo build() {
            return new InstancePortInfo(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, InstancePortInfo> {
        public Builder fromPort(Integer var1);

        public Builder toPort(Integer var1);

        public Builder protocol(String var1);

        public Builder protocol(NetworkProtocol var1);

        public Builder accessFrom(String var1);

        public Builder accessType(String var1);

        public Builder accessType(PortAccessType var1);

        public Builder commonName(String var1);

        public Builder accessDirection(String var1);

        public Builder accessDirection(AccessDirection var1);
    }
}

