/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.time.Instant;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.lightsail.model.InstanceAccessProtocol;
import software.amazon.awssdk.services.lightsail.transform.InstanceAccessDetailsMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class InstanceAccessDetails
implements StructuredPojo,
ToCopyableBuilder<Builder, InstanceAccessDetails> {
    private final String certKey;
    private final Instant expiresAt;
    private final String ipAddress;
    private final String password;
    private final String privateKey;
    private final String protocol;
    private final String instanceName;
    private final String username;

    private InstanceAccessDetails(BuilderImpl builder) {
        this.certKey = builder.certKey;
        this.expiresAt = builder.expiresAt;
        this.ipAddress = builder.ipAddress;
        this.password = builder.password;
        this.privateKey = builder.privateKey;
        this.protocol = builder.protocol;
        this.instanceName = builder.instanceName;
        this.username = builder.username;
    }

    public String certKey() {
        return this.certKey;
    }

    public Instant expiresAt() {
        return this.expiresAt;
    }

    public String ipAddress() {
        return this.ipAddress;
    }

    public String password() {
        return this.password;
    }

    public String privateKey() {
        return this.privateKey;
    }

    public String protocol() {
        return this.protocol;
    }

    public String instanceName() {
        return this.instanceName;
    }

    public String username() {
        return this.username;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.certKey() == null ? 0 : this.certKey().hashCode());
        hashCode = 31 * hashCode + (this.expiresAt() == null ? 0 : this.expiresAt().hashCode());
        hashCode = 31 * hashCode + (this.ipAddress() == null ? 0 : this.ipAddress().hashCode());
        hashCode = 31 * hashCode + (this.password() == null ? 0 : this.password().hashCode());
        hashCode = 31 * hashCode + (this.privateKey() == null ? 0 : this.privateKey().hashCode());
        hashCode = 31 * hashCode + (this.protocol() == null ? 0 : this.protocol().hashCode());
        hashCode = 31 * hashCode + (this.instanceName() == null ? 0 : this.instanceName().hashCode());
        hashCode = 31 * hashCode + (this.username() == null ? 0 : this.username().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceAccessDetails)) {
            return false;
        }
        InstanceAccessDetails other = (InstanceAccessDetails)obj;
        if (other.certKey() == null ^ this.certKey() == null) {
            return false;
        }
        if (other.certKey() != null && !other.certKey().equals(this.certKey())) {
            return false;
        }
        if (other.expiresAt() == null ^ this.expiresAt() == null) {
            return false;
        }
        if (other.expiresAt() != null && !other.expiresAt().equals(this.expiresAt())) {
            return false;
        }
        if (other.ipAddress() == null ^ this.ipAddress() == null) {
            return false;
        }
        if (other.ipAddress() != null && !other.ipAddress().equals(this.ipAddress())) {
            return false;
        }
        if (other.password() == null ^ this.password() == null) {
            return false;
        }
        if (other.password() != null && !other.password().equals(this.password())) {
            return false;
        }
        if (other.privateKey() == null ^ this.privateKey() == null) {
            return false;
        }
        if (other.privateKey() != null && !other.privateKey().equals(this.privateKey())) {
            return false;
        }
        if (other.protocol() == null ^ this.protocol() == null) {
            return false;
        }
        if (other.protocol() != null && !other.protocol().equals(this.protocol())) {
            return false;
        }
        if (other.instanceName() == null ^ this.instanceName() == null) {
            return false;
        }
        if (other.instanceName() != null && !other.instanceName().equals(this.instanceName())) {
            return false;
        }
        if (other.username() == null ^ this.username() == null) {
            return false;
        }
        return other.username() == null || other.username().equals(this.username());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.certKey() != null) {
            sb.append("CertKey: ").append(this.certKey()).append(",");
        }
        if (this.expiresAt() != null) {
            sb.append("ExpiresAt: ").append(this.expiresAt()).append(",");
        }
        if (this.ipAddress() != null) {
            sb.append("IpAddress: ").append(this.ipAddress()).append(",");
        }
        if (this.password() != null) {
            sb.append("Password: ").append(this.password()).append(",");
        }
        if (this.privateKey() != null) {
            sb.append("PrivateKey: ").append(this.privateKey()).append(",");
        }
        if (this.protocol() != null) {
            sb.append("Protocol: ").append(this.protocol()).append(",");
        }
        if (this.instanceName() != null) {
            sb.append("InstanceName: ").append(this.instanceName()).append(",");
        }
        if (this.username() != null) {
            sb.append("Username: ").append(this.username()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        InstanceAccessDetailsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String certKey;
        private Instant expiresAt;
        private String ipAddress;
        private String password;
        private String privateKey;
        private String protocol;
        private String instanceName;
        private String username;

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceAccessDetails model) {
            this.setCertKey(model.certKey);
            this.setExpiresAt(model.expiresAt);
            this.setIpAddress(model.ipAddress);
            this.setPassword(model.password);
            this.setPrivateKey(model.privateKey);
            this.setProtocol(model.protocol);
            this.setInstanceName(model.instanceName);
            this.setUsername(model.username);
        }

        public final String getCertKey() {
            return this.certKey;
        }

        @Override
        public final Builder certKey(String certKey) {
            this.certKey = certKey;
            return this;
        }

        public final void setCertKey(String certKey) {
            this.certKey = certKey;
        }

        public final Instant getExpiresAt() {
            return this.expiresAt;
        }

        @Override
        public final Builder expiresAt(Instant expiresAt) {
            this.expiresAt = expiresAt;
            return this;
        }

        public final void setExpiresAt(Instant expiresAt) {
            this.expiresAt = expiresAt;
        }

        public final String getIpAddress() {
            return this.ipAddress;
        }

        @Override
        public final Builder ipAddress(String ipAddress) {
            this.ipAddress = ipAddress;
            return this;
        }

        public final void setIpAddress(String ipAddress) {
            this.ipAddress = ipAddress;
        }

        public final String getPassword() {
            return this.password;
        }

        @Override
        public final Builder password(String password) {
            this.password = password;
            return this;
        }

        public final void setPassword(String password) {
            this.password = password;
        }

        public final String getPrivateKey() {
            return this.privateKey;
        }

        @Override
        public final Builder privateKey(String privateKey) {
            this.privateKey = privateKey;
            return this;
        }

        public final void setPrivateKey(String privateKey) {
            this.privateKey = privateKey;
        }

        public final String getProtocol() {
            return this.protocol;
        }

        @Override
        public final Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        @Override
        public final Builder protocol(InstanceAccessProtocol protocol) {
            this.protocol(protocol.toString());
            return this;
        }

        public final void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        public final String getInstanceName() {
            return this.instanceName;
        }

        @Override
        public final Builder instanceName(String instanceName) {
            this.instanceName = instanceName;
            return this;
        }

        public final void setInstanceName(String instanceName) {
            this.instanceName = instanceName;
        }

        public final String getUsername() {
            return this.username;
        }

        @Override
        public final Builder username(String username) {
            this.username = username;
            return this;
        }

        public final void setUsername(String username) {
            this.username = username;
        }

        public InstanceAccessDetails build() {
            return new InstanceAccessDetails(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, InstanceAccessDetails> {
        public Builder certKey(String var1);

        public Builder expiresAt(Instant var1);

        public Builder ipAddress(String var1);

        public Builder password(String var1);

        public Builder privateKey(String var1);

        public Builder protocol(String var1);

        public Builder protocol(InstanceAccessProtocol var1);

        public Builder instanceName(String var1);

        public Builder username(String var1);
    }
}

