/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.time.Instant;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.lightsail.model.OperationStatus;
import software.amazon.awssdk.services.lightsail.model.OperationType;
import software.amazon.awssdk.services.lightsail.model.ResourceLocation;
import software.amazon.awssdk.services.lightsail.model.ResourceType;
import software.amazon.awssdk.services.lightsail.transform.OperationMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Operation
implements StructuredPojo,
ToCopyableBuilder<Builder, Operation> {
    private final String id;
    private final String resourceName;
    private final String resourceType;
    private final Instant createdAt;
    private final ResourceLocation location;
    private final Boolean isTerminal;
    private final String operationDetails;
    private final String operationType;
    private final String status;
    private final Instant statusChangedAt;
    private final String errorCode;
    private final String errorDetails;

    private Operation(BuilderImpl builder) {
        this.id = builder.id;
        this.resourceName = builder.resourceName;
        this.resourceType = builder.resourceType;
        this.createdAt = builder.createdAt;
        this.location = builder.location;
        this.isTerminal = builder.isTerminal;
        this.operationDetails = builder.operationDetails;
        this.operationType = builder.operationType;
        this.status = builder.status;
        this.statusChangedAt = builder.statusChangedAt;
        this.errorCode = builder.errorCode;
        this.errorDetails = builder.errorDetails;
    }

    public String id() {
        return this.id;
    }

    public String resourceName() {
        return this.resourceName;
    }

    public String resourceType() {
        return this.resourceType;
    }

    public Instant createdAt() {
        return this.createdAt;
    }

    public ResourceLocation location() {
        return this.location;
    }

    public Boolean isTerminal() {
        return this.isTerminal;
    }

    public String operationDetails() {
        return this.operationDetails;
    }

    public String operationType() {
        return this.operationType;
    }

    public String status() {
        return this.status;
    }

    public Instant statusChangedAt() {
        return this.statusChangedAt;
    }

    public String errorCode() {
        return this.errorCode;
    }

    public String errorDetails() {
        return this.errorDetails;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.id() == null ? 0 : this.id().hashCode());
        hashCode = 31 * hashCode + (this.resourceName() == null ? 0 : this.resourceName().hashCode());
        hashCode = 31 * hashCode + (this.resourceType() == null ? 0 : this.resourceType().hashCode());
        hashCode = 31 * hashCode + (this.createdAt() == null ? 0 : this.createdAt().hashCode());
        hashCode = 31 * hashCode + (this.location() == null ? 0 : this.location().hashCode());
        hashCode = 31 * hashCode + (this.isTerminal() == null ? 0 : this.isTerminal().hashCode());
        hashCode = 31 * hashCode + (this.operationDetails() == null ? 0 : this.operationDetails().hashCode());
        hashCode = 31 * hashCode + (this.operationType() == null ? 0 : this.operationType().hashCode());
        hashCode = 31 * hashCode + (this.status() == null ? 0 : this.status().hashCode());
        hashCode = 31 * hashCode + (this.statusChangedAt() == null ? 0 : this.statusChangedAt().hashCode());
        hashCode = 31 * hashCode + (this.errorCode() == null ? 0 : this.errorCode().hashCode());
        hashCode = 31 * hashCode + (this.errorDetails() == null ? 0 : this.errorDetails().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Operation)) {
            return false;
        }
        Operation other = (Operation)obj;
        if (other.id() == null ^ this.id() == null) {
            return false;
        }
        if (other.id() != null && !other.id().equals(this.id())) {
            return false;
        }
        if (other.resourceName() == null ^ this.resourceName() == null) {
            return false;
        }
        if (other.resourceName() != null && !other.resourceName().equals(this.resourceName())) {
            return false;
        }
        if (other.resourceType() == null ^ this.resourceType() == null) {
            return false;
        }
        if (other.resourceType() != null && !other.resourceType().equals(this.resourceType())) {
            return false;
        }
        if (other.createdAt() == null ^ this.createdAt() == null) {
            return false;
        }
        if (other.createdAt() != null && !other.createdAt().equals(this.createdAt())) {
            return false;
        }
        if (other.location() == null ^ this.location() == null) {
            return false;
        }
        if (other.location() != null && !other.location().equals(this.location())) {
            return false;
        }
        if (other.isTerminal() == null ^ this.isTerminal() == null) {
            return false;
        }
        if (other.isTerminal() != null && !other.isTerminal().equals(this.isTerminal())) {
            return false;
        }
        if (other.operationDetails() == null ^ this.operationDetails() == null) {
            return false;
        }
        if (other.operationDetails() != null && !other.operationDetails().equals(this.operationDetails())) {
            return false;
        }
        if (other.operationType() == null ^ this.operationType() == null) {
            return false;
        }
        if (other.operationType() != null && !other.operationType().equals(this.operationType())) {
            return false;
        }
        if (other.status() == null ^ this.status() == null) {
            return false;
        }
        if (other.status() != null && !other.status().equals(this.status())) {
            return false;
        }
        if (other.statusChangedAt() == null ^ this.statusChangedAt() == null) {
            return false;
        }
        if (other.statusChangedAt() != null && !other.statusChangedAt().equals(this.statusChangedAt())) {
            return false;
        }
        if (other.errorCode() == null ^ this.errorCode() == null) {
            return false;
        }
        if (other.errorCode() != null && !other.errorCode().equals(this.errorCode())) {
            return false;
        }
        if (other.errorDetails() == null ^ this.errorDetails() == null) {
            return false;
        }
        return other.errorDetails() == null || other.errorDetails().equals(this.errorDetails());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.id() != null) {
            sb.append("Id: ").append(this.id()).append(",");
        }
        if (this.resourceName() != null) {
            sb.append("ResourceName: ").append(this.resourceName()).append(",");
        }
        if (this.resourceType() != null) {
            sb.append("ResourceType: ").append(this.resourceType()).append(",");
        }
        if (this.createdAt() != null) {
            sb.append("CreatedAt: ").append(this.createdAt()).append(",");
        }
        if (this.location() != null) {
            sb.append("Location: ").append(this.location()).append(",");
        }
        if (this.isTerminal() != null) {
            sb.append("IsTerminal: ").append(this.isTerminal()).append(",");
        }
        if (this.operationDetails() != null) {
            sb.append("OperationDetails: ").append(this.operationDetails()).append(",");
        }
        if (this.operationType() != null) {
            sb.append("OperationType: ").append(this.operationType()).append(",");
        }
        if (this.status() != null) {
            sb.append("Status: ").append(this.status()).append(",");
        }
        if (this.statusChangedAt() != null) {
            sb.append("StatusChangedAt: ").append(this.statusChangedAt()).append(",");
        }
        if (this.errorCode() != null) {
            sb.append("ErrorCode: ").append(this.errorCode()).append(",");
        }
        if (this.errorDetails() != null) {
            sb.append("ErrorDetails: ").append(this.errorDetails()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        OperationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String id;
        private String resourceName;
        private String resourceType;
        private Instant createdAt;
        private ResourceLocation location;
        private Boolean isTerminal;
        private String operationDetails;
        private String operationType;
        private String status;
        private Instant statusChangedAt;
        private String errorCode;
        private String errorDetails;

        private BuilderImpl() {
        }

        private BuilderImpl(Operation model) {
            this.setId(model.id);
            this.setResourceName(model.resourceName);
            this.setResourceType(model.resourceType);
            this.setCreatedAt(model.createdAt);
            this.setLocation(model.location);
            this.setIsTerminal(model.isTerminal);
            this.setOperationDetails(model.operationDetails);
            this.setOperationType(model.operationType);
            this.setStatus(model.status);
            this.setStatusChangedAt(model.statusChangedAt);
            this.setErrorCode(model.errorCode);
            this.setErrorDetails(model.errorDetails);
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getResourceName() {
            return this.resourceName;
        }

        @Override
        public final Builder resourceName(String resourceName) {
            this.resourceName = resourceName;
            return this;
        }

        public final void setResourceName(String resourceName) {
            this.resourceName = resourceName;
        }

        public final String getResourceType() {
            return this.resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public final Builder resourceType(ResourceType resourceType) {
            this.resourceType(resourceType.toString());
            return this;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        public final ResourceLocation getLocation() {
            return this.location;
        }

        @Override
        public final Builder location(ResourceLocation location) {
            this.location = location;
            return this;
        }

        public final void setLocation(ResourceLocation location) {
            this.location = location;
        }

        public final Boolean getIsTerminal() {
            return this.isTerminal;
        }

        @Override
        public final Builder isTerminal(Boolean isTerminal) {
            this.isTerminal = isTerminal;
            return this;
        }

        public final void setIsTerminal(Boolean isTerminal) {
            this.isTerminal = isTerminal;
        }

        public final String getOperationDetails() {
            return this.operationDetails;
        }

        @Override
        public final Builder operationDetails(String operationDetails) {
            this.operationDetails = operationDetails;
            return this;
        }

        public final void setOperationDetails(String operationDetails) {
            this.operationDetails = operationDetails;
        }

        public final String getOperationType() {
            return this.operationType;
        }

        @Override
        public final Builder operationType(String operationType) {
            this.operationType = operationType;
            return this;
        }

        @Override
        public final Builder operationType(OperationType operationType) {
            this.operationType(operationType.toString());
            return this;
        }

        public final void setOperationType(String operationType) {
            this.operationType = operationType;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(OperationStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Instant getStatusChangedAt() {
            return this.statusChangedAt;
        }

        @Override
        public final Builder statusChangedAt(Instant statusChangedAt) {
            this.statusChangedAt = statusChangedAt;
            return this;
        }

        public final void setStatusChangedAt(Instant statusChangedAt) {
            this.statusChangedAt = statusChangedAt;
        }

        public final String getErrorCode() {
            return this.errorCode;
        }

        @Override
        public final Builder errorCode(String errorCode) {
            this.errorCode = errorCode;
            return this;
        }

        public final void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        public final String getErrorDetails() {
            return this.errorDetails;
        }

        @Override
        public final Builder errorDetails(String errorDetails) {
            this.errorDetails = errorDetails;
            return this;
        }

        public final void setErrorDetails(String errorDetails) {
            this.errorDetails = errorDetails;
        }

        public Operation build() {
            return new Operation(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Operation> {
        public Builder id(String var1);

        public Builder resourceName(String var1);

        public Builder resourceType(String var1);

        public Builder resourceType(ResourceType var1);

        public Builder createdAt(Instant var1);

        public Builder location(ResourceLocation var1);

        public Builder isTerminal(Boolean var1);

        public Builder operationDetails(String var1);

        public Builder operationType(String var1);

        public Builder operationType(OperationType var1);

        public Builder status(String var1);

        public Builder status(OperationStatus var1);

        public Builder statusChangedAt(Instant var1);

        public Builder errorCode(String var1);

        public Builder errorDetails(String var1);
    }
}

