/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.transform;

import java.util.List;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.MarshallLocation;
import software.amazon.awssdk.protocol.MarshallingInfo;
import software.amazon.awssdk.protocol.MarshallingType;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.lightsail.model.InstanceHardware;

@SdkInternalApi
public class InstanceHardwareMarshaller {
    private static final MarshallingInfo<Integer> CPUCOUNT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("cpuCount").build();
    private static final MarshallingInfo<List> DISKS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("disks").build();
    private static final MarshallingInfo<Float> RAMSIZEINGB_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.FLOAT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ramSizeInGb").build();
    private static final InstanceHardwareMarshaller INSTANCE = new InstanceHardwareMarshaller();

    public static InstanceHardwareMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(InstanceHardware instanceHardware, ProtocolMarshaller protocolMarshaller) {
        if (instanceHardware == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)instanceHardware.cpuCount(), CPUCOUNT_BINDING);
            protocolMarshaller.marshall(instanceHardware.disks(), DISKS_BINDING);
            protocolMarshaller.marshall((Object)instanceHardware.ramSizeInGb(), RAMSIZEINGB_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

