/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.transform;

import java.time.Instant;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.MarshallLocation;
import software.amazon.awssdk.protocol.MarshallingInfo;
import software.amazon.awssdk.protocol.MarshallingType;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.lightsail.model.Operation;

@SdkInternalApi
public class OperationMarshaller {
    private static final MarshallingInfo<String> ID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("id").build();
    private static final MarshallingInfo<String> RESOURCENAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("resourceName").build();
    private static final MarshallingInfo<String> RESOURCETYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("resourceType").build();
    private static final MarshallingInfo<Instant> CREATEDAT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("createdAt").build();
    private static final MarshallingInfo<StructuredPojo> LOCATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("location").build();
    private static final MarshallingInfo<Boolean> ISTERMINAL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("isTerminal").build();
    private static final MarshallingInfo<String> OPERATIONDETAILS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("operationDetails").build();
    private static final MarshallingInfo<String> OPERATIONTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("operationType").build();
    private static final MarshallingInfo<String> STATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("status").build();
    private static final MarshallingInfo<Instant> STATUSCHANGEDAT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("statusChangedAt").build();
    private static final MarshallingInfo<String> ERRORCODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("errorCode").build();
    private static final MarshallingInfo<String> ERRORDETAILS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("errorDetails").build();
    private static final OperationMarshaller INSTANCE = new OperationMarshaller();

    public static OperationMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(Operation operation, ProtocolMarshaller protocolMarshaller) {
        if (operation == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)operation.id(), ID_BINDING);
            protocolMarshaller.marshall((Object)operation.resourceName(), RESOURCENAME_BINDING);
            protocolMarshaller.marshall((Object)operation.resourceType(), RESOURCETYPE_BINDING);
            protocolMarshaller.marshall((Object)operation.createdAt(), CREATEDAT_BINDING);
            protocolMarshaller.marshall((Object)operation.location(), LOCATION_BINDING);
            protocolMarshaller.marshall((Object)operation.isTerminal(), ISTERMINAL_BINDING);
            protocolMarshaller.marshall((Object)operation.operationDetails(), OPERATIONDETAILS_BINDING);
            protocolMarshaller.marshall((Object)operation.operationType(), OPERATIONTYPE_BINDING);
            protocolMarshaller.marshall((Object)operation.status(), STATUS_BINDING);
            protocolMarshaller.marshall((Object)operation.statusChangedAt(), STATUSCHANGEDAT_BINDING);
            protocolMarshaller.marshall((Object)operation.errorCode(), ERRORCODE_BINDING);
            protocolMarshaller.marshall((Object)operation.errorDetails(), ERRORDETAILS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

