/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class CreateDomainEntryRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<CreateDomainEntryRequest.Builder, CreateDomainEntryRequest> {
    private final String domainName;

    private final DomainEntry domainEntry;

    private CreateDomainEntryRequest(BuilderImpl builder) {
        this.domainName = builder.domainName;
        this.domainEntry = builder.domainEntry;
    }

    /**
     * <p>
     * The domain name (e.g., <code>example.com</code>) for which you want to create the domain entry.
     * </p>
     * 
     * @return The domain name (e.g., <code>example.com</code>) for which you want to create the domain entry.
     */
    public String domainName() {
        return domainName;
    }

    /**
     * <p>
     * An array of key-value pairs containing information about the domain entry request.
     * </p>
     * 
     * @return An array of key-value pairs containing information about the domain entry request.
     */
    public DomainEntry domainEntry() {
        return domainEntry;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((domainName() == null) ? 0 : domainName().hashCode());
        hashCode = 31 * hashCode + ((domainEntry() == null) ? 0 : domainEntry().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDomainEntryRequest)) {
            return false;
        }
        CreateDomainEntryRequest other = (CreateDomainEntryRequest) obj;
        if (other.domainName() == null ^ this.domainName() == null) {
            return false;
        }
        if (other.domainName() != null && !other.domainName().equals(this.domainName())) {
            return false;
        }
        if (other.domainEntry() == null ^ this.domainEntry() == null) {
            return false;
        }
        if (other.domainEntry() != null && !other.domainEntry().equals(this.domainEntry())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (domainName() != null) {
            sb.append("DomainName: ").append(domainName()).append(",");
        }
        if (domainEntry() != null) {
            sb.append("DomainEntry: ").append(domainEntry()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, CreateDomainEntryRequest> {
        /**
         * <p>
         * The domain name (e.g., <code>example.com</code>) for which you want to create the domain entry.
         * </p>
         * 
         * @param domainName
         *        The domain name (e.g., <code>example.com</code>) for which you want to create the domain entry.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainName(String domainName);

        /**
         * <p>
         * An array of key-value pairs containing information about the domain entry request.
         * </p>
         * 
         * @param domainEntry
         *        An array of key-value pairs containing information about the domain entry request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainEntry(DomainEntry domainEntry);
    }

    private static final class BuilderImpl implements Builder {
        private String domainName;

        private DomainEntry domainEntry;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDomainEntryRequest model) {
            setDomainName(model.domainName);
            setDomainEntry(model.domainEntry);
        }

        public final String getDomainName() {
            return domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        public final DomainEntry getDomainEntry() {
            return domainEntry;
        }

        @Override
        public final Builder domainEntry(DomainEntry domainEntry) {
            this.domainEntry = domainEntry;
            return this;
        }

        public final void setDomainEntry(DomainEntry domainEntry) {
            this.domainEntry = domainEntry;
        }

        @Override
        public CreateDomainEntryRequest build() {
            return new CreateDomainEntryRequest(this);
        }
    }
}
