/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class DeleteInstanceSnapshotRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<DeleteInstanceSnapshotRequest.Builder, DeleteInstanceSnapshotRequest> {
    private final String instanceSnapshotName;

    private DeleteInstanceSnapshotRequest(BuilderImpl builder) {
        this.instanceSnapshotName = builder.instanceSnapshotName;
    }

    /**
     * <p>
     * The name of the snapshot to delete.
     * </p>
     * 
     * @return The name of the snapshot to delete.
     */
    public String instanceSnapshotName() {
        return instanceSnapshotName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((instanceSnapshotName() == null) ? 0 : instanceSnapshotName().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteInstanceSnapshotRequest)) {
            return false;
        }
        DeleteInstanceSnapshotRequest other = (DeleteInstanceSnapshotRequest) obj;
        if (other.instanceSnapshotName() == null ^ this.instanceSnapshotName() == null) {
            return false;
        }
        if (other.instanceSnapshotName() != null && !other.instanceSnapshotName().equals(this.instanceSnapshotName())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (instanceSnapshotName() != null) {
            sb.append("InstanceSnapshotName: ").append(instanceSnapshotName()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, DeleteInstanceSnapshotRequest> {
        /**
         * <p>
         * The name of the snapshot to delete.
         * </p>
         * 
         * @param instanceSnapshotName
         *        The name of the snapshot to delete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceSnapshotName(String instanceSnapshotName);
    }

    private static final class BuilderImpl implements Builder {
        private String instanceSnapshotName;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteInstanceSnapshotRequest model) {
            setInstanceSnapshotName(model.instanceSnapshotName);
        }

        public final String getInstanceSnapshotName() {
            return instanceSnapshotName;
        }

        @Override
        public final Builder instanceSnapshotName(String instanceSnapshotName) {
            this.instanceSnapshotName = instanceSnapshotName;
            return this;
        }

        public final void setInstanceSnapshotName(String instanceSnapshotName) {
            this.instanceSnapshotName = instanceSnapshotName;
        }

        @Override
        public DeleteInstanceSnapshotRequest build() {
            return new DeleteInstanceSnapshotRequest(this);
        }
    }
}
