/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class DetachStaticIpRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<DetachStaticIpRequest.Builder, DetachStaticIpRequest> {
    private final String staticIpName;

    private DetachStaticIpRequest(BuilderImpl builder) {
        this.staticIpName = builder.staticIpName;
    }

    /**
     * <p>
     * The name of the static IP to detach from the instance.
     * </p>
     * 
     * @return The name of the static IP to detach from the instance.
     */
    public String staticIpName() {
        return staticIpName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((staticIpName() == null) ? 0 : staticIpName().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DetachStaticIpRequest)) {
            return false;
        }
        DetachStaticIpRequest other = (DetachStaticIpRequest) obj;
        if (other.staticIpName() == null ^ this.staticIpName() == null) {
            return false;
        }
        if (other.staticIpName() != null && !other.staticIpName().equals(this.staticIpName())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (staticIpName() != null) {
            sb.append("StaticIpName: ").append(staticIpName()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, DetachStaticIpRequest> {
        /**
         * <p>
         * The name of the static IP to detach from the instance.
         * </p>
         * 
         * @param staticIpName
         *        The name of the static IP to detach from the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder staticIpName(String staticIpName);
    }

    private static final class BuilderImpl implements Builder {
        private String staticIpName;

        private BuilderImpl() {
        }

        private BuilderImpl(DetachStaticIpRequest model) {
            setStaticIpName(model.staticIpName);
        }

        public final String getStaticIpName() {
            return staticIpName;
        }

        @Override
        public final Builder staticIpName(String staticIpName) {
            this.staticIpName = staticIpName;
            return this;
        }

        public final void setStaticIpName(String staticIpName) {
            this.staticIpName = staticIpName;
        }

        @Override
        public DetachStaticIpRequest build() {
            return new DetachStaticIpRequest(this);
        }
    }
}
