/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class DownloadDefaultKeyPairResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<DownloadDefaultKeyPairResponse.Builder, DownloadDefaultKeyPairResponse> {
    private final String publicKeyBase64;

    private final String privateKeyBase64;

    private DownloadDefaultKeyPairResponse(BuilderImpl builder) {
        this.publicKeyBase64 = builder.publicKeyBase64;
        this.privateKeyBase64 = builder.privateKeyBase64;
    }

    /**
     * <p>
     * A base64-encoded public key of the <code>ssh-rsa</code> type.
     * </p>
     * 
     * @return A base64-encoded public key of the <code>ssh-rsa</code> type.
     */
    public String publicKeyBase64() {
        return publicKeyBase64;
    }

    /**
     * <p>
     * A base64-encoded RSA private key.
     * </p>
     * 
     * @return A base64-encoded RSA private key.
     */
    public String privateKeyBase64() {
        return privateKeyBase64;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((publicKeyBase64() == null) ? 0 : publicKeyBase64().hashCode());
        hashCode = 31 * hashCode + ((privateKeyBase64() == null) ? 0 : privateKeyBase64().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DownloadDefaultKeyPairResponse)) {
            return false;
        }
        DownloadDefaultKeyPairResponse other = (DownloadDefaultKeyPairResponse) obj;
        if (other.publicKeyBase64() == null ^ this.publicKeyBase64() == null) {
            return false;
        }
        if (other.publicKeyBase64() != null && !other.publicKeyBase64().equals(this.publicKeyBase64())) {
            return false;
        }
        if (other.privateKeyBase64() == null ^ this.privateKeyBase64() == null) {
            return false;
        }
        if (other.privateKeyBase64() != null && !other.privateKeyBase64().equals(this.privateKeyBase64())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (publicKeyBase64() != null) {
            sb.append("PublicKeyBase64: ").append(publicKeyBase64()).append(",");
        }
        if (privateKeyBase64() != null) {
            sb.append("PrivateKeyBase64: ").append(privateKeyBase64()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, DownloadDefaultKeyPairResponse> {
        /**
         * <p>
         * A base64-encoded public key of the <code>ssh-rsa</code> type.
         * </p>
         * 
         * @param publicKeyBase64
         *        A base64-encoded public key of the <code>ssh-rsa</code> type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder publicKeyBase64(String publicKeyBase64);

        /**
         * <p>
         * A base64-encoded RSA private key.
         * </p>
         * 
         * @param privateKeyBase64
         *        A base64-encoded RSA private key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder privateKeyBase64(String privateKeyBase64);
    }

    private static final class BuilderImpl implements Builder {
        private String publicKeyBase64;

        private String privateKeyBase64;

        private BuilderImpl() {
        }

        private BuilderImpl(DownloadDefaultKeyPairResponse model) {
            setPublicKeyBase64(model.publicKeyBase64);
            setPrivateKeyBase64(model.privateKeyBase64);
        }

        public final String getPublicKeyBase64() {
            return publicKeyBase64;
        }

        @Override
        public final Builder publicKeyBase64(String publicKeyBase64) {
            this.publicKeyBase64 = publicKeyBase64;
            return this;
        }

        public final void setPublicKeyBase64(String publicKeyBase64) {
            this.publicKeyBase64 = publicKeyBase64;
        }

        public final String getPrivateKeyBase64() {
            return privateKeyBase64;
        }

        @Override
        public final Builder privateKeyBase64(String privateKeyBase64) {
            this.privateKeyBase64 = privateKeyBase64;
            return this;
        }

        public final void setPrivateKeyBase64(String privateKeyBase64) {
            this.privateKeyBase64 = privateKeyBase64;
        }

        @Override
        public DownloadDefaultKeyPairResponse build() {
            return new DownloadDefaultKeyPairResponse(this);
        }
    }
}
