/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class GetActiveNamesResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<GetActiveNamesResponse.Builder, GetActiveNamesResponse> {
    private final List<String> activeNames;

    private final String nextPageToken;

    private GetActiveNamesResponse(BuilderImpl builder) {
        this.activeNames = builder.activeNames;
        this.nextPageToken = builder.nextPageToken;
    }

    /**
     * <p>
     * The list of active names returned by the get active names request.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The list of active names returned by the get active names request.
     */
    public List<String> activeNames() {
        return activeNames;
    }

    /**
     * <p>
     * A token used for advancing to the next page of results from your get active names request.
     * </p>
     * 
     * @return A token used for advancing to the next page of results from your get active names request.
     */
    public String nextPageToken() {
        return nextPageToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((activeNames() == null) ? 0 : activeNames().hashCode());
        hashCode = 31 * hashCode + ((nextPageToken() == null) ? 0 : nextPageToken().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetActiveNamesResponse)) {
            return false;
        }
        GetActiveNamesResponse other = (GetActiveNamesResponse) obj;
        if (other.activeNames() == null ^ this.activeNames() == null) {
            return false;
        }
        if (other.activeNames() != null && !other.activeNames().equals(this.activeNames())) {
            return false;
        }
        if (other.nextPageToken() == null ^ this.nextPageToken() == null) {
            return false;
        }
        if (other.nextPageToken() != null && !other.nextPageToken().equals(this.nextPageToken())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (activeNames() != null) {
            sb.append("ActiveNames: ").append(activeNames()).append(",");
        }
        if (nextPageToken() != null) {
            sb.append("NextPageToken: ").append(nextPageToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, GetActiveNamesResponse> {
        /**
         * <p>
         * The list of active names returned by the get active names request.
         * </p>
         * 
         * @param activeNames
         *        The list of active names returned by the get active names request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder activeNames(Collection<String> activeNames);

        /**
         * <p>
         * The list of active names returned by the get active names request.
         * </p>
         * 
         * @param activeNames
         *        The list of active names returned by the get active names request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder activeNames(String... activeNames);

        /**
         * <p>
         * A token used for advancing to the next page of results from your get active names request.
         * </p>
         * 
         * @param nextPageToken
         *        A token used for advancing to the next page of results from your get active names request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextPageToken(String nextPageToken);
    }

    private static final class BuilderImpl implements Builder {
        private List<String> activeNames;

        private String nextPageToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetActiveNamesResponse model) {
            setActiveNames(model.activeNames);
            setNextPageToken(model.nextPageToken);
        }

        public final Collection<String> getActiveNames() {
            return activeNames;
        }

        @Override
        public final Builder activeNames(Collection<String> activeNames) {
            this.activeNames = StringListCopier.copy(activeNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder activeNames(String... activeNames) {
            activeNames(Arrays.asList(activeNames));
            return this;
        }

        public final void setActiveNames(Collection<String> activeNames) {
            this.activeNames = StringListCopier.copy(activeNames);
        }

        public final String getNextPageToken() {
            return nextPageToken;
        }

        @Override
        public final Builder nextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
            return this;
        }

        public final void setNextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
        }

        @Override
        public GetActiveNamesResponse build() {
            return new GetActiveNamesResponse(this);
        }
    }
}
