/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class GetDomainResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<GetDomainResponse.Builder, GetDomainResponse> {
    private final Domain domain;

    private GetDomainResponse(BuilderImpl builder) {
        this.domain = builder.domain;
    }

    /**
     * <p>
     * An array of key-value pairs containing information about your get domain request.
     * </p>
     * 
     * @return An array of key-value pairs containing information about your get domain request.
     */
    public Domain domain() {
        return domain;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((domain() == null) ? 0 : domain().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDomainResponse)) {
            return false;
        }
        GetDomainResponse other = (GetDomainResponse) obj;
        if (other.domain() == null ^ this.domain() == null) {
            return false;
        }
        if (other.domain() != null && !other.domain().equals(this.domain())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (domain() != null) {
            sb.append("Domain: ").append(domain()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, GetDomainResponse> {
        /**
         * <p>
         * An array of key-value pairs containing information about your get domain request.
         * </p>
         * 
         * @param domain
         *        An array of key-value pairs containing information about your get domain request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domain(Domain domain);
    }

    private static final class BuilderImpl implements Builder {
        private Domain domain;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDomainResponse model) {
            setDomain(model.domain);
        }

        public final Domain getDomain() {
            return domain;
        }

        @Override
        public final Builder domain(Domain domain) {
            this.domain = domain;
            return this;
        }

        public final void setDomain(Domain domain) {
            this.domain = domain;
        }

        @Override
        public GetDomainResponse build() {
            return new GetDomainResponse(this);
        }
    }
}
