/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class GetDomainsResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<GetDomainsResponse.Builder, GetDomainsResponse> {
    private final List<Domain> domains;

    private final String nextPageToken;

    private GetDomainsResponse(BuilderImpl builder) {
        this.domains = builder.domains;
        this.nextPageToken = builder.nextPageToken;
    }

    /**
     * <p>
     * An array of key-value pairs containing information about each of the domain entries in the user's account.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return An array of key-value pairs containing information about each of the domain entries in the user's
     *         account.
     */
    public List<Domain> domains() {
        return domains;
    }

    /**
     * <p>
     * A token used for advancing to the next page of results from your get active names request.
     * </p>
     * 
     * @return A token used for advancing to the next page of results from your get active names request.
     */
    public String nextPageToken() {
        return nextPageToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((domains() == null) ? 0 : domains().hashCode());
        hashCode = 31 * hashCode + ((nextPageToken() == null) ? 0 : nextPageToken().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDomainsResponse)) {
            return false;
        }
        GetDomainsResponse other = (GetDomainsResponse) obj;
        if (other.domains() == null ^ this.domains() == null) {
            return false;
        }
        if (other.domains() != null && !other.domains().equals(this.domains())) {
            return false;
        }
        if (other.nextPageToken() == null ^ this.nextPageToken() == null) {
            return false;
        }
        if (other.nextPageToken() != null && !other.nextPageToken().equals(this.nextPageToken())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (domains() != null) {
            sb.append("Domains: ").append(domains()).append(",");
        }
        if (nextPageToken() != null) {
            sb.append("NextPageToken: ").append(nextPageToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, GetDomainsResponse> {
        /**
         * <p>
         * An array of key-value pairs containing information about each of the domain entries in the user's account.
         * </p>
         * 
         * @param domains
         *        An array of key-value pairs containing information about each of the domain entries in the user's
         *        account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domains(Collection<Domain> domains);

        /**
         * <p>
         * An array of key-value pairs containing information about each of the domain entries in the user's account.
         * </p>
         * 
         * @param domains
         *        An array of key-value pairs containing information about each of the domain entries in the user's
         *        account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domains(Domain... domains);

        /**
         * <p>
         * A token used for advancing to the next page of results from your get active names request.
         * </p>
         * 
         * @param nextPageToken
         *        A token used for advancing to the next page of results from your get active names request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextPageToken(String nextPageToken);
    }

    private static final class BuilderImpl implements Builder {
        private List<Domain> domains;

        private String nextPageToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDomainsResponse model) {
            setDomains(model.domains);
            setNextPageToken(model.nextPageToken);
        }

        public final Collection<Domain> getDomains() {
            return domains;
        }

        @Override
        public final Builder domains(Collection<Domain> domains) {
            this.domains = DomainListCopier.copy(domains);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder domains(Domain... domains) {
            domains(Arrays.asList(domains));
            return this;
        }

        public final void setDomains(Collection<Domain> domains) {
            this.domains = DomainListCopier.copy(domains);
        }

        public final String getNextPageToken() {
            return nextPageToken;
        }

        @Override
        public final Builder nextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
            return this;
        }

        public final void setNextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
        }

        @Override
        public GetDomainsResponse build() {
            return new GetDomainsResponse(this);
        }
    }
}
