/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class GetInstanceMetricDataResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<GetInstanceMetricDataResponse.Builder, GetInstanceMetricDataResponse> {
    private final String metricName;

    private final List<MetricDatapoint> metricData;

    private GetInstanceMetricDataResponse(BuilderImpl builder) {
        this.metricName = builder.metricName;
        this.metricData = builder.metricData;
    }

    /**
     * <p>
     * The metric name to return data for.
     * </p>
     * 
     * @return The metric name to return data for.
     * @see InstanceMetricName
     */
    public String metricName() {
        return metricName;
    }

    /**
     * <p>
     * An array of key-value pairs containing information about the results of your get instance metric data request.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return An array of key-value pairs containing information about the results of your get instance metric data
     *         request.
     */
    public List<MetricDatapoint> metricData() {
        return metricData;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((metricName() == null) ? 0 : metricName().hashCode());
        hashCode = 31 * hashCode + ((metricData() == null) ? 0 : metricData().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetInstanceMetricDataResponse)) {
            return false;
        }
        GetInstanceMetricDataResponse other = (GetInstanceMetricDataResponse) obj;
        if (other.metricName() == null ^ this.metricName() == null) {
            return false;
        }
        if (other.metricName() != null && !other.metricName().equals(this.metricName())) {
            return false;
        }
        if (other.metricData() == null ^ this.metricData() == null) {
            return false;
        }
        if (other.metricData() != null && !other.metricData().equals(this.metricData())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (metricName() != null) {
            sb.append("MetricName: ").append(metricName()).append(",");
        }
        if (metricData() != null) {
            sb.append("MetricData: ").append(metricData()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, GetInstanceMetricDataResponse> {
        /**
         * <p>
         * The metric name to return data for.
         * </p>
         * 
         * @param metricName
         *        The metric name to return data for.
         * @see InstanceMetricName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InstanceMetricName
         */
        Builder metricName(String metricName);

        /**
         * <p>
         * The metric name to return data for.
         * </p>
         * 
         * @param metricName
         *        The metric name to return data for.
         * @see InstanceMetricName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InstanceMetricName
         */
        Builder metricName(InstanceMetricName metricName);

        /**
         * <p>
         * An array of key-value pairs containing information about the results of your get instance metric data
         * request.
         * </p>
         * 
         * @param metricData
         *        An array of key-value pairs containing information about the results of your get instance metric data
         *        request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricData(Collection<MetricDatapoint> metricData);

        /**
         * <p>
         * An array of key-value pairs containing information about the results of your get instance metric data
         * request.
         * </p>
         * 
         * @param metricData
         *        An array of key-value pairs containing information about the results of your get instance metric data
         *        request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricData(MetricDatapoint... metricData);
    }

    private static final class BuilderImpl implements Builder {
        private String metricName;

        private List<MetricDatapoint> metricData;

        private BuilderImpl() {
        }

        private BuilderImpl(GetInstanceMetricDataResponse model) {
            setMetricName(model.metricName);
            setMetricData(model.metricData);
        }

        public final String getMetricName() {
            return metricName;
        }

        @Override
        public final Builder metricName(String metricName) {
            this.metricName = metricName;
            return this;
        }

        @Override
        public final Builder metricName(InstanceMetricName metricName) {
            this.metricName(metricName.toString());
            return this;
        }

        public final void setMetricName(String metricName) {
            this.metricName = metricName;
        }

        public final Collection<MetricDatapoint> getMetricData() {
            return metricData;
        }

        @Override
        public final Builder metricData(Collection<MetricDatapoint> metricData) {
            this.metricData = MetricDatapointListCopier.copy(metricData);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricData(MetricDatapoint... metricData) {
            metricData(Arrays.asList(metricData));
            return this;
        }

        public final void setMetricData(Collection<MetricDatapoint> metricData) {
            this.metricData = MetricDatapointListCopier.copy(metricData);
        }

        @Override
        public GetInstanceMetricDataResponse build() {
            return new GetInstanceMetricDataResponse(this);
        }
    }
}
