/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class GetInstanceSnapshotResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<GetInstanceSnapshotResponse.Builder, GetInstanceSnapshotResponse> {
    private final InstanceSnapshot instanceSnapshot;

    private GetInstanceSnapshotResponse(BuilderImpl builder) {
        this.instanceSnapshot = builder.instanceSnapshot;
    }

    /**
     * <p>
     * An array of key-value pairs containing information about the results of your get instance snapshot request.
     * </p>
     * 
     * @return An array of key-value pairs containing information about the results of your get instance snapshot
     *         request.
     */
    public InstanceSnapshot instanceSnapshot() {
        return instanceSnapshot;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((instanceSnapshot() == null) ? 0 : instanceSnapshot().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetInstanceSnapshotResponse)) {
            return false;
        }
        GetInstanceSnapshotResponse other = (GetInstanceSnapshotResponse) obj;
        if (other.instanceSnapshot() == null ^ this.instanceSnapshot() == null) {
            return false;
        }
        if (other.instanceSnapshot() != null && !other.instanceSnapshot().equals(this.instanceSnapshot())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (instanceSnapshot() != null) {
            sb.append("InstanceSnapshot: ").append(instanceSnapshot()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, GetInstanceSnapshotResponse> {
        /**
         * <p>
         * An array of key-value pairs containing information about the results of your get instance snapshot request.
         * </p>
         * 
         * @param instanceSnapshot
         *        An array of key-value pairs containing information about the results of your get instance snapshot
         *        request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceSnapshot(InstanceSnapshot instanceSnapshot);
    }

    private static final class BuilderImpl implements Builder {
        private InstanceSnapshot instanceSnapshot;

        private BuilderImpl() {
        }

        private BuilderImpl(GetInstanceSnapshotResponse model) {
            setInstanceSnapshot(model.instanceSnapshot);
        }

        public final InstanceSnapshot getInstanceSnapshot() {
            return instanceSnapshot;
        }

        @Override
        public final Builder instanceSnapshot(InstanceSnapshot instanceSnapshot) {
            this.instanceSnapshot = instanceSnapshot;
            return this;
        }

        public final void setInstanceSnapshot(InstanceSnapshot instanceSnapshot) {
            this.instanceSnapshot = instanceSnapshot;
        }

        @Override
        public GetInstanceSnapshotResponse build() {
            return new GetInstanceSnapshotResponse(this);
        }
    }
}
